
import java.sql.*;


/**
 * test nested statements
 *
 */
public class t0022
{
   static public void main(String args[])
      throws SQLException, java.lang.ClassNotFoundException, java.lang.Exception
   {
      boolean passed = true;

      System.out.println("test nested statements");

      // open the database
      Class.forName("com.internetcds.jdbc.tds.Driver");

      int         i;
      int         count        = 0;
      int         totalInserts = 0;
      int         totalUpdates = 0;
      int         totalQueries = 0;
      int         totalRows    = 0;
      Connection  cx           = Common.getConnection();
      Statement   stmt         = cx.createStatement();
      long        startTime    = System.currentTimeMillis();

      try
      {
         stmt.executeUpdate("drop table t0022a");
         totalUpdates++;
      }
      catch (SQLException e)
      {
         if (! (e.getMessage().startsWith("Cannot drop the table 't0022a', because it does")))
         {
            throw e;
         }
      }
      try
      {
         stmt.executeUpdate("drop table t0022b");
         totalUpdates++;
      }
      catch (SQLException e)
      {
         if (! (e.getMessage().startsWith("Cannot drop the table 't0022b', because it does")))
         {
            throw e;
         }
      }
      
      count = stmt.executeUpdate("create table t0022a             "
                                 + "  (i   integer not null,      "
                                 + "   str char(254) not null)    ");
      totalUpdates++;
      System.out.println("Creating table affected " + count + " rows");
      count = stmt.executeUpdate("create table t0022b             "
                                 + "  (i   integer not null,      "
                                 + "   t   datetime not null)     ");
      totalUpdates++;
      System.out.println("Creating table affected " + count + " rows");
      
      PreparedStatement  pStmtA = cx.prepareStatement(
         "insert into t0022a values (?, ?)");
      PreparedStatement  pStmtB = cx.prepareStatement(
         "insert into t0022b values (?, getdate())");

      final int rowsToAdd = 1000;
      System.out.println("Adding " + rowsToAdd + " rows");
      System.out.print("Have added 0");
      count = 0;
      for(i=1; i<=rowsToAdd; i++)
      {
         if (i%100 == 0)
         {
            System.out.print(".." + i);
         }
         pStmtA.setInt(1, i);
         String tmp = "";
         while(tmp.length()<240)
         {
            tmp = tmp + "row " + i + ". ";
         }
         pStmtA.setString(2, tmp);
         count += pStmtA.executeUpdate();
         totalUpdates++;
   
         pStmtB.setInt(1, i);
         pStmtB.executeUpdate();
         totalUpdates++;
      }
      System.out.println("\nAdded " + count + " rows");
      if (count != rowsToAdd)
      {
         throw new Exception("Did not add the correct number of rows");
      }
      
      Statement  stmtA = cx.createStatement();
      Statement  stmtB = cx.createStatement();

      System.out.print("Processing data.\nHave processed 0");
      count = 0;
      ResultSet  rsA = stmtA.executeQuery("select * from t0022a");
      totalQueries++;
      while(rsA.next())
      {
         totalRows++;
         count++;
         if (count%100 == 0)
         {
            System.out.print(".." + count);
         }

         ResultSet  rsB = stmtB.executeQuery(
            "select * from t0022b where i=" + rsA.getInt("i"));
         totalQueries++;

         if (! rsB.next())
         {
            totalRows++;
            passed = false;
         }
         
         if (rsB.next())
         {
            totalRows++;
            passed = false;
         }
      }
      passed = passed && (count==rowsToAdd);
      System.out.println("");
      System.out.println("Elapsed Time:   " + 
         (System.currentTimeMillis() - startTime) / 1000);
      System.out.println("Updates:        " + totalUpdates);
      System.out.println("Queries:        " + totalQueries);
      System.out.println("Rows retrieved: " + totalRows);

      System.out.println("\n" + (passed ? "Passed" : "Failed") 
                         + " t0022.\n");
      System.exit(passed ? 0 : 1);
   }
}

