
import java.sql.*;




/**
 * Test stored procedure call (sp_who)
 */
public class t0028
{
   static public void main(String args[])
      throws SQLException, java.lang.ClassNotFoundException, java.lang.Exception
   {
      System.out.println("Test stored procedure call (sp_who).");

      boolean   passed = true;


      // open the database
      Class.forName("com.internetcds.jdbc.tds.Driver");

      int         i;
      int         j;
      int         count    = 0;
      Connection  cx       = Common.getConnection();
      Statement   stmt     = cx.createStatement();
      ResultSet   rs       = null;
      
      boolean isResultSet;
      int updateCount;

      int resultSetCount=0;
      int rowCount=0;
      int numberOfUpdates=0;


      isResultSet = stmt.execute("EXEC sp_who");
      System.out.println("execute(EXEC sp_who) returned: " + isResultSet);

      updateCount=stmt.getUpdateCount();

      while (isResultSet || (updateCount!=-1)) {
	if (isResultSet) {
	  resultSetCount++;
	  rs = stmt.getResultSet();

	  ResultSetMetaData rsMeta =  rs.getMetaData();
	  int columnCount = rsMeta.getColumnCount();
	  System.out.println("columnCount: " +
			     Integer.toString(columnCount));
	  for(int n=1; n<= columnCount; n++) {
	    System.out.println(Integer.toString(n) + ": " +
			       rsMeta.getColumnName(n));
	  }

	  while(rs.next()) {
	    rowCount++;
	    for(int n=1; n<= columnCount; n++) {
	      System.out.println(Integer.toString(n) + ": " + 
				 rs.getString(n));
	    }
	  }
	  
	}
	else {
	  numberOfUpdates++;
	  System.out.println("UpdateCount: " +
			     Integer.toString(updateCount));
	}
	isResultSet=stmt.getMoreResults();
	updateCount = stmt.getUpdateCount();
      }

      System.out.println("resultSetCount: " + resultSetCount);
      System.out.println("Total rowCount: " + rowCount);
      System.out.println("Number of updates: " + numberOfUpdates);


      passed = passed && 
	(rowCount>=1) &&
	(numberOfUpdates==0) &&
	(resultSetCount==1);
      if (!passed)
      {
         throw new SQLException("failed.");
      }

      cx.close();

     System.out.println("\n" + (passed ? "Passed" : "Failed") 
                         + " t0028.\n");
      System.exit(passed ? 0 : 1);
   }
}


