
import java.sql.*;


/**
 * test ResultSetMetaData.isReadonly, ResultSetMetaData.isNullable,
 *      ResultSetMetaData.isAutoIncrement
 *
 */
public class t0047
{
   static public void main(String args[])
      throws SQLException, java.lang.ClassNotFoundException,
      java.lang.Exception
   {
      boolean passed = true;





      int         i;
      int         count    = 0;
      Connection  cx       = Common.getConnection();
      Statement   stmt     = cx.createStatement();

      try
      {
         stmt.executeUpdate("drop table t0047");
      }
      catch (SQLException e)
      {
         if (! (e.getMessage().startsWith("Cannot drop the table 't0047', because it does")))
         {
            throw e;
         }
      }

      String query = 
         "create table t0047              " + 
         "(                               " +
         "  t1   datetime not null,       " + 
         "  t2   datetime null,           " +  
         "  t3   smalldatetime not null,  " + 
         "  t4   smalldatetime null       " + 
         ")";
         
         
      count = stmt.executeUpdate(query);

      System.out.println("Creating table affected " + count + " rows");
 
      query = 
         "insert into t0047 (t1, t2, t3, t4) " + 
         " values('2000-01-02 19:35:01.333', " +
         "        '2000-01-02 19:35:01.333', " +
         "        '2000-01-02 19:35:01.333', " +
         "        '2000-01-02 19:35:01.333'  " +
         ")";
      count = stmt.executeUpdate(query);
      passed = passed && count == 1;


      query = ("select t1, t2, t3, t4 from t0047");
      ResultSet          rs = stmt.executeQuery(query);

      rs.next();
      java.sql.Timestamp  t1 = rs.getTimestamp("t1");
      java.sql.Timestamp  t2 = rs.getTimestamp("t2");
      java.sql.Timestamp  t3 = rs.getTimestamp("t3");
      java.sql.Timestamp  t4 = rs.getTimestamp("t4");
      System.out.println("t1 is " + t1);
      System.out.println("t2 is " + t2);
      System.out.println("t3 is " + t3);
      System.out.println("t4 is " + t4);
      

      java.sql.Timestamp r1 = new java.sql.Timestamp(100, 0, 2, 19, 35, 1, 333000000);
      java.sql.Timestamp r2 = new java.sql.Timestamp(100, 0, 2, 19, 35, 0, 0);

      passed = passed && r1.equals(t1);
      System.out.println("t1 passed is " + r1.equals(t1));
      passed = passed && r1.equals(t2);
      System.out.println("t1 passed is " + r1.equals(t2));
      passed = passed && r2.equals(t3);
      System.out.println("t1 passed is " + r2.equals(t4));
      passed = passed && r2.equals(t4);
      System.out.println("t1 passed is " + r2.equals(t4));


      System.out.println("\n" + (passed ? "Passed" : "Failed") 
                         + " t0047.\n");
      System.exit(passed ? 0 : 1);
   }
}

