
import java.sql.*;


/**
 * test getting timestamps from the database.
 *
 */
public class t0057
{
   static public void main(String args[])
      throws SQLException, java.lang.ClassNotFoundException 
   {
      boolean    passed = true;

      System.out.println("test putting a zero length string into a parameter");

      // open the database
      
      int         count    = 0;
      Connection  cx       = Common.getConnection();
      Statement   stmt     = cx.createStatement();
      
      try
      {
         stmt.executeUpdate("drop table t0057");
      }
      catch (SQLException e)
      {
         if (! (e.getMessage().startsWith("Cannot drop the table 't0057', because it does")))
         {
            System.out.println("|" + e.getMessage() + "|");
            throw e;
         }
      }
      
      count = stmt.executeUpdate("create table t0057          "
                                 + " (a varchar(10) not null, "
                                 + "  b char(10)    not null) ");
      System.out.println("Creating table affected " + count + " rows");
      
      PreparedStatement  pStmt = cx.prepareStatement( 
         "insert into t0057 values (?, ?)");      
      pStmt.setString(1, "");
      pStmt.setString(2, "");
      count = pStmt.executeUpdate();
      System.out.println("Added " + count + " rows");
      if (count != 1) 
      {
         System.out.println("Failed to add rows");
         passed = false;
      }
      else
      {
         pStmt = cx.prepareStatement("select a, b from t0057");
      
         ResultSet  rs = pStmt.executeQuery();
         if (!rs.next())
         {
            passed = false;
            System.out.println("Couldn't read rows from table.");
         }
         else
         {
            System.out.println("a is |" + rs.getString("a") + "|");
            System.out.println("b is |" + rs.getString("b") + "|");
            passed = passed && (rs.getString("a").equals(""));
            passed = passed && (rs.getString("b").equals("          "));
         }
      }
      
      System.out.println("\n" + (passed ? "Passed" : "Failed") 
                         + " t0057.\n");
      System.exit(passed ? 0 : 1);
   }
}

