/*
 * PhasesBase.java
 *
 * Created on December 24, 2003, 10:09 AM
 */

package com.sun.enterprise.config.backup.phase;

import com.sun.enterprise.config.backup.status.Status;
import com.sun.enterprise.config.backup.status.StatusConstants;
import com.sun.enterprise.config.backup.utils.LocalStringsHelper;
import com.sun.enterprise.config.backup.StatusRegistry;
import com.sun.enterprise.config.backup.ActiveAssistanceManager;
import com.sun.enterprise.config.backup.utils.BackupHelper;
import com.sun.enterprise.config.backup.BackupAbortException;
import com.sun.enterprise.config.backup.utils.FactoryHelper;
/**
 *
 * @author  sridatta
 */
public class PhasesBase {
    
    /** Creates a new instance of PhasesBase */
    public PhasesBase() {
    }
    
    public void setStatusInRegistry(Status s) {
        StatusRegistry.setStatus(s);
    }
    
    protected Status getStatusFromRegistry() {
        return StatusRegistry.getStatus();
    }
    
    public void lock() {
        FactoryHelper.getSynchronizer().lock();
    }
    
    public void unlock() {
        FactoryHelper.getSynchronizer().release();
    }
    
    public void setSuccess() {
        Status status = getStatusFromRegistry();
        if(StatusConstants.STATUS_FAILURE.equals(status)) {
            throw new BackupAbortException(
                "status_failure",
                LocalStringsHelper.getString("status_failure"));
        }
        
        try {
           status.setStatusCode(StatusConstants.STATUS_SUCCESS);
        } catch(Exception e) {
            //ignore.
        }
    }
    
    public void setFailure(Exception e) {
        BackupHelper.setExceptionInStatus(getStatusFromRegistry(), e);
    }
    
    public void addHistory() {
        BackupHelper.addHistoryEntrySafe(getStatusFromRegistry());
    }
    
    public void addAssistance() {
        new ActiveAssistanceManager().assist(getStatusFromRegistry());
    }
    
    public void assertStatusNotFailed() {
        if(StatusConstants.STATUS_FAILURE.equals(getStatusFromRegistry().getStatusCode())) {
            //already failed before. abort
            throw new BackupAbortException(
                "error_status_failed",
                LocalStringsHelper.getString("error_status_failed"));
        }
    }

}
