/*********************************************************************
 *
 *	Copyright (C) 2001-2002 Nathan Fiedler
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * PROJECT:     Utilities
 * MODULE:      EventListenerList Test
 * FILE:        TestEventListenerList.java
 *
 * AUTHOR:      Nathan Fiedler
 *
 * REVISION HISTORY:
 *      Name    Date            Description
 *      ----    ----            -----------
 *      nf      08/14/01        Initial version
 *      nf      01/12/02        Improved output
 *
 * DESCRIPTION:
 *      Implements test-wrapper for the EventListenerList class.
 *
 * $Id: TestEventListenerList.java,v 1.2 2002/01/12 20:11:42 nfiedler Exp $
 *
 ********************************************************************/

package com.bluemarsh.util.test;

import com.bluemarsh.util.EventListenerList;
import java.util.EventListener;

/**
 * Test-wrapper for the EventListenerList class.
 *
 * @author  Nathan Fiedler
 */
public class TestEventListenerList {

    /**
     * Main method, tests the EventListenerList class.
     *
     * @param  args  command-line string arguments
     */
    public static void main(String[] args) {
        System.out.println();
        System.out.println("  + = good");
        System.out.println("  - = bad");
        System.out.println("  ! = information");
        System.out.println("  ? = verify manually");
        System.out.println();

        EventListenerList list = new EventListenerList();

        if (list.getListenerCount() == 0) {
            System.out.println("+ count is zero");
        } else {
            System.out.println("- count is not zero");
            return;
        }

        System.out.println("! adding two instances of TestListener...");
        list.add(TestListener.class, new TestListener());
        list.add(TestListener.class, new TestListener());

        if (list.getListenerCount() == 2) {
            System.out.println("+ count is two");
        } else {
            System.out.println("- count is not two");
            return;
        }

        System.out.println("! adding three instances of TesteeListener...");
        list.add(TesteeListener.class, new TesteeListener());
        TesteeListener l1 = new TesteeListener();
        list.add(TesteeListener.class, l1);
        list.add(TesteeListener.class, new TesteeListener());

        if (list.getListenerCount() == 5) {
            System.out.println("+ count is five");
        } else {
            System.out.println("- count is not five");
            return;
        }

        if (list.getListenerCount(TesteeListener.class) == 3) {
            System.out.println("+ number of TesteeListeners is three");
        } else {
            System.out.println("- number of TesteeListeners is not three");
            return;
        }

        Object[] array = list.getListenerList();
        if (array.length == 10) {
            System.out.println("+ array length is 10");
        } else {
            System.out.println("- array length is not 10");
            return;
        }

        EventListener[] arr2 = list.getListeners(TesteeListener.class);
        if (arr2.length == 3) {
            System.out.println("+ testee array length is 3");
        } else {
            System.out.println("- testee array length is not 3");
            return;
        }

        System.out.println("! removing second TesteeListener...");
        list.remove(TesteeListener.class, l1);

        if (list.getListenerCount() == 4) {
            System.out.println("+ count is four");
        } else {
            System.out.println("- count is not four");
            return;
        }

        if (list.getListenerCount(TesteeListener.class) == 2) {
            System.out.println("+ number of TesteeListeners is two");
        } else {
            System.out.println("- number of TesteeListeners is not two");
            return;
        }
    } // main

    /**
     * Implementation of an event listener.
     */
    protected static class TestListener implements EventListener {
    } // TestListener

    /**
     * Another implementation of an event listener.
     */
    protected static class TesteeListener implements EventListener {
    } // TesteeListener
} // TestEventListenerList
