/***************************************************************************
                          setilocation.cpp  -  description
                             -------------------
    begin                : Wed Apr 10 2002
    copyright            : (C) 2002 by Sebastian Schildt
    email                : sebastian@frozenlight.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "setilocation.h"

SetiLocation::SetiLocation(QString p){
	currentState=STOPPED;
	proc=-1;
	procIncrease=true;
	path=p;

	//cout << "RUNNING, STOPPED, FINISHED, CONNECT, TRANSFER, UNKNOWN " << endl;
	//cout << RUNNING << STOPPED << FINISHED << CONNECT << TRANSFER << UNKNOWN << endl;

	wu       = new QFileInfo(path+"/work_unit.sah");
	wtemp    = new QFileInfo(path+"/wtemp.sah");
	state    = new QFileInfo(path+"/state.sah");
	result   = new QFileInfo(path+"/result.sah");
	reHeader = new QFileInfo(path+"/result_header.sah");
	pidFile  = new QFileInfo(path+"/pid.sah");

	if (pidFile->exists()) {
		QFile tempF(pidFile->absFilePath());
  	if(tempF.open(IO_ReadOnly))
  	{
  		QTextStream tempQTS(&tempF);
   	   tempQTS >> pid;
				//cout << "PID is " << pid << endl;
    	  tempF.close();
   	}
	 }
	 else {
      pid=0;
   }

	procPIDPath = procPIDPath.sprintf("/proc/%i/cmdline",pid);
	//cout << "PIDPATH is " << procPIDPath << endl;

	wu->setCaching(false);
	wtemp->setCaching(false);
	state->setCaching(false);
	result->setCaching(false);
	reHeader->setCaching(false);
	pidFile->setCaching(false);
	
}

SetiLocation::~SetiLocation() {
	delete wu;
	delete wtemp;
	delete state;
	delete result;
	delete reHeader;
	delete pidFile;
}

int SetiLocation::getState()  {
	//If there's no pid.sah setiathome is definitely stopped
	if (!pidFile->exists()) {
  	currentState = STOPPED;
		return STOPPED;
	}

  //We only want this to run once
	bool running = isClientRunning();
	if (!running) {
  	currentState = STOPPED;
		return STOPPED;
	}

	//If the result file exists but not the WU, the client hast finished the WU
  if (result->exists() && !wu->exists() && running) {
		currentState = FINISHED;
    return FINISHED;
	}
   
	//Transfer and Connect
  if (!reHeader->exists() && wtemp->exists() && running ) {
		if (result->exists()) {
     currentState = CONNECT;
		 return CONNECT;
		}
		else {
    	currentState = TRANSFER;
			return TRANSFER;
    }	
	}

	// This is more than needed, but by defining this state very complete, we may find
  // bugs in this routine
	if (state->exists() && wu->exists() && reHeader->exists() && !wtemp->exists() && !result->exists()) {
  	currentState=RUNNING;
		return RUNNING;
	}

	//If we end up here, the routine has a bug:
	currentState=UNKNOWN;
  cout << "Warning: state unknown. You encountered the bug. Mail this to sebastian@frozenlight.de: " << endl;
	cout << wu->fileName().latin1()       << ": " << wu->exists()       << endl;
	cout << wtemp->fileName().latin1()    << ": " << wtemp->exists()    << endl;
	cout << state->fileName().latin1()    << ": " << state->exists()    << endl;
	cout << result->fileName().latin1()   << ": " << result->exists()   << endl;
	cout << reHeader->fileName().latin1() << ": " << reHeader->exists() << endl;
	cout << pidFile->fileName().latin1()  << ": " << pidFile->exists()  << endl;
	return currentState;
}

bool SetiLocation::isClientRunning() {
	if (pid==0) {
  	return false;
	}

	QFile tempF(procPIDPath);

  if(tempF.open(IO_ReadOnly)) {
     QString cmdline;
  	 QTextStream t(&tempF);
  	 t >> cmdline;
  	 tempF.close();
     // if there's no "setiathome" substring, this is not a seti client
		 // if we didn't find "setiathome" this MAY be because setiathome is running
     // with this PID on a remote machine.
     // The only reason for checking the /proc/PID/cmdline is that it is possible that
     // there was no progress since the last check although setiathome is running,
     // because the machine running seti had no idle time for it.
     // So we can detect a "running" but not calculating client at least if it runs
     // locally.
		 if(cmdline.find("setiathome") == -1 && !procIncrease) { return false; }
   }

  // if we can not open the PID file, this may be because the client runs remotely
  // if the proc value has increased since the last check, the client is running
	 else {
   	if (!procIncrease) { return false;}
	 }

	 return true;		
}

QString SetiLocation::getPath() const {
 	return path;
}

void SetiLocation::updateProc(double pr) {
 if (pr > proc) {
  	procIncrease=true;
	}
	else {
  	procIncrease=false;
	}
	proc=pr;
}


