package com.ibm.bsf.util;

import com.ibm.bsf.*;
import com.ibm.bsf.util.EngineUtils;

/**
 * This is a utility that engine implementors may use as the Java
 * object they expose in the scripting language as "bsf". This has
 * essentially a subset of the methods in BSFManager plus some
 * stuff from the utils. Currently used by Javascript (Rhino) & BML.
 *
 * @author   Sanjiva Weerawarana
 */
public class BSFFunctions {
  BSFManager mgr;
  BSFEngine engine;

  public BSFFunctions (BSFManager mgr, BSFEngine engine) {
    this.mgr = mgr;
    this.engine = engine;
  }

  public  Object lookupBean (String name) {
    return mgr.lookupBean (name);
  }
  
  public void registerBean (String name, Object bean) {
    mgr.registerBean (name, bean);
  }

  public void unregisterBean (String name) {
    mgr.unregisterBean (name);
  }

  public void addEventListener (Object src, String eventSetName,
				String filter, Object script)
       throws BSFException {
    EngineUtils.addEventListener (src, eventSetName, filter, engine, 
				  mgr, "<event-binding>", 0, 0, script);
  }
}
