/* ===================================================
 * JCommon : a free general purpose Java class library
 * ===================================================
 *
 * Project Info:  http://www.jfree.org/jcommon/index.html
 * Project Lead:  David Gilbert (david.gilbert@object-refinery.com);
 *
 * (C) Copyright 2000-2003, by Object Refinery Limited and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * ------------
 * JCommon.java
 * ------------
 * (C) Copyright 2002, 2003, by Object Refinery Limited.
 *
 * Original Author:  David Gilbert (for Object Refinery Limited);
 * Contributor(s):   -;
 *
 * $Id: JCommon.java,v 1.2 2003/06/05 08:42:28 mungady Exp $
 *
 * Changes
 * -------
 * 28-Feb-2002 : Version 1 (DG);
 * 22-Mar-2002 : Changed version number to 0.6.0 (DG);
 * 25-Mar-2002 : Moved the project info details into a class so that the text can be localised
 *               more easily (DG);
 * 04-Apr-2002 : Added Hari to contributors (DG);
 * 19-Apr-2002 : Added Sam (oldman) to contributors (DG);
 * 07-Jun-2002 : Added contributors (DG);
 * 24-Jun-2002 : Removed unnecessary imports (DG);
 * 27-Aug-2002 : Updated version number to 0.7.0 (DG);
 *
 */

package org.jfree;

import java.util.Arrays;
import java.util.ResourceBundle;

import org.jfree.ui.about.Contributor;
import org.jfree.ui.about.Library;
import org.jfree.ui.about.Licences;
import org.jfree.ui.about.ProjectInfo;

/**
 * This class contains static information about the JCommon class library.
 *
 * @author David Gilbert
 */
public class JCommon {

    /** Information about the project. */
    public static final ProjectInfo INFO = new JCommonInfo();

    /**
     * Prints information about JCommon to standard output.
     *
     * @param args  no arguments are honored.
     */
    public static void main(String[] args) {

        System.out.println(JCommon.INFO.toString());

    }

}

/**
 * Information about the JCommon project.  One instance of this class is
 * assigned to JCommon.INFO.
 *
 * @author David Gilbert
 */
class JCommonInfo extends ProjectInfo {

    /**
     * Creates a new instance.
     */
    public JCommonInfo() {

        // get a locale-specific resource bundle...
        String baseResourceClass = "org.jfree.resources.JCommonResources";
        ResourceBundle resources = ResourceBundle.getBundle(baseResourceClass);

        setName(resources.getString("project.name"));
        setVersion(resources.getString("project.version"));
        setInfo(resources.getString("project.info"));
        setCopyright(resources.getString("project.copyright"));

        setLicenceName("LGPL");
        setLicenceText(Licences.LGPL);

        setContributors(Arrays.asList(
            new Contributor[] {
                new Contributor("Anthony Boulestreau", "-"),
                new Contributor("Jeremy Bowman", "-"),
                new Contributor("J. David Eisenberg", "-"),
                new Contributor("Paul English", "-"),
                new Contributor("David Gilbert", "david.gilbert@object-refinery.com"),
                new Contributor("Hans-Jurgen Greiner", "-"),
                new Contributor("Achilleus Mantzios", "-"),
                new Contributor("Thomas Meier", "-"),
                new Contributor("Aaron Metzger", "-"),
                new Contributor("Krzysztof Paz", "-"),
                new Contributor("Nabuo Tamemasa", "-"),
                new Contributor("Mark Watson", "-"),
                new Contributor("Matthew Wright", "-"),
                new Contributor("Hari", "-"),
                new Contributor("Sam (oldman)", "-")
            }
        ));

        setLibraries(Arrays.asList(
            new Library[] {
                new Library("JUnit", "3.8", "IBM Public Licence", "http://www.junit.org/")
            }

        ));

    }

}
