/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath;

import org.apache.xalan.xpath.MutableNodeList;
import org.apache.xalan.xpath.XPathSupport;
import org.apache.xalan.xpath.xml.NodeVector;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MutableNodeListImpl
extends NodeVector
implements MutableNodeList {
    public MutableNodeListImpl() {
    }

    public MutableNodeListImpl(int n) {
        super(n);
    }

    public MutableNodeListImpl(Node node) {
        this.addNode(node);
    }

    public MutableNodeListImpl(NodeList nodeList) {
        this.addNodes(nodeList);
    }

    public void addNode(Node node) {
        this.addElement(node);
    }

    public int addNodeInDocOrder(Node node, XPathSupport xPathSupport) {
        return this.addNodeInDocOrder(node, true, xPathSupport);
    }

    public int addNodeInDocOrder(Node node, boolean bl, XPathSupport xPathSupport) {
        int n = -1;
        if (bl) {
            if (xPathSupport.supportsNodeNumber(node)) {
                int n2 = xPathSupport.getNodeNumber(node);
                int n3 = this.size();
                int n4 = n3 - 1;
                while (n4 >= 0) {
                    Node node2 = this.elementAt(n4);
                    if (n2 == 1 && node == node2 || node.getOwnerDocument() == node2.getOwnerDocument()) {
                        int n5 = xPathSupport.getNodeNumber(node2);
                        if (n5 == n2) {
                            n4 = -2;
                            break;
                        }
                        if (n5 < n2) break;
                    }
                    --n4;
                }
                if (n4 != -2) {
                    n = n4 + 1;
                    this.insertElementAt(node, n);
                }
            } else {
                int n6 = this.size();
                int n7 = n6 - 1;
                while (n7 >= 0) {
                    Node node3 = this.elementAt(n7);
                    if (node3 == node) {
                        n7 = -2;
                        break;
                    }
                    if (!MutableNodeListImpl.isNodeAfter(node, node3, xPathSupport)) break;
                    --n7;
                }
                if (n7 != -2) {
                    n = n7 + 1;
                    this.insertElementAt(node, n);
                }
            }
        } else {
            n = this.size();
            boolean bl2 = false;
            int n8 = 0;
            while (n8 < n) {
                if (this.item(n8).equals(node)) {
                    bl2 = true;
                    break;
                }
                ++n8;
            }
            if (!bl2) {
                this.addElement(node);
            }
        }
        return n;
    }

    public void addNodes(NodeList nodeList) {
        if (nodeList != null) {
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                if (node != null) {
                    this.addElement(node);
                }
                ++n2;
            }
        }
    }

    public void addNodesInDocOrder(NodeList nodeList, XPathSupport xPathSupport) {
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node != null) {
                this.addNodeInDocOrder(node, xPathSupport);
            }
            ++n2;
        }
    }

    public boolean checkDups() {
        boolean bl = false;
        int n = this.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = this.item(n2);
            int n3 = 0;
            while (n3 < n) {
                if (n3 != n2 && this.item(n3).equals(node)) {
                    bl = true;
                    System.out.println("Found dup");
                    break;
                }
                ++n3;
            }
            ++n2;
        }
        return bl;
    }

    public boolean checkDups(Node node) {
        boolean bl = false;
        int n = this.getLength();
        int n2 = 0;
        while (n2 < n) {
            if (this.item(n2).equals(node)) {
                bl = true;
                System.out.println("Found dup");
                break;
            }
            ++n2;
        }
        return bl;
    }

    public int getLength() {
        return this.size();
    }

    public void insertNode(Node node, int n) {
        this.insertElementAt(node, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean isDOMNodeAfter(Node node, Node node2, XPathSupport xPathSupport) {
        int n;
        int n2;
        Node node3;
        boolean bl = false;
        Node node4 = xPathSupport.getParentOfNode(node);
        if (node4 == (node3 = xPathSupport.getParentOfNode(node2))) {
            if (node4 != null) {
                return MutableNodeListImpl.isNodeAfterSibling(node4, node, node2);
            }
            if (node != node2) return true;
            return false;
        }
        int n3 = 2;
        int n4 = 2;
        while (node4 != null) {
            ++n3;
            node4 = xPathSupport.getParentOfNode(node4);
        }
        while (node3 != null) {
            ++n4;
            node3 = xPathSupport.getParentOfNode(node3);
        }
        Node node5 = node;
        Node node6 = node2;
        if (n3 < n4) {
            n2 = n4 - n3;
            n = 0;
            while (n < n2) {
                node6 = xPathSupport.getParentOfNode(node6);
                ++n;
            }
        } else if (n3 > n4) {
            n2 = n3 - n4;
            n = 0;
            while (n < n2) {
                node5 = xPathSupport.getParentOfNode(node5);
                ++n;
            }
        }
        Node node7 = null;
        Node node8 = null;
        while (node5 != null) {
            if (node5 == node6) {
                if (node7 != null) return MutableNodeListImpl.isNodeAfterSibling(node5, node7, node8);
                if (n3 >= n4) return false;
                return true;
            }
            node7 = node5;
            node5 = xPathSupport.getParentOfNode(node5);
            node8 = node6;
            node6 = xPathSupport.getParentOfNode(node6);
        }
        return bl;
    }

    public static boolean isNodeAfter(Node node, Node node2, XPathSupport xPathSupport) {
        if (xPathSupport.supportsNodeNumber(node)) {
            int n;
            int n2 = xPathSupport.getNodeNumber(node);
            return n2 <= (n = xPathSupport.getNodeNumber(node2));
        }
        return MutableNodeListImpl.isDOMNodeAfter(node, node2, xPathSupport);
    }

    private static boolean isNodeAfterSibling(Node node, Node node2, Node node3) {
        boolean bl = false;
        short s = node2.getNodeType();
        short s2 = node3.getNodeType();
        if (s != 2 && s2 == 2) {
            bl = false;
        } else if (s == 2 && s2 != 2) {
            bl = true;
        } else if (s == 2) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = namedNodeMap.getLength();
            boolean bl2 = false;
            boolean bl3 = false;
            int n2 = 0;
            while (n2 < n) {
                Node node4 = namedNodeMap.item(n2);
                if (node2 == node4) {
                    if (bl3) {
                        bl = false;
                        break;
                    }
                    bl2 = true;
                } else if (node3 == node4) {
                    if (bl2) {
                        bl = true;
                        break;
                    }
                    bl3 = true;
                }
                ++n2;
            }
        } else {
            Node node5 = node.getFirstChild();
            boolean bl4 = false;
            boolean bl5 = false;
            while (node5 != null) {
                if (node2 == node5) {
                    if (bl5) {
                        bl = false;
                        break;
                    }
                    bl4 = true;
                } else if (node3 == node5) {
                    if (bl4) {
                        bl = true;
                        break;
                    }
                    bl5 = true;
                }
                node5 = node5.getNextSibling();
            }
        }
        return bl;
    }

    public Node item(int n) {
        return this.elementAt(n);
    }

    public void removeNode(Node node) {
        this.removeElement(node);
    }

    public void setItemNull(int n) {
        this.setElementAt(null, n);
    }
}

