/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.MergingMapper;
import org.apache.tools.ant.util.SourceFileScanner;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;

public class Tar
extends MatchingTask {
    public static final String WARN = "warn";
    public static final String FAIL = "fail";
    public static final String TRUNCATE = "truncate";
    public static final String GNU = "gnu";
    public static final String OMIT = "omit";
    private String[] validModes = new String[]{"warn", "fail", "truncate", "gnu", "omit"};
    File tarFile;
    File baseDir;
    String longFileMode = "warn";
    Vector filesets = new Vector();
    Vector fileSetFiles = new Vector();
    private boolean longWarningGiven = false;

    public TarFileSet createTarFileSet() {
        TarFileSet tarFileSet = new TarFileSet();
        this.filesets.addElement(tarFileSet);
        return tarFileSet;
    }

    public void setTarfile(File file) {
        this.tarFile = file;
    }

    public void setBasedir(File file) {
        this.baseDir = file;
    }

    public void setLongfile(String string) {
        int n = 0;
        while (n < this.validModes.length) {
            if (string.equalsIgnoreCase(this.validModes[n])) {
                this.longFileMode = string;
                return;
            }
            ++n;
        }
        throw new BuildException("The longfile value " + string + " is not a valid value");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        Object object;
        Object object2;
        if (this.tarFile == null) {
            throw new BuildException("tarfile attribute must be set!", this.location);
        }
        if (this.tarFile.exists() && this.tarFile.isDirectory()) {
            throw new BuildException("tarfile is a directory!", this.location);
        }
        if (this.tarFile.exists() && !this.tarFile.canWrite()) {
            throw new BuildException("Can not write to the specified tarfile!", this.location);
        }
        if (this.baseDir != null) {
            if (!this.baseDir.exists()) {
                throw new BuildException("basedir does not exist!", this.location);
            }
            TarFileSet tarFileSet = new TarFileSet(this.fileset);
            tarFileSet.setDir(this.baseDir);
            tarFileSet.setDefaultexcludes(this.useDefaultExcludes);
            this.filesets.addElement(tarFileSet);
        }
        if (this.filesets.size() == 0) {
            throw new BuildException("You must supply either a basdir attribute or some nested filesets.", this.location);
        }
        boolean bl = true;
        Enumeration enumeration = this.filesets.elements();
        block7: while (true) {
            if (!enumeration.hasMoreElements()) {
                if (!bl) break;
                this.log("Nothing to do: " + this.tarFile.getAbsolutePath() + " is up to date.", 2);
                return;
            }
            object2 = (TarFileSet)enumeration.nextElement();
            object = ((TarFileSet)object2).getFiles(this.project);
            if (!this.archiveIsUpToDate((String[])object)) {
                bl = false;
            }
            int n = 0;
            while (true) {
                if (n >= ((String[])object).length) continue block7;
                if (this.tarFile.equals(new File(((FileSet)object2).getDir(this.project), object[n]))) {
                    throw new BuildException("A tar file cannot include itself", this.location);
                }
                ++n;
            }
            break;
        }
        this.log("Building tar: " + this.tarFile.getAbsolutePath(), 2);
        object2 = null;
        try {
            try {
                object2 = new TarOutputStream(new FileOutputStream(this.tarFile));
                ((TarOutputStream)object2).setDebug(true);
                if (this.longFileMode.equalsIgnoreCase(TRUNCATE)) {
                    ((TarOutputStream)object2).setLongFileMode(1);
                } else if (this.longFileMode.equalsIgnoreCase(FAIL) || this.longFileMode.equalsIgnoreCase(OMIT)) {
                    ((TarOutputStream)object2).setLongFileMode(0);
                } else {
                    ((TarOutputStream)object2).setLongFileMode(2);
                }
                this.longWarningGiven = false;
                object = this.filesets.elements();
                while (object.hasMoreElements()) {
                    TarFileSet tarFileSet = (TarFileSet)object.nextElement();
                    String[] stringArray = tarFileSet.getFiles(this.project);
                    int n = 0;
                    while (n < stringArray.length) {
                        File file = new File(this.baseDir, stringArray[n]);
                        String string = stringArray[n].replace(File.separatorChar, '/');
                        this.tarFile(file, (TarOutputStream)object2, string, tarFileSet);
                        ++n;
                    }
                }
            }
            catch (IOException iOException) {
                String string = "Problem creating TAR: " + iOException.getMessage();
                throw new BuildException(string, iOException, this.location);
            }
            Object var11_15 = null;
            if (object2 == null) return;
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            if (object2 == null) throw throwable;
            try {
                ((TarOutputStream)object2).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        ((TarOutputStream)object2).close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void tarFile(File file, TarOutputStream tarOutputStream, String string, TarFileSet tarFileSet) throws IOException {
        FileInputStream fileInputStream;
        block11: {
            block10: {
                fileInputStream = new FileInputStream(file);
                try {
                    if (string.length() >= 100) {
                        if (this.longFileMode.equalsIgnoreCase(OMIT)) {
                            this.log("Omitting: " + string, 2);
                            Object var10_6 = null;
                            break block10;
                        }
                        if (this.longFileMode.equalsIgnoreCase(WARN)) {
                            this.log("Entry: " + string + " longer than " + 100 + " characters.", 1);
                            if (!this.longWarningGiven) {
                                this.log("Resulting tar file can only be processed successfully by GNU compatible tar commands", 1);
                                this.longWarningGiven = true;
                            }
                        } else if (this.longFileMode.equalsIgnoreCase(FAIL)) {
                            throw new BuildException("Entry: " + string + " longer than " + 100 + "characters.", this.location);
                        }
                    }
                    TarEntry tarEntry = new TarEntry(string);
                    tarEntry.setSize(file.length());
                    tarEntry.setModTime(file.lastModified());
                    if (!file.isDirectory()) {
                        tarEntry.setMode(tarFileSet.getMode());
                    }
                    tarEntry.setUserName(tarFileSet.getUserName());
                    tarEntry.setGroupName(tarFileSet.getGroup());
                    tarOutputStream.putNextEntry(tarEntry);
                    byte[] byArray = new byte[8192];
                    int n = 0;
                    do {
                        tarOutputStream.write(byArray, 0, n);
                    } while ((n = fileInputStream.read(byArray, 0, byArray.length)) != -1);
                    tarOutputStream.closeEntry();
                    break block11;
                }
                catch (Throwable throwable) {
                    Object var10_8 = null;
                    fileInputStream.close();
                    throw throwable;
                }
            }
            fileInputStream.close();
            return;
        }
        Object var10_7 = null;
        fileInputStream.close();
    }

    protected boolean archiveIsUpToDate(String[] stringArray) {
        SourceFileScanner sourceFileScanner = new SourceFileScanner(this);
        MergingMapper mergingMapper = new MergingMapper();
        mergingMapper.setTo(this.tarFile.getAbsolutePath());
        return sourceFileScanner.restrict(stringArray, this.baseDir, null, mergingMapper).length == 0;
    }

    public static class TarFileSet
    extends FileSet {
        private String[] files = null;
        private int mode = 33188;
        private String userName = "";
        private String groupName = "";

        public TarFileSet(FileSet fileSet) {
            super(fileSet);
        }

        public TarFileSet() {
        }

        public String[] getFiles(Project project) {
            if (this.files == null) {
                DirectoryScanner directoryScanner = this.getDirectoryScanner(project);
                this.files = directoryScanner.getIncludedFiles();
            }
            return this.files;
        }

        public void setMode(String string) {
            this.mode = 0x8000 | Integer.parseInt(string, 8);
        }

        public int getMode() {
            return this.mode;
        }

        public void setUserName(String string) {
            this.userName = string;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setGroup(String string) {
            this.groupName = string;
        }

        public String getGroup() {
            return this.groupName;
        }
    }
}

