/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.instantdb.db;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.enhydra.instantdb.db.ByteColumn;
import org.enhydra.instantdb.db.Column;
import org.enhydra.instantdb.db.HashTablePool;
import org.enhydra.instantdb.db.IdbVector;
import org.enhydra.instantdb.db.IntegerColumn;
import org.enhydra.instantdb.db.Journal;
import org.enhydra.instantdb.db.SQLProg;
import org.enhydra.instantdb.db.StringColumn;
import org.enhydra.instantdb.db.Table;
import org.enhydra.instantdb.db.TableEncrypt;
import org.enhydra.instantdb.db.Trace;
import org.enhydra.instantdb.db.Transaction;
import org.enhydra.instantdb.db.TypeInfo;
import org.enhydra.instantdb.db.indexTable;
import org.enhydra.instantdb.db.sqltoken;

public class Database
implements Runnable {
    String filename;
    Properties dbProperties;
    int nextTmpNum = 1;
    String tablePath;
    String indexPath;
    String tmpPath;
    String systemPath;
    int partitionCount;
    IdbVector partitions;
    boolean valid;
    boolean closed;
    int openCount;
    String propertiesPath;
    String url;
    boolean noFKs;
    public String idString;
    Thread timerThread;
    Vector timerQueue;
    long timerCheck;
    Table tblTable;
    Table colTable;
    Table idxTable;
    Vector tblList;
    String colsTableName;
    String tblsTableName;
    String indxTableName;
    String defDateFormat;
    String defDateTimeFormat;
    char defCurrencySymbol;
    int defCurrencyDecimal;
    int exportSQL;
    float indexLoad;
    int transLevel;
    int transImports;
    PrintWriter export;
    int traceLevel;
    int traceConsole;
    int controlColCacheSize;
    int systemCacheCondition;
    int systemCacheSize;
    int systemRows;
    boolean fastUpdate;
    boolean strictLiterals;
    int milleniumBoundary;
    boolean readOnly;
    boolean resultsOnDisk;
    boolean likeIgnoreCase;
    boolean altStringHashing;
    boolean nowMeansTime;
    int recoveryPolicy;
    boolean searchDeletes;
    boolean prepareIgnoresEscapes;
    boolean microsoftVM;
    Vector hashtables;
    Vector vectorPool;
    Vector stringbuffs;
    Transaction sysTrans;
    Journal journal;
    boolean doRecovery;
    String defaultUsername = "";
    String defaultPassword = "";
    static sqltoken SQLsyntax;
    static Vector databases;
    static boolean shutdownActive;
    static boolean noBanner;
    public static final int TABLE_NAME_MAX = 64;
    public static final int PATH_NAME_MAX = 256;
    public static final int COLUMN_NAME_MAX = 64;
    public static final int LAST_SYSTEM_TABLE_ID = 1005;
    public static final int MAJOR_VERSION = 3;
    public static final int MINOR_VERSION = 25;
    public static final int BETA_VERSION = 0;
    public static final int CACHE_DEFAULT = 0;
    public static final int CACHE_ROWS = 1;
    public static final int CACHE_PERCENT = 2;
    public static final String nullString = "NULL";

    public Database(String string) throws SQLException {
        this.url = string;
        Properties properties = System.getProperties();
        String string2 = properties.getProperty("java.vendor");
        if (string2.indexOf("Microsoft") != -1) {
            this.microsoftVM = true;
        }
    }

    void addColumns() throws SQLException {
        IntegerColumn integerColumn = new IntegerColumn(this.colTable, "ColID");
        integerColumn.setBooleanProperty(1, true);
        integerColumn.setBooleanProperty(5, true);
        this.setSystemTableCache(integerColumn);
        integerColumn = new IntegerColumn(this.colTable, "TableId");
        this.setSystemTableCache(integerColumn);
        StringColumn stringColumn = new StringColumn(this.colTable, "ColName", 64);
        this.setSystemTableCache(stringColumn);
        stringColumn = new StringColumn(this.colTable, "Flags", 64);
        this.setSystemTableCache(stringColumn);
        ByteColumn byteColumn = new ByteColumn(this.colTable, "Type");
        this.setSystemTableCache(byteColumn);
        integerColumn = new IntegerColumn(this.colTable, "Offset");
        this.setSystemTableCache(integerColumn);
        integerColumn = new IntegerColumn(this.colTable, "Length");
        this.setSystemTableCache(integerColumn);
        byteColumn = new ByteColumn(this.colTable, "CacheCond");
        this.setSystemTableCache(byteColumn);
        integerColumn = new IntegerColumn(this.colTable, "CacheAmnt");
        this.setSystemTableCache(integerColumn);
        stringColumn = new StringColumn(this.colTable, "ColDefault", 64);
        this.setSystemTableCache(stringColumn);
    }

    public static void addDatabase(Database database) {
        Vector vector = databases;
        synchronized (vector) {
            databases.addElement(database);
            database.idString = String.valueOf(database.url) + " " + System.currentTimeMillis() + " " + databases.size();
        }
    }

    void addFkColumns() throws SQLException {
        IntegerColumn integerColumn = new IntegerColumn(this.colTable, "FK");
        this.setSystemTableCache(integerColumn);
        integerColumn = new IntegerColumn(this.colTable, "FK_FLAGS");
        this.setSystemTableCache(integerColumn);
    }

    void addTable(Table table) {
        this.tblList.addElement(table);
    }

    public void addToTimerQueue(Transaction transaction, int n) {
        if (n == 0) {
            return;
        }
        long l = System.currentTimeMillis();
        transaction.expiryTime = l += (long)(n * 1000);
        Vector vector = this.timerQueue;
        synchronized (vector) {
            int n2 = this.timerQueue.size();
            if (n2 == 0) {
                this.timerQueue.addElement(transaction);
            } else {
                int n3 = n2 - 1;
                while (n3 >= 0) {
                    Transaction transaction2 = (Transaction)this.timerQueue.elementAt(n3);
                    if (l >= transaction2.expiryTime) {
                        if (n3 == n2 - 1) {
                            this.timerQueue.addElement(transaction);
                            break;
                        }
                        this.timerQueue.insertElementAt(transaction, n3 + 1);
                        break;
                    }
                    --n3;
                }
            }
        }
    }

    void checkForShutdown() throws SQLException {
        if (this.closed) {
            throw new SQLException("Database has been closed");
        }
        if (shutdownActive) {
            throw new SQLException("Shutdown is in progress");
        }
    }

    public synchronized void close() throws SQLException {
        if (Trace.traceIt(1)) {
            Trace.traceOut("Closing database " + this.filename + " opens=" + this.openCount);
        }
        this.close(false);
    }

    public void close(boolean bl) throws SQLException {
        if (!this.valid) {
            return;
        }
        --this.openCount;
        if (this.openCount > 0) {
            Trace.close();
            return;
        }
        if (!noBanner) {
            System.out.println("Database " + this.filename + " is shutting down...");
        }
        if (!bl) {
            this.journal.commitAll();
        }
        int n = 0;
        while (n < this.tblList.size()) {
            Table table = (Table)this.tblList.elementAt(n);
            try {
                if (table.tableType == 3) {
                    table.dropTable(null);
                } else {
                    table.close(bl);
                }
            }
            catch (Exception exception) {
                System.out.println("Error closing table " + table.tableName + "\n" + exception);
                exception.printStackTrace();
            }
            ++n;
        }
        this.tblTable = null;
        this.colTable = null;
        this.idxTable = null;
        this.tblList = null;
        this.dbProperties = null;
        this.export = null;
        this.hashtables = null;
        this.vectorPool = null;
        this.timerQueue = null;
        this.timerThread.interrupt();
        this.stringbuffs = null;
        this.nextTmpNum = 1;
        this.valid = false;
        this.closed = true;
        Trace.close();
        this.journal.closeLog();
        Database.removeDatabase(this);
        if (!noBanner) {
            System.out.println("Database " + this.filename + " shutdown complete.");
        }
        this.filename = null;
    }

    void createDir(String string) throws SQLException {
        File file = new File(string);
        if (!file.exists() && !file.mkdirs()) {
            throw new SQLException("Cannot create directory: " + string, "XOPEN");
        }
    }

    public Transaction dbCreate(String string, String string2, Transaction transaction) throws SQLException {
        this.tblTable = new Table(String.valueOf(this.filename) + "$db$Tables", this, transaction, -1);
        IntegerColumn integerColumn = new IntegerColumn(this.tblTable, "TableID");
        integerColumn.setBooleanProperty(1, true);
        integerColumn.setBooleanProperty(5, true);
        this.setSystemTableCache(integerColumn);
        StringColumn stringColumn = new StringColumn(this.tblTable, "TableName", 64);
        stringColumn.setBooleanProperty(2, true);
        this.setSystemTableCache(stringColumn);
        stringColumn = new StringColumn(this.tblTable, "Path", 256);
        this.setSystemTableCache(stringColumn);
        integerColumn = new IntegerColumn(this.tblTable, "RecLen");
        this.setSystemTableCache(integerColumn);
        ByteColumn byteColumn = new ByteColumn(this.tblTable, "Type");
        this.setSystemTableCache(byteColumn);
        try {
            this.tblTable.allColumnsAdded(transaction, false);
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
        this.colTable = new Table(String.valueOf(this.filename) + "$db$Cols", this, transaction, -1);
        this.addColumns();
        this.addFkColumns();
        try {
            this.colTable.allColumnsAdded(transaction, false);
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
        this.tblTable.registerTable(transaction);
        indexTable indexTable2 = (indexTable)this.getTable(String.valueOf(this.filename) + "$db$Tables$pKey");
        indexTable2.registerTable(transaction);
        this.idxTable = new Table(String.valueOf(this.filename) + "$db$Indexes", this, transaction, -1);
        integerColumn = new IntegerColumn(this.idxTable, "TableID");
        this.setSystemTableCache(integerColumn);
        integerColumn = new IntegerColumn(this.idxTable, "ColID");
        this.setSystemTableCache(integerColumn);
        try {
            this.idxTable.allColumnsAdded(transaction, false);
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
        indexTable2.registerIndex(transaction);
        indexTable2 = (indexTable)this.getTable(String.valueOf(this.filename) + "$db$Cols$pKey");
        indexTable2.registerIndex(transaction);
        new TypeInfo(this, transaction);
        return transaction;
    }

    public synchronized Transaction dbOpen(String string, String string2, String string3) throws SQLException {
        int n;
        Object object;
        int n2;
        Object object2;
        Object object3;
        Serializable serializable;
        int n3;
        this.checkForShutdown();
        if (!this.valid) {
            this.initialise(string);
        }
        if (Trace.traceIt(1)) {
            Trace.traceOut("Opening database " + string + " opens=" + this.openCount);
        }
        this.traceMemory();
        if (this.valid) {
            ++this.openCount;
            return new Transaction(this);
        }
        String string4 = this.tablePath;
        if (this.systemPath != null) {
            this.tablePath = this.systemPath;
        }
        if (!this.valid) {
            this.sysTrans = new Transaction(this);
        }
        Transaction transaction = new Transaction(this);
        this.colTable = new Table(null, this, transaction, -1);
        this.addColumns();
        try {
            n3 = this.colTable.open(String.valueOf(this.filename) + "$db$Cols");
            if (n3 == 0) {
                n3 = this.colTable.open(String.valueOf(this.filename) + "$db$Columns");
            }
            if (n3 == 0) {
                this.colTable = null;
                this.dbCreate(string, string3, transaction);
                transaction.commit(transaction.sqlID);
                this.tablePath = string4;
                this.valid = true;
                ++this.openCount;
                return transaction;
            }
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
        this.colTable.tblID = new Integer(1000);
        n3 = 1;
        while (n3 <= this.colTable.rowCount) {
            if (this.colTable.rowDeleted(n3)) {
                throw new SQLException("Internal error - column table columns missing");
            }
            serializable = (Integer)this.colTable.getColByRow("TableId", n3);
            if (!((Integer)serializable).equals(this.colTable.tblID)) break;
            object3 = (String)this.colTable.getColByRow("ColName", n3);
            Integer n4 = (Integer)this.colTable.getColByRow("ColID", n3);
            object2 = this.colTable.getColByName((String)object3);
            ((Column)object2).colID = n4;
            ++n3;
        }
        serializable = null;
        object3 = new IdbVector(this.colTable);
        serializable = new Hashtable(200, 0.6f);
        int n5 = 1;
        while (n5 <= this.colTable.rowCount) {
            if (!this.colTable.rowDeleted(n5)) {
                this.colTable.getRow(n5, (Vector)object3);
                object2 = ((IdbVector)object3).getIntegerAt(2);
                Vector<int[]> vector = (Vector<int[]>)((Hashtable)serializable).get(object2);
                n2 = ((IdbVector)object3).getIntAt(6);
                object = new int[]{n5, n2};
                if (vector == null) {
                    vector = new Vector<int[]>(20, 20);
                    vector.addElement((int[])object);
                    ((Hashtable)serializable).put(object2, vector);
                } else {
                    n = 0;
                    int n6 = vector.size() - 1;
                    while (n6 >= 0) {
                        int[] nArray = (int[])vector.elementAt(n6);
                        if (n2 > nArray[1]) {
                            vector.ensureCapacity(vector.size() + 1);
                            vector.insertElementAt((int[])object, n6 + 1);
                            n = 1;
                            break;
                        }
                        --n6;
                    }
                    if (n == 0) {
                        vector.insertElementAt((int[])object, 0);
                    }
                }
            }
            ++n5;
        }
        this.tblTable = new Table(null, this.colTable, String.valueOf(this.filename) + "$db$Tables", (Hashtable)serializable);
        object2 = new IdbVector(this.tblTable);
        int n7 = 1;
        while (n7 <= this.tblTable.rowCount) {
            if (n7 > 6) {
                this.tablePath = string4;
            }
            if (!this.tblTable.rowDeleted(n7)) {
                this.tblTable.getRow(n7, (Vector)object2);
                n2 = ((IdbVector)object2).getIntAt(5);
                object = null;
                if (n2 == 1) {
                    object = new Table((IdbVector)object2, this.colTable, new Integer(n7), (Hashtable)serializable);
                    if (object.tableName.endsWith("$db$Indexes")) {
                        this.idxTable = object;
                        try {
                            this.journal.doRecovery(true);
                        }
                        catch (IOException iOException) {
                            throw new SQLException("Problem replaying system journal: " + iOException.toString());
                        }
                    }
                } else if (n2 == 2) {
                    object = new indexTable((IdbVector)object2, this.colTable, new Integer(n7), (Hashtable)serializable);
                }
            }
            ++n7;
        }
        try {
            this.journal.doRecovery(false);
        }
        catch (IOException iOException) {
            throw new SQLException("Problem replaying journal: " + iOException.toString());
        }
        Vector vector = new Vector(1);
        vector.addElement(this.colTable.columnList.elementAt(1));
        object = new indexTable(this, this.colTable, vector);
        n = 0;
        while (n < this.tblList.size()) {
            Table table = (Table)this.tblList.elementAt(n);
            if (table instanceof indexTable) {
                try {
                    ((indexTable)table).bind(this.idxTable, this.colTable, this.tblTable);
                }
                catch (Exception exception) {
                    System.out.println("Error binding index: " + table.getTableName() + "\n" + exception.toString() + "\nIndex will be dropped from database.");
                    table.dropTable(this.sysTrans);
                }
            } else {
                table.setupFKs((indexTable)object);
            }
            ++n;
        }
        transaction.commit(transaction.sqlID);
        this.tablePath = string4;
        ++this.openCount;
        this.valid = true;
        return transaction;
    }

    public SQLProg execQuery(String string, Transaction transaction) throws SQLException {
        SQLProg sQLProg = new SQLProg(this, string, false, transaction);
        sQLProg.execute();
        return sQLProg;
    }

    public void execSQL(String string, Transaction transaction) throws SQLException {
        Trace.suppressTracing();
        try {
            try {
                SQLProg sQLProg = this.execQuery(string, transaction);
                if (sQLProg.rsTable != null) {
                    sQLProg.rsTable.dropTable(null);
                    sQLProg.rsTable = null;
                    sQLProg = null;
                }
            }
            catch (SQLException sQLException) {
                try {
                    throw sQLException.fillInStackTrace();
                }
                catch (Throwable throwable) {
                    throw sQLException;
                }
            }
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            Trace.resumeTracing();
            throw throwable;
        }
        Trace.resumeTracing();
    }

    protected synchronized void finalize() throws Throwable {
        try {
            this.close(false);
        }
        catch (Exception exception) {}
    }

    Database getDatabase() {
        return this;
    }

    public static Database getDatabase(String string) {
        String string2;
        Object object;
        try {
            object = Class.forName("java.lang.Exception");
            synchronized (object) {
                if (databases == null) {
                    databases = new Vector(5, 5);
                    if (System.getProperty("noBanner") == null) {
                        System.out.print("Enhydra InstantDB - Version 3.25");
                        System.out.println();
                        string2 = "The Initial Developer of the Original Code is Lutris Technologies Inc.\nPortions created by Lutris are Copyright (C) 1997-2000 Lutris Technologies, Inc.\nAll Rights Reserved.";
                        System.out.println(string2);
                    } else {
                        noBanner = true;
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Internal error - problem locking Database class " + exception.toString());
            return null;
        }
        Vector vector = databases;
        synchronized (vector) {
            int n = 0;
            while (n < databases.size()) {
                Database database = (Database)databases.elementAt(n);
                if (database.getURL().equalsIgnoreCase(string)) {
                    object = database;
                    string2 = null;
                    return object;
                }
                ++n;
            }
            object = null;
            string2 = null;
            return object;
        }
    }

    public static Database getDatabaseWithTable(String string) {
        Vector vector = databases;
        synchronized (vector) {
            int n = 0;
            while (n < databases.size()) {
                Database database = (Database)databases.elementAt(n);
                if (database.getTable(string) != null) {
                    Database database2 = database;
                    Object var3_6 = null;
                    return database2;
                }
                ++n;
            }
            Database database = null;
            Object var3_7 = null;
            return database;
        }
    }

    public String getFilename() {
        return this.filename;
    }

    HashTablePool getHashTablePool() {
        HashTablePool hashTablePool = null;
        Vector vector = this.hashtables;
        synchronized (vector) {
            int n = this.hashtables.size() - 1;
            if (n < 0) {
                hashTablePool = new HashTablePool();
            } else {
                hashTablePool = (HashTablePool)this.hashtables.elementAt(n);
                this.hashtables.removeElementAt(n);
            }
        }
        return hashTablePool;
    }

    Transaction getHeadOfTimerQueue() {
        Transaction transaction = null;
        Vector vector = this.timerQueue;
        synchronized (vector) {
            if (this.timerQueue.size() > 0) {
                transaction = (Transaction)this.timerQueue.elementAt(0);
            }
        }
        return transaction;
    }

    int getIntegerProperty(String string, String string2) {
        String string3 = this.dbProperties.getProperty(string, string2);
        return Integer.parseInt(string3);
    }

    public Journal getJournal() {
        return this.journal;
    }

    public int getOpenCount() {
        return this.openCount;
    }

    StringBuffer getStringBuffer() {
        StringBuffer stringBuffer = null;
        Vector vector = this.stringbuffs;
        synchronized (vector) {
            int n = this.stringbuffs.size() - 1;
            if (n < 0) {
                stringBuffer = new StringBuffer(20);
            } else {
                stringBuffer = (StringBuffer)this.stringbuffs.elementAt(n);
                this.stringbuffs.removeElementAt(n);
            }
        }
        return stringBuffer;
    }

    String getStringProperty(String string, String string2) {
        return this.dbProperties.getProperty(string, string2);
    }

    Table getTable(int n) {
        Vector vector = this.tblList;
        synchronized (vector) {
            int n2 = 0;
            while (n2 < this.tblList.size()) {
                Table table = (Table)this.tblList.elementAt(n2);
                if (n == table.getTableID()) {
                    Table table2 = table;
                    Object var4_6 = null;
                    return table2;
                }
                ++n2;
            }
        }
        return null;
    }

    public Table getTable(String string) {
        Vector vector = this.tblList;
        synchronized (vector) {
            int n = 0;
            while (n < this.tblList.size()) {
                Table table = (Table)this.tblList.elementAt(n);
                String string2 = table.getTableName();
                if (string2.equalsIgnoreCase(string)) {
                    Table table2 = table;
                    Object var4_7 = null;
                    return table2;
                }
                ++n;
            }
        }
        return null;
    }

    synchronized Table[] getTableArray() {
        Vector vector = this.tblList;
        synchronized (vector) {
            Table[] tableArray = new Table[this.tblList.size()];
            int n = 0;
            while (n < this.tblList.size()) {
                Table table;
                tableArray[n] = table = (Table)this.tblList.elementAt(n);
                ++n;
            }
            Table[] tableArray2 = tableArray;
            Object var3_6 = null;
            return tableArray2;
        }
    }

    int getTableIndex(Table table) {
        Vector vector = this.tblList;
        synchronized (vector) {
            int n = 0;
            while (n < this.tblList.size()) {
                Table table2 = (Table)this.tblList.elementAt(n);
                if (table2 == table) {
                    int n2 = n;
                    Object var4_6 = null;
                    return n2;
                }
                ++n;
            }
        }
        return -1;
    }

    public Vector getTables() {
        return this.tblList;
    }

    String getTmpFile() {
        return String.valueOf(this.filename) + "$tmp$" + this.nextTmpNum++;
    }

    public String getURL() {
        return this.url;
    }

    void initialise(String string) throws SQLException {
        Object object;
        Object object2;
        Object object3;
        this.hashtables = new Vector(40, 20);
        this.vectorPool = new Vector(20, 10);
        this.stringbuffs = new Vector(40, 20);
        this.dbProperties = new Properties();
        string = this.switchSeparators(string);
        File file = new File(string);
        try {
            String string2 = file.getCanonicalPath();
            file = new File(string2);
        }
        catch (IOException iOException) {
            throw new SQLException("IO problem opening properties file: " + string + "\n" + iOException.toString());
        }
        this.filename = file.getName();
        int n = this.filename.indexOf(46);
        if (n != -1) {
            this.filename = this.filename.substring(0, n);
        }
        try {
            object3 = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object3);
            this.dbProperties.load(bufferedInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SQLException("FileNotFoundException reading properties from file: " + string + " " + fileNotFoundException.toString());
        }
        catch (IOException iOException) {
            throw new SQLException("IOException reading properties from file: " + string + " " + iOException.toString());
        }
        catch (SecurityException securityException) {
            throw new SQLException("SecurityException reading properties from file: " + string + " " + securityException.toString());
        }
        this.colsTableName = String.valueOf(this.filename) + "$db$cols";
        this.tblsTableName = String.valueOf(this.filename) + "$db$tables";
        this.indxTableName = String.valueOf(this.filename) + "$db$indexes";
        object3 = this.getStringProperty("traceFile", null);
        object3 = this.switchSeparators((String)object3);
        boolean bl = false;
        if (this.getIntegerProperty("relativeToProperties", "0") != 0) {
            bl = true;
        }
        this.propertiesPath = file.getParent();
        this.tablePath = this.setPath("tablePath", ".", bl);
        this.indexPath = this.setPath("indexPath", null, bl);
        this.systemPath = this.setPath("systemPath", null, bl);
        this.tmpPath = this.setPath("tmpPath", null, bl);
        this.partitionCount = this.getIntegerProperty("partitionCount", "0");
        this.partitions = new IdbVector(this.partitionCount);
        int n2 = 1;
        while (n2 <= this.partitionCount) {
            object2 = "partition" + n2;
            object = this.setPath((String)object2, null, false);
            this.partitions.addElement(object);
            ++n2;
        }
        this.createDir(this.tablePath);
        if (this.indexPath != null) {
            this.createDir(this.indexPath);
        }
        if (this.systemPath != null) {
            this.createDir(this.systemPath);
        }
        if (this.tmpPath != null) {
            this.createDir(this.tmpPath);
        }
        this.traceLevel = this.getIntegerProperty("traceLevel", "0");
        this.traceConsole = this.getIntegerProperty("traceConsole", "0");
        object2 = new Trace(this);
        ((Trace)object2).setExport((String)object3, this.traceLevel);
        this.export = ((Trace)object2).export;
        this.exportSQL = this.getIntegerProperty("exportSQL", "0");
        this.indexLoad = (float)this.getIntegerProperty("indexLoad", "5") / 100.0f;
        if (this.getIntegerProperty("resultsOnDisk", "0") != 0) {
            this.resultsOnDisk = true;
        }
        if (this.getIntegerProperty("readOnly", "0") != 0) {
            this.readOnly = true;
            this.resultsOnDisk = false;
        }
        this.defDateFormat = this.getStringProperty("dateFormat", "yyyy-mm-dd");
        this.defDateTimeFormat = this.getStringProperty("dateTimeFormat", "yyyy-mm-dd hh:mm:ss.lll");
        this.defCurrencySymbol = this.getStringProperty("currencySymbol", "$").charAt(0);
        this.defCurrencyDecimal = this.getIntegerProperty("currencyDecimal", "2");
        this.transLevel = this.getIntegerProperty("transLevel", "1");
        this.transImports = this.getIntegerProperty("transImports", "100");
        this.recoveryPolicy = this.getIntegerProperty("recoveryPolicy", "2");
        this.timerCheck = this.getIntegerProperty("timerCheck", "5000");
        this.fastUpdate = this.getIntegerProperty("fastUpdate", "0") != 0;
        this.strictLiterals = this.getIntegerProperty("strictLiterals", "0") != 0;
        this.likeIgnoreCase = this.getIntegerProperty("likeIgnoreCase", "0") != 0;
        this.milleniumBoundary = this.getIntegerProperty("milleniumBoundary", "0");
        this.altStringHashing = this.getIntegerProperty("altStringHashing", "0") != 0;
        this.nowMeansTime = this.getIntegerProperty("nowMeansTime", "0") != 0;
        this.searchDeletes = this.getIntegerProperty("searchDeletes", "0") != 0;
        this.prepareIgnoresEscapes = this.getIntegerProperty("prepareIgnoresEscapes", "0") != 0;
        this.controlColCacheSize = this.getIntegerProperty("controlColCacheSize", "8192");
        this.systemCacheCondition = this.translateCacheCondition(this.getStringProperty("systemCacheCondition", "CACHE_PERCENT"));
        this.systemCacheSize = this.getIntegerProperty("systemCacheSize", "100");
        this.systemRows = this.getIntegerProperty("systemRows", "0");
        try {
            object = this.getClass();
            synchronized (object) {
                if (SQLsyntax == null) {
                    SQLsyntax = new sqltoken(this);
                    SQLsyntax.setupSyntax();
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Internal error - problem locking Database class " + exception.toString());
        }
        object = this.getStringProperty("ignoreKeywords", "");
        if (((String)object).length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, ",;", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                SQLsyntax.removeReservedWord(string3);
            }
        }
        this.tblList = new Vector(20, 20);
        this.journal = new Journal(this);
        this.timerQueue = new Vector(10, 5);
        this.timerThread = new Thread(this);
        this.timerThread.start();
    }

    boolean isValid() {
        return this.valid;
    }

    void lockSystemTables(Transaction transaction) throws SQLException {
        this.colTable.lockTable(transaction, Transaction.WRITE);
        this.tblTable.lockTable(transaction, Transaction.WRITE);
        this.idxTable.lockTable(transaction, Transaction.WRITE);
    }

    void lockTables(Vector vector, Transaction transaction, int n) throws SQLException {
        Vector vector2 = this.getTables();
        int n2 = 0;
        while (n2 < vector2.size()) {
            Table table = (Table)vector2.elementAt(n2);
            int n3 = 0;
            while (n3 < vector.size()) {
                Table table2 = (Table)vector.elementAt(n3);
                if (table == table2) {
                    if (table.tblID == null) {
                        table.lockTable(transaction, n);
                    } else if (table.tblID < 1005) {
                        this.lockSystemTables(transaction);
                    } else {
                        table.lockTable(transaction, n);
                    }
                }
                ++n3;
            }
            ++n2;
        }
    }

    void releasePool(HashTablePool hashTablePool) {
        hashTablePool.freeAll();
        if (this.hashtables == null) {
            return;
        }
        Vector vector = this.hashtables;
        synchronized (vector) {
            this.hashtables.addElement(hashTablePool);
        }
    }

    public static void removeDatabase(Database database) {
        Vector vector = databases;
        synchronized (vector) {
            databases.removeElement(database);
        }
    }

    public void removeFromTimerQueue(Transaction transaction) {
        this.timerQueue.removeElement(transaction);
    }

    void removeTable(Table table) {
        if (this.tblList == null) {
            return;
        }
        Vector vector = this.tblList;
        synchronized (vector) {
            int n = this.getTableIndex(table);
            if (n < 0) {
                Object var3_4 = null;
                return;
            }
            this.tblList.removeElementAt(n);
        }
    }

    void returnStringBuffer(StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        Vector vector = this.stringbuffs;
        synchronized (vector) {
            this.stringbuffs.addElement(stringBuffer);
        }
    }

    public void run() {
        String string = String.valueOf(this.filename) + "$timer";
        this.timerThread.setName(string);
        while (true) {
            block8: {
                try {
                    Thread.sleep(this.timerCheck);
                }
                catch (InterruptedException interruptedException) {
                    if (this.timerQueue == null) break block8;
                    interruptedException.printStackTrace();
                }
            }
            Database database = this;
            synchronized (database) {
                if (this.timerQueue == null) {
                    Object var3_5 = null;
                    return;
                }
                Transaction transaction = this.getHeadOfTimerQueue();
                while (transaction != null) {
                    transaction = transaction.checkExpired() ? this.getHeadOfTimerQueue() : null;
                }
            }
        }
    }

    void setIndexPath(String string) throws SQLException {
        this.indexPath = string;
        this.createDir(string);
    }

    String setPath(String string, String string2, boolean bl) throws SQLException {
        Object object;
        String string3 = this.getStringProperty(string, string2);
        if (string3 != null) {
            if (string3.charAt(0) == '$') {
                object = string3.substring(1);
                string3 = System.getProperty((String)object);
            } else if (bl) {
                string3 = String.valueOf(this.propertiesPath) + File.separatorChar + string3;
            }
            string3 = this.switchSeparators(string3);
        } else {
            string3 = this.tablePath;
        }
        try {
            object = new File(string3);
            string3 = ((File)object).getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new SQLException("IO problem opening file: " + string3 + "\n" + iOException.toString());
        }
        return string3;
    }

    void setSystemTableCache(Column column) {
        column.setCacheCondition(this.systemCacheCondition, this.systemCacheSize);
    }

    public void setTableEncryption(String string, TableEncrypt tableEncrypt) throws SQLException {
        Table table = this.getTable(string);
        if (table == null) {
            throw new SQLException("Table not found: " + string + " - setting table encryption");
        }
        table.setTableEncryption(tableEncrypt);
    }

    void setTablePath(String string) throws SQLException {
        this.tablePath = string;
        this.createDir(string);
        File file = new File(string);
        if (file.isAbsolute()) {
            Properties properties = System.getProperties();
            ((Hashtable)properties).put("user.dir", string);
            System.setProperties(properties);
        }
    }

    void setTmpPath(String string) throws SQLException {
        this.tmpPath = string;
        this.createDir(string);
    }

    void shutdown(String string, boolean bl) throws SQLException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            shutdownActive = true;
            int n = databases.size();
            int n2 = n - 1;
            while (n2 >= 0) {
                Database database = (Database)databases.elementAt(n2);
                database.sysTrans.setSQL(string);
                if (!bl) {
                    database.lockTables(database.tblList, database.sysTrans, Transaction.READ);
                }
                database.openCount = 1;
                database.close(false);
                --n2;
            }
            shutdownActive = false;
        }
    }

    String switchSeparators(String string) {
        if (string == null) {
            return null;
        }
        char c = File.separatorChar == '\\' ? (char)'/' : '\\';
        String string2 = string.replace(c, File.separatorChar);
        return string2;
    }

    void traceMemory() {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory() - runtime.freeMemory();
        if (Trace.traceIt(128)) {
            Trace.traceOut("Total Memory=" + runtime.totalMemory() + " Free=" + runtime.freeMemory() + " Used " + l);
        }
    }

    int translateCacheCondition(String string) {
        if (string.equalsIgnoreCase("CACHE_ROWS")) {
            return 1;
        }
        return 2;
    }
}

