/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.utils;

public final class SymbolCache {
    public static final int CHAR_OFFSET = 0;
    public static final int INDEX_OFFSET = 1;
    public static final int NEXT_OFFSET = 2;
    public static final int CACHE_RECORD_SIZE = 3;
    public static final int INITIAL_CACHE_RECORD_COUNT = 4;
    public char[] fSymbolChars = new char[8192];
    public int fSymbolCharsOffset = 0;
    public int[][] fCacheLines = new int[8][];
    public int fCacheLineCount = 0;

    public SymbolCache() {
        this.fCacheLines[this.fCacheLineCount++] = new int[13];
    }

    public void reset() {
        this.fSymbolCharsOffset = 0;
        this.fCacheLineCount = 0;
        this.fCacheLines[this.fCacheLineCount++] = new int[13];
    }

    public char[] getSymbolChars() {
        return this.fSymbolChars;
    }

    public String createSymbol(int n, int n2, int n3, int[] nArray, int n4) {
        int n5 = this.fSymbolCharsOffset - n2;
        String string = new String(this.fSymbolChars, n2, n5);
        try {
            nArray[n4 + 1] = n;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new RuntimeException("UTL001 untested");
        }
        return string;
    }

    public int addSymbolToCache(String string, int n, int n2) {
        Object object;
        Object[] objectArray;
        int n3 = this.fSymbolCharsOffset;
        if (n == 0) {
            return n3;
        }
        int n4 = 0;
        char c = string.charAt(n4++);
        try {
            this.fSymbolChars[this.fSymbolCharsOffset] = c;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            objectArray = new char[this.fSymbolChars.length * 2];
            System.arraycopy(this.fSymbolChars, 0, objectArray, 0, this.fSymbolChars.length);
            this.fSymbolChars = objectArray;
            this.fSymbolChars[this.fSymbolCharsOffset] = c;
        }
        ++this.fSymbolCharsOffset;
        int n5 = 0;
        objectArray = this.fCacheLines[n5];
        int n6 = objectArray[0];
        int n7 = 0;
        int n8 = 1;
        while (n7 != n6) {
            if (objectArray[n8 + 0] != c) {
                ++n7;
                n8 += 3;
                continue;
            }
            if (n4 == n) {
                if (objectArray[n8 + 1] != '\uffffffff') {
                    throw new RuntimeException("addSymbolToCache");
                }
                objectArray[n8 + 1] = n2;
                return n3;
            }
            c = string.charAt(n4++);
            try {
                this.fSymbolChars[this.fSymbolCharsOffset] = c;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                char[] cArray = new char[this.fSymbolChars.length * 2];
                System.arraycopy(this.fSymbolChars, 0, cArray, 0, this.fSymbolChars.length);
                this.fSymbolChars = cArray;
                this.fSymbolChars[this.fSymbolCharsOffset] = c;
            }
            ++this.fSymbolCharsOffset;
            n5 = objectArray[n8 + 2];
            try {
                objectArray = this.fCacheLines[n5];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (n5 == -1) {
                    objectArray[n8 + 2] = n5 = this.fCacheLineCount++;
                    objectArray = new int[13];
                    try {
                        this.fCacheLines[n5] = objectArray;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException2) {
                        object = new int[n5 * 2][];
                        System.arraycopy(this.fCacheLines, 0, object, 0, n5);
                        this.fCacheLines = (int[][])object;
                        this.fCacheLines[n5] = objectArray;
                    }
                }
                objectArray = this.fCacheLines[n5];
                throw new RuntimeException("UTL001 untested");
            }
            n6 = objectArray[0];
            n7 = 0;
            n8 = 1;
        }
        while (true) {
            objectArray[0] = objectArray[0] + '\u0001';
            try {
                objectArray[n8 + 0] = c;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                int n9 = 1 + (n8 - 1) * 2;
                object = new int[n9];
                System.arraycopy(objectArray, 0, object, 0, n8);
                objectArray = (Object[])object;
                this.fCacheLines[n5] = object;
                objectArray[n8 + 0] = c;
            }
            if (n4 == n) break;
            ++this.fCacheLineCount;
            objectArray[n8 + 1] = -1;
            objectArray[n8 + 2] = n5;
            objectArray = new int[13];
            try {
                this.fCacheLines[n5] = objectArray;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                int[][] nArrayArray = new int[n5 * 2][];
                System.arraycopy(this.fCacheLines, 0, nArrayArray, 0, n5);
                this.fCacheLines = nArrayArray;
                this.fCacheLines[n5] = objectArray;
            }
            n8 = 1;
            c = string.charAt(n4++);
            try {
                this.fSymbolChars[this.fSymbolCharsOffset] = c;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                char[] cArray = new char[this.fSymbolChars.length * 2];
                System.arraycopy(this.fSymbolChars, 0, cArray, 0, this.fSymbolChars.length);
                this.fSymbolChars = cArray;
                this.fSymbolChars[this.fSymbolCharsOffset] = c;
            }
            ++this.fSymbolCharsOffset;
        }
        objectArray[n8 + 1] = n2;
        objectArray[n8 + 2] = -1;
        return n3;
    }

    public void updateCacheLine(int n, int n2, int n3) {
        int n4 = 0;
        int[] nArray = this.fCacheLines[0];
        int n5 = this.fSymbolChars[n++];
        int n6 = nArray[0];
        int n7 = 1 + (n6 - 1) * 3;
        int n8 = 0;
        while (true) {
            if (n5 != nArray[n7 + 0]) {
                n7 -= 3;
                ++n8;
                continue;
            }
            if (n8 > 4) {
                int n9 = nArray[n7 + 1];
                int n10 = nArray[n7 + 2];
                System.arraycopy(nArray, n7 + 3, nArray, n7, n8 * 3);
                n7 = 1 + (n6 - 1) * 3;
                nArray[n7 + 0] = n5;
                nArray[n7 + 1] = n9;
                nArray[n7 + 2] = n10;
            }
            if (--n3 == 0) break;
            n4 = nArray[n7 + 2];
            nArray = this.fCacheLines[n4];
            n5 = this.fSymbolChars[n++];
            n6 = nArray[0];
            n7 = 1 + (n6 - 1) * 3;
            n8 = 0;
        }
    }
}

