/**************************************************************
*   
*   Creation Date: <97/07/03 13:44:49 samuel>
*   Time-stamp: <2001/03/11 17:35:53 samuel>
*   
*	<promif.h>
*	
*	Prom interface
*   
*   Copyright (C) 1997, 1999, 2000 Samuel Rydh
*
*   This program is free software; you can redistribute it and/or
*   modify it under the terms of the GNU General Public License
*   as published by the Free Software Foundation;
*
**************************************************************/

#ifndef _H_PROMIF
#define _H_PROMIF

#include "prom.h"

extern void 	promif_init( void );
extern void 	promif_cleanup( void );

/*
 * To device trees are maintained. The hardware tree
 * describes the hardware of the machine running the software.
 * Functions with the 'hw' suffix accesses this tree.
 *
 * The emulation tree describes the hardware of the machine
 * beeing emulated. It is the emulation tree which normally
 * should be used.
 */

/* The automatically generated node identifier (phandle) starts at PHANDLE_BASE.
 * Lower values are reserved for manual modifications of the oftree file.
 */
#define PHANDLE_BASE	0x1000

extern ulong	  	 prom_dn_to_phandle( mol_device_node_t *dn );
extern mol_device_node_t *prom_phandle_to_dn( ulong phandle );

extern mol_device_node_t *prom_find_dev_by_path( char *path );

extern mol_device_node_t *prom_find_devices( char *name);
extern mol_device_node_t *prom_find_devices_hw( char *name);

extern mol_device_node_t *prom_find_type( char *type );
extern mol_device_node_t *prom_find_type_hw( char *type );

extern mol_device_node_t *prom_get_root( void );
extern mol_device_node_t *prom_get_root_hw( void );

extern int		 is_ancestor( mol_device_node_t *par, mol_device_node_t *child );

extern mol_device_node_t *prom_create_node( char *path  );
extern mol_device_node_t *prom_add_node( mol_device_node_t *par, char *name );
extern mol_device_node_t *prom_import_node( mol_device_node_t *par, char *filename );
extern int		 prom_delete_node( mol_device_node_t *dn );

extern unsigned char 	 *prom_get_property(mol_device_node_t *np, const char *name, int *lenp);
extern unsigned char 	 *prom_get_prop_by_path( char *path, int *retlen );
extern char		 *prom_next_property( mol_device_node_t *dn, const char *prev_name );
extern void		 prom_add_property( mol_device_node_t *dn, const char *name, char *data, int len );

#endif
