/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons.model;

import org.rubyforge.debugcommons.RubyDebugEvent;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.Util;
import org.rubyforge.debugcommons.model.IRubyBreakpoint;
import org.rubyforge.debugcommons.model.RubyDebugTarget;
import org.rubyforge.debugcommons.model.RubyEntity;
import org.rubyforge.debugcommons.model.RubyFrame;
import org.rubyforge.debugcommons.model.SuspensionPoint;

public final class RubyThread
extends RubyEntity {
    private final int id;
    private String name;
    private RubyFrame[] frames;
    private boolean isSuspended;
    private IRubyBreakpoint temporaryBreakpoint;

    public RubyThread(RubyDebugTarget target, int id) {
        super(target.getProxy());
        this.id = id;
        this.updateName();
    }

    public RubyFrame[] getFrames() throws RubyDebuggerException {
        if (this.frames == null) {
            this.frames = this.isSuspended() ? this.getProxy().readFrames(this) : new RubyFrame[0];
        }
        return this.frames;
    }

    public RubyFrame getTopFrame() throws RubyDebuggerException {
        RubyFrame[] frames = this.getFrames();
        return frames.length == 0 ? null : frames[0];
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    protected void resume(boolean isStep) {
        this.isSuspended = false;
        this.frames = null;
        this.updateName();
    }

    public void resume() {
        this.resume(false);
        this.getProxy().resume(this);
    }

    public void suspend(SuspensionPoint suspensionPoint) {
        if (this.temporaryBreakpoint != null) {
            this.getProxy().removeBreakpoint(this.temporaryBreakpoint);
            this.temporaryBreakpoint = null;
        }
        this.frames = null;
        this.isSuspended = true;
        this.updateName(suspensionPoint);
        RubyDebugEvent ev = new RubyDebugEvent(this, suspensionPoint);
        this.getProxy().fireDebugEvent(ev);
    }

    public boolean canStepInto() throws RubyDebuggerException {
        return this.isSuspended && this.getFrames().length > 0;
    }

    public boolean canStepOver() throws RubyDebuggerException {
        return this.isSuspended && this.getFrames().length > 0;
    }

    public void stepInto(boolean forceNewLine) throws RubyDebuggerException {
        this.updateName();
        RubyFrame frame = this.getTopFrame();
        if (frame == null) {
            Util.fine("stepInto failed, not top stack frame (thread is not suspended?)");
        } else {
            frame.stepInto(forceNewLine);
        }
    }

    public void stepInto() throws RubyDebuggerException {
        this.stepInto(false);
    }

    public void stepOver(boolean forceNewLine) throws RubyDebuggerException {
        RubyFrame frame = this.getTopFrame();
        if (frame == null) {
            Util.fine("stepOver failed, not top stack frame (thread is not suspended?)");
        } else {
            frame.stepOver(forceNewLine);
        }
    }

    public void stepOver() throws RubyDebuggerException {
        this.stepOver(false);
    }

    public void stepReturn() throws RubyDebuggerException {
        RubyFrame frame = this.getTopFrame();
        if (frame == null) {
            Util.fine("stepReturn failed, empty frame stack (thread is not suspended?)");
        } else {
            frame.stepReturn();
        }
    }

    public void runTo(final String path, final int line) throws RubyDebuggerException {
        this.temporaryBreakpoint = new IRubyBreakpoint(){

            public boolean isEnabled() {
                return true;
            }

            public String getFilePath() {
                return path;
            }

            public int getLineNumber() {
                return line;
            }
        };
        this.getProxy().addBreakpoint(this.temporaryBreakpoint);
        this.resume();
    }

    private void updateName() {
        this.updateName(null);
    }

    private void updateName(SuspensionPoint suspensionPoint) {
        this.name = "Ruby Thread - " + this.getId();
        if (suspensionPoint != null) {
            this.name = this.name + " (" + suspensionPoint + ")";
        }
    }

    public int getId() {
        return this.id;
    }
}

