/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.LinearGradientPaintDef;
import com.sun.perseus.j2d.PaintDef;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.FloatTraitAnim;
import com.sun.perseus.model.GradientElement;
import com.sun.perseus.model.TraitAnim;
import org.w3c.dom.DOMException;

public class LinearGradient
extends GradientElement {
    float x1;
    float y1;
    float x2 = 1.0f;
    float y2 = 0.0f;

    public LinearGradient(DocumentNode ownerDocument) {
        super(ownerDocument);
        this.isObjectBBox = true;
    }

    public String getLocalName() {
        return "linearGradient";
    }

    public ElementNode newInstance(DocumentNode doc) {
        return new LinearGradient(doc);
    }

    public void setX1(float newX1) {
        if (newX1 == this.x1) {
            return;
        }
        this.x1 = newX1;
        this.onPaintChange();
    }

    public float getX1() {
        return this.x1;
    }

    public void setY1(float newY1) {
        if (newY1 == this.y1) {
            return;
        }
        this.y1 = newY1;
        this.onPaintChange();
    }

    public float getY1() {
        return this.y1;
    }

    public void setX2(float newX2) {
        if (newX2 == this.x2) {
            return;
        }
        this.x2 = newX2;
        this.onPaintChange();
    }

    public float getX2() {
        return this.x2;
    }

    public void setY2(float newY2) {
        if (newY2 == this.y2) {
            return;
        }
        this.y2 = newY2;
        this.onPaintChange();
    }

    public float getY2() {
        return this.y2;
    }

    boolean supportsTrait(String traitName) {
        if ("x1" == traitName || "x2" == traitName || "y1" == traitName || "y2" == traitName) {
            return true;
        }
        return super.supportsTrait(traitName);
    }

    TraitAnim createTraitAnimImpl(String traitName) {
        if ("x1" == traitName || "x2" == traitName || "y1" == traitName || "y2" == traitName) {
            return new FloatTraitAnim(this, traitName, "float");
        }
        return super.createTraitAnimImpl(traitName);
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("x1" == name) {
            return Float.toString(this.x1);
        }
        if ("y1" == name) {
            return Float.toString(this.y1);
        }
        if ("x2" == name) {
            return Float.toString(this.x2);
        }
        if ("y2" == name) {
            return Float.toString(this.y2);
        }
        return super.getTraitImpl(name);
    }

    float getFloatTraitImpl(String name) throws DOMException {
        if ("x1" == name) {
            return this.x1;
        }
        if ("y1" == name) {
            return this.y1;
        }
        if ("x2" == name) {
            return this.x2;
        }
        if ("y2" == name) {
            return this.y2;
        }
        return super.getFloatTraitImpl(name);
    }

    void setFloatArrayTrait(String name, float[][] value) throws DOMException {
        if ("x1" == name) {
            this.setX1(value[0][0]);
        } else if ("y1" == name) {
            this.setY1(value[0][0]);
        } else if ("x2" == name) {
            this.setX2(value[0][0]);
        } else if ("y2" == name) {
            this.setY2(value[0][0]);
        } else {
            super.setFloatArrayTrait(name, value);
        }
    }

    public float[][] validateFloatArrayTrait(String traitName, String value, String reqNamespaceURI, String reqLocalName, String reqTraitNamespace, String reqTraitName) throws DOMException {
        if ("x1" == traitName || "x2" == traitName || "y1" == traitName || "y2" == traitName) {
            return new float[][]{{this.parseFloatTrait(traitName, value)}};
        }
        return super.validateFloatArrayTrait(traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
    }

    public void setTraitImpl(String name, String value) throws DOMException {
        if ("x1" == name) {
            this.setX1(this.parseFloatTrait(name, value));
        } else if ("y1" == name) {
            this.setY1(this.parseFloatTrait(name, value));
        } else if ("x2" == name) {
            this.setX2(this.parseFloatTrait(name, value));
        } else if ("y2" == name) {
            this.setY2(this.parseFloatTrait(name, value));
        } else {
            super.setTraitImpl(name, value);
        }
    }

    public void setFloatTraitImpl(String name, float value) throws DOMException {
        if ("x1" == name) {
            this.setX1(value);
        } else if ("y1" == name) {
            this.setY1(value);
        } else if ("x2" == name) {
            this.setX2(value);
        } else if ("y2" == name) {
            this.setY2(value);
        } else {
            super.setFloatTraitImpl(name, value);
        }
    }

    String toStringTrait(String name, float[][] value) {
        if ("x1" == name || "y1" == name || "x2" == name || "y2" == name) {
            return Float.toString(value[0][0]);
        }
        return super.toStringTrait(name, value);
    }

    protected PaintDef computePaint() {
        if (this.computedPaint == null) {
            this.buildGradientColorMap();
            this.computedPaint = new LinearGradientPaintDef(this.x1, this.y1, this.x2, this.y2, this.lastColorMapFractions, this.lastColorMapRGBA, 0, this.isObjectBBox, this.transform);
        }
        return this.computedPaint;
    }
}

