/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.platform;

import java.io.IOException;
import java.net.URL;
import javax.media.CannotRealizeException;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DurationUpdateEvent;
import javax.media.GainControl;
import javax.media.Manager;
import javax.media.NoPlayerException;
import javax.media.Player;
import javax.media.RealizeCompleteEvent;
import javax.media.Time;
import javax.media.TransitionEvent;

public class MediaPlayer
implements ControllerListener {
    public static int UNREALIZED;
    public static int STARTED;
    public static int PREFETCHED;
    public static int CLOSED;
    protected Player player;
    private GainControl gc;
    private float volume;
    private int state = UNREALIZED;

    MediaPlayer(String type, String urlStr) throws Exception {
        if (type == null || urlStr == null) {
            throw new Exception("URL is null");
        }
        try {
            URL url = new URL(urlStr);
            this.player = Manager.createRealizedPlayer((URL)url);
        }
        catch (NoPlayerException e) {
            throw new Exception("Could not create player for " + urlStr);
        }
        catch (IOException e) {
            throw new Exception("IO exception creating player for " + urlStr);
        }
        catch (CannotRealizeException e) {
            throw new Exception("Cannot realize player for " + urlStr);
        }
        this.player.addControllerListener((ControllerListener)this);
        this.gc = this.player.getGainControl();
    }

    public void play(long startTime) {
        if (this.player != null) {
            this.player.setMediaTime(new Time(startTime * 1000000L));
            this.player.start();
        }
    }

    public void stop() {
        if (this.player != null) {
            this.player.stop();
        }
    }

    public void close() {
        if (this.player != null) {
            this.player.deallocate();
            this.player.close();
            this.player.removeControllerListener((ControllerListener)this);
            this.player = null;
        }
    }

    public void setVolume(float volume) {
        if (this.gc != null) {
            this.gc.setLevel(volume);
        }
    }

    public float getVolume() {
        float volume = 0.0f;
        if (this.gc != null) {
            volume = this.gc.getLevel();
        }
        return volume;
    }

    public long getMediaTime() {
        long time = 0L;
        if (this.player != null) {
            time = this.player.getMediaTime().getNanoseconds();
            time /= 1000000L;
        }
        return time;
    }

    public int getState() {
        return this.state;
    }

    public synchronized void controllerUpdate(ControllerEvent event) {
        if (event instanceof DurationUpdateEvent) {
            Time duration = ((DurationUpdateEvent)event).getDuration();
        } else if (event instanceof TransitionEvent) {
            int state = ((TransitionEvent)event).getCurrentState();
            if (state == 500) {
                state = PREFETCHED;
            } else if (state != 300) {
                if (state == 600) {
                    state = STARTED;
                } else if (state == 100) {
                    int n = UNREALIZED;
                }
            }
        } else if (event instanceof RealizeCompleteEvent) {
            this.gc = this.player.getGainControl();
            if (this.gc != null) {
                this.gc.setLevel(this.volume);
            }
        } else if (event instanceof ControllerClosedEvent) {
            this.state = CLOSED;
        }
    }
}

