/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.util;

import com.sun.perseus.platform.ThreadSupport;
import com.sun.perseus.util.DoublyLinkedList;
import com.sun.perseus.util.Scheduler;

public final class RunnableQueue
implements Runnable {
    public static final String RUNNING = "Running";
    public static final String SUSPENDING = "Suspending";
    public static final String SUSPENDED = "Suspended";
    public static final String TERMINATED = "Terminated";
    protected static RunnableQueue defaultQueue;
    protected String state;
    protected Object stateLock = new Object();
    protected Scheduler scheduler = new Scheduler(this);
    protected DoublyLinkedList list = new DoublyLinkedList();
    protected RunnableQueueHandler queueHandler;
    protected Thread runnableQueueThread;
    private static int threadCount;

    private RunnableQueue() {
    }

    public static RunnableQueue getDefault() {
        if (defaultQueue != null) {
            return defaultQueue;
        }
        defaultQueue = RunnableQueue.createRunnableQueue(new VoidQueueHandler());
        defaultQueue.resumeExecution();
        return defaultQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RunnableQueue createRunnableQueue(RunnableQueueHandler queueHandler) {
        RunnableQueue result = new RunnableQueue();
        if (queueHandler == null) {
            queueHandler = new VoidQueueHandler();
        }
        result.queueHandler = queueHandler;
        Object object = result;
        synchronized (object) {
            Thread t = new Thread((Runnable)result, "RunnableQueue-" + threadCount++);
            ThreadSupport.setDaemon(t, true);
            t.setPriority(1);
            t.start();
            while (result.getThread() == null) {
                try {
                    result.wait();
                }
                catch (InterruptedException ie) {}
            }
        }
        object = result.stateLock;
        synchronized (object) {
            try {
                while (result.state != SUSPENDED) {
                    result.stateLock.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        RunnableQueue runnableQueue = this;
        synchronized (runnableQueue) {
            this.runnableQueueThread = Thread.currentThread();
            this.notify();
        }
        Link l = null;
        Runnable rable = null;
        long t = 0L;
        long wait = 0L;
        try {
            while (!ThreadSupport.isInterrupted(Thread.currentThread())) {
                Object object = this.stateLock;
                synchronized (object) {
                    if (this.state != RUNNING) {
                        this.state = SUSPENDED;
                        this.stateLock.notifyAll();
                        this.queueHandler.executionSuspended(this);
                        while (this.state != RUNNING) {
                            this.state = SUSPENDED;
                            this.stateLock.wait();
                        }
                        this.stateLock.notifyAll();
                        this.queueHandler.executionResumed(this);
                    }
                }
                t = System.currentTimeMillis();
                this.scheduler.run(t);
                object = this.list;
                synchronized (object) {
                    l = (Link)this.list.pop();
                    if (l == null) {
                        wait = this.scheduler.nextRun(System.currentTimeMillis());
                        if (wait == 0L) {
                            wait = 1L;
                        }
                        if (this.state == SUSPENDING) {
                            continue;
                        }
                        if (wait > 0L) {
                            this.list.wait(wait);
                        } else {
                            this.list.wait();
                        }
                        continue;
                    }
                    rable = l.runnable;
                }
                try {
                    rable.run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (l.runHandler != null) {
                    l.runHandler.runnableInvoked(this, rable);
                }
                l.unlock();
                rable = null;
            }
        }
        catch (InterruptedException e) {
            if (this == defaultQueue) {
                defaultQueue = null;
            }
            e.printStackTrace();
        }
        finally {
            if (this == defaultQueue) {
                defaultQueue = null;
            }
            System.err.println(">>>>>>>>>>>>>> RunnableQueue terminating");
            Object object = this;
            synchronized (object) {
                this.runnableQueueThread = null;
            }
            object = this.stateLock;
            synchronized (object) {
                this.state = TERMINATED;
                this.stateLock.notifyAll();
            }
        }
    }

    public Thread getThread() {
        return this.runnableQueueThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void empty() {
        DoublyLinkedList doublyLinkedList = this.list;
        synchronized (doublyLinkedList) {
            this.list.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        DoublyLinkedList doublyLinkedList = this.list;
        synchronized (doublyLinkedList) {
            return this.list.getSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable getNextPending() {
        DoublyLinkedList doublyLinkedList = this.list;
        synchronized (doublyLinkedList) {
            if (this.list.getSize() == 0) {
                return null;
            }
            return ((Link)this.list.getHead()).runnable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleAtFixedRate(Runnable r, RunnableHandler runHandler, long interval) {
        this.scheduler.add(r, interval, runHandler);
        DoublyLinkedList doublyLinkedList = this.list;
        synchronized (doublyLinkedList) {
            this.list.notify();
        }
    }

    public void unschedule(Runnable r) {
        this.scheduler.remove(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeLater(Runnable r, RunnableHandler runHandler) {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        DoublyLinkedList doublyLinkedList = this.list;
        synchronized (doublyLinkedList) {
            this.list.push(new Link(r, runHandler));
            this.list.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAndWait(Runnable r, RunnableHandler runHandler) throws InterruptedException {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        if (this.runnableQueueThread == Thread.currentThread()) {
            throw new IllegalStateException("Cannot be called from the RunnableQueue thread");
        }
        LockableLink l = new LockableLink(r, runHandler);
        DoublyLinkedList doublyLinkedList = this.list;
        synchronized (doublyLinkedList) {
            this.list.push(l);
            this.list.notify();
        }
        l.lock();
    }

    public void safeInvokeAndWait(Runnable r, RunnableHandler runHandler) {
        if (this.runnableQueueThread == Thread.currentThread()) {
            r.run();
            runHandler.runnableInvoked(this, r);
        }
        try {
            this.invokeAndWait(r, runHandler);
        }
        catch (InterruptedException ie) {
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preemptLater(Runnable r, RunnableHandler runHandler) {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        DoublyLinkedList doublyLinkedList = this.list;
        synchronized (doublyLinkedList) {
            this.list.unpop(new Link(r, runHandler));
            this.list.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preemptAndWait(Runnable r, RunnableHandler runHandler) throws InterruptedException {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        if (this.runnableQueueThread == Thread.currentThread()) {
            throw new IllegalStateException("Cannot be called from the RunnableQueue thread");
        }
        LockableLink l = new LockableLink(r, runHandler);
        DoublyLinkedList doublyLinkedList = this.list;
        synchronized (doublyLinkedList) {
            this.list.unpop(l);
            this.list.notify();
        }
        l.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getQueueState() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendExecution(boolean waitTillSuspended) {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == SUSPENDED) {
                return;
            }
            if (this.state == RUNNING) {
                this.state = SUSPENDING;
                DoublyLinkedList doublyLinkedList = this.list;
                synchronized (doublyLinkedList) {
                    this.list.notify();
                }
            }
            if (waitTillSuspended) {
                try {
                    this.stateLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeExecution() {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != RUNNING) {
                this.state = RUNNING;
                this.stateLock.notifyAll();
                try {
                    this.stateLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    protected static class LockableLink
    extends Link {
        protected boolean locked;

        public LockableLink(Runnable r, RunnableHandler runHandler) {
            super(r, runHandler);
        }

        public synchronized void lock() throws InterruptedException {
            this.locked = true;
            this.notify();
            this.wait();
        }

        public synchronized void unlock() throws InterruptedException {
            while (!this.locked) {
                this.wait();
            }
            this.notify();
        }
    }

    protected static class Link
    extends DoublyLinkedList.Node {
        protected Runnable runnable;
        protected RunnableHandler runHandler;

        public Link(Runnable r, RunnableHandler runHandler) {
            this.runnable = r;
            this.runHandler = runHandler;
        }

        public void unlock() throws InterruptedException {
        }
    }

    public static class VoidQueueHandler
    implements RunnableQueueHandler {
        public void executionSuspended(RunnableQueue rq) {
        }

        public void executionResumed(RunnableQueue rq) {
        }
    }

    public static interface RunnableQueueHandler {
        public void executionSuspended(RunnableQueue var1);

        public void executionResumed(RunnableQueue var1);
    }

    public static interface RunnableHandler {
        public void runnableInvoked(RunnableQueue var1, Runnable var2);
    }
}

