/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.OperationContext;
import com.sun.jdmk.ThreadContext;
import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.BASE64Decoder;
import com.sun.jdmk.comm.BASE64Encoder;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.GenericHttpClientHandler;
import com.sun.jdmk.comm.GenericHttpConnectorServer;
import com.sun.jdmk.comm.GenericHttpSocket;
import com.sun.jdmk.comm.HttpRequest;
import com.sun.jdmk.comm.HttpResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Hashtable;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;

class GenericHttpRequestHandler
extends GenericHttpClientHandler {
    private static final String[] supportedFeatures = new String[]{"OperationContext"};
    private static final String[] methodList = new String[]{"createMBean 2 ObjectInstance", "createMBeanParams 4 ObjectInstance 2", "createMBeanLoader 3 ObjectInstance", "createMBeanLoaderParams 5 ObjectInstance 3", "getAttribute 2 Object", "getAttributes 2 AttributeList", "getDefaultDomain 0 String", "isInstanceOf 2 Boolean", "getObjectInstance 1 ObjectInstance", "getMBeanCount 0 Integer", "getMBeanServerId 0 String", "getMBeanInfo 1 MBeanInfo", "invoke 4 Object 1", "isRegistered 1 Boolean", "queryNames 2 Set", "queryMBeans 2 Set", "setAttribute 2 Object 1", "setAttributes 2 AttributeList 1", "unregisterMBean 1 Object", "remoteRequest 2 Object[]", "pingHeartBeatServer 4 String", "supports 1 Boolean"};
    private static final int CREATE_MBEAN = 0;
    private static final int CREATE_MBEAN_PARAMS = 1;
    private static final int CREATE_MBEAN_LOADER = 2;
    private static final int CREATE_MBEAN_LOADER_PARAMS = 3;
    private static final int GET_ATTRIBUTE = 4;
    private static final int GET_ATTRIBUTES = 5;
    private static final int GET_DEFAULT_DOMAIN = 6;
    private static final int IS_INSTANCE_OF = 7;
    private static final int GET_OBJECT_INSTANCE = 8;
    private static final int GET_MBEAN_COUNT = 9;
    private static final int GET_MBEAN_SERVER_ID = 10;
    private static final int GET_MBEAN_INFO = 11;
    private static final int INVOKE = 12;
    private static final int IS_REGISTERED = 13;
    private static final int QUERY_NAMES = 14;
    private static final int QUERY_MBEANS = 15;
    private static final int SET_ATTRIBUTE = 16;
    private static final int SET_ATTRIBUTES = 17;
    private static final int UNREGISTER_MBEAN = 18;
    private static final int REMOTE_REQUEST = 19;
    private static final int PING_HEART_BEAT_SERVER = 20;
    private static final int SUPPORTS = 21;
    private static final Hashtable methodTable = new Hashtable();

    public GenericHttpRequestHandler(GenericHttpConnectorServer genericHttpConnectorServer, int n, GenericHttpSocket genericHttpSocket, MBeanServer mBeanServer, ObjectName objectName) {
        super(genericHttpConnectorServer, n, genericHttpSocket, mBeanServer, objectName);
        if (mBeanServer == null) {
            throw new CommunicationException("No MBeanServer provided");
        }
    }

    protected AuthInfo authenticateRequest(HttpRequest httpRequest) throws IOException {
        GenericHttpConnectorServer genericHttpConnectorServer = (GenericHttpConnectorServer)this.adaptorServer;
        if (!genericHttpConnectorServer.isAuthenticationOn()) {
            return this.makeNullAuthInfo();
        }
        AuthInfo authInfo = null;
        String string = httpRequest.getHeader(5);
        if (string != null && string.startsWith("CRAM-MD5 ")) {
            String string2 = string.substring("CRAM-MD5 ".length());
            byte[] byArray = new BASE64Decoder().decodeBuffer(string2);
            String string3 = new String(byArray);
            authInfo = genericHttpConnectorServer.checkChallengeResponse(string3);
        }
        if (this.logger.finestOn()) {
            if (authInfo != null) {
                this.logger.finest("authenticateRequest", "Authentication succeeded");
            } else {
                this.logger.finest("authenticateRequest", "Authentication failed");
            }
        }
        return authInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected HttpResponse processPostRequest(HttpRequest httpRequest) throws IOException {
        Object object;
        String string;
        Object object2;
        block23: {
            ThreadContext threadContext;
            block24: {
                HttpResponse httpResponse;
                block22: {
                    Object object3;
                    if (this.logger.finerOn()) {
                        this.logger.finer("processPostRequest", "Process a POST request = " + httpRequest.getURIPath());
                    }
                    if (httpRequest.getContentLength() == 0) {
                        CommunicationException communicationException = new CommunicationException("Content is null");
                        return this.makeExceptionResponse(communicationException);
                    }
                    String string2 = null;
                    threadContext = null;
                    try {
                        Object[] objectArray;
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(httpRequest.getContentBytes());
                        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                        object2 = objectInputStream.readObject();
                        if (object2 instanceof OperationContext) {
                            threadContext = ThreadContext.push("OperationContext", object2);
                            object2 = objectInputStream.readObject();
                        }
                        string2 = (String)object2;
                        if (this.logger.finerOn()) {
                            this.logger.finer("doRun", "Remote operation: " + string2);
                        }
                        if ((object3 = (ParsedMethod)methodTable.get(string2)) == null) {
                            if (this.logger.finerOn()) {
                                this.logger.finer("doRun", "Unknown remote operation: " + string2);
                            }
                            httpResponse = this.makeErrorResponse(400, "Bad Request");
                            if (threadContext == null) return httpResponse;
                            break block22;
                        }
                        string = ((ParsedMethod)object3).resultType;
                        if (((ParsedMethod)object3).magicParam > 0) {
                            objectArray = this.readObjects(objectInputStream, ((ParsedMethod)object3).magicParam);
                            switch (((ParsedMethod)object3).methodNumber) {
                                case 1: {
                                    objectInputStream = this.mbs.deserialize((String)objectArray[0], httpRequest.getContentBytes());
                                    break;
                                }
                                case 3: {
                                    objectInputStream = this.mbs.deserialize((String)objectArray[0], (ObjectName)objectArray[2], httpRequest.getContentBytes());
                                    break;
                                }
                                case 12: 
                                case 16: 
                                case 17: {
                                    objectInputStream = this.mbs.deserialize((ObjectName)objectArray[0], httpRequest.getContentBytes());
                                    break;
                                }
                                default: {
                                    throw new Error("method marked as magic but not in switch: " + string2);
                                }
                            }
                            object2 = objectInputStream.readObject();
                            if (object2 instanceof OperationContext) {
                                object2 = objectInputStream.readObject();
                            }
                            if (!((String)object2).equals(string2)) {
                                throw new Error("remoteOp changed after deserialize");
                            }
                        }
                        objectArray = this.readObjects(objectInputStream, ((ParsedMethod)object3).nParams);
                        object = this.doOperation(((ParsedMethod)object3).methodNumber, objectArray);
                        if (threadContext == null) break block23;
                        break block24;
                    }
                    catch (Exception exception) {
                        if (this.logger.finerOn()) {
                            this.logger.finer("doRun", string2 + ":" + exception.getMessage());
                        }
                        object3 = this.makeExceptionResponse(exception);
                        return object3;
                    }
                }
                ThreadContext.restore(threadContext);
                return httpResponse;
            }
            ThreadContext.restore(threadContext);
            break block23;
            finally {
                if (threadContext != null) {
                    ThreadContext.restore(threadContext);
                }
            }
        }
        object2 = this.serialize(string, object);
        return this.makeOkResponse(((ByteArrayOutputStream)object2).toByteArray());
    }

    Object doOperation(int n, Object[] objectArray) throws Exception {
        switch (n) {
            case 0: {
                return this.createMBean((String)objectArray[0], (ObjectName)objectArray[1]);
            }
            case 1: {
                return this.createMBean((String)objectArray[0], (ObjectName)objectArray[1], (Object[])objectArray[2], (String[])objectArray[3]);
            }
            case 2: {
                return this.createMBean((String)objectArray[0], (ObjectName)objectArray[1], (ObjectName)objectArray[2]);
            }
            case 3: {
                return this.createMBean((String)objectArray[0], (ObjectName)objectArray[1], (ObjectName)objectArray[2], (Object[])objectArray[3], (String[])objectArray[4]);
            }
            case 4: {
                return this.getAttribute((ObjectName)objectArray[0], (String)objectArray[1]);
            }
            case 5: {
                return this.getAttributes((ObjectName)objectArray[0], (String[])objectArray[1]);
            }
            case 6: {
                return this.getDefaultDomain();
            }
            case 7: {
                return new Boolean(this.isInstanceOf((ObjectName)objectArray[0], (String)objectArray[1]));
            }
            case 8: {
                return this.getObjectInstance((ObjectName)objectArray[0]);
            }
            case 9: {
                return this.getMBeanCount();
            }
            case 10: {
                return this.getMBeanServerId();
            }
            case 11: {
                return this.getMBeanInfo((ObjectName)objectArray[0]);
            }
            case 12: {
                return this.invoke((ObjectName)objectArray[0], (String)objectArray[1], (Object[])objectArray[2], (String[])objectArray[3]);
            }
            case 13: {
                return new Boolean(this.isRegistered((ObjectName)objectArray[0]));
            }
            case 14: {
                return this.queryNames((ObjectName)objectArray[0], (QueryExp)objectArray[1]);
            }
            case 15: {
                return this.queryMBeans((ObjectName)objectArray[0], (QueryExp)objectArray[1]);
            }
            case 16: {
                this.setAttribute((ObjectName)objectArray[0], (Attribute)objectArray[1]);
                return null;
            }
            case 17: {
                return this.setAttributes((ObjectName)objectArray[0], (AttributeList)objectArray[1]);
            }
            case 18: {
                this.unregisterMBean((ObjectName)objectArray[0]);
                return null;
            }
            case 19: {
                int n2 = (Integer)objectArray[0];
                return this.remoteRequest(n2, (Object[])objectArray[1]);
            }
            case 20: {
                return this.pingHeartBeatServer((String)objectArray[0], (Integer)objectArray[1], (Integer)objectArray[2], (Long)objectArray[3]);
            }
            case 21: {
                return new Boolean(this.supports((String)objectArray[0]));
            }
        }
        throw new Error("internal error: bad method number " + n);
    }

    private Object[] readObjects(ObjectInputStream objectInputStream, int n) throws IOException, ClassNotFoundException {
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = objectInputStream.readObject();
        }
        return objectArray;
    }

    protected String getChallenge() {
        GenericHttpConnectorServer genericHttpConnectorServer = (GenericHttpConnectorServer)this.adaptorServer;
        if (genericHttpConnectorServer.isAuthenticationOn()) {
            String string = genericHttpConnectorServer.generateChallengeResponse();
            String string2 = "";
            String string3 = null;
            int n = string.length() / 57;
            int n2 = string.length() % 57;
            for (int i = 0; i < n; ++i) {
                string3 = string.substring(i * 57, (i + 1) * 57);
                string2 = string2 + new BASE64Encoder().encode(string3.getBytes());
            }
            if (n2 > 0) {
                string3 = string.substring(n * 57);
                string2 = string2 + new BASE64Encoder().encode(string3.getBytes());
            }
            return "CRAM-MD5 " + string2;
        }
        return null;
    }

    private ObjectInstance createMBean(String string, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanException, MBeanRegistrationException, NotCompliantMBeanException, ReflectionException {
        if (this.logger.finerOn()) {
            this.logger.finer("createMBean", "createMBean");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        return this.mbs.createMBean(string, objectName);
    }

    private ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws InstanceAlreadyExistsException, MBeanException, MBeanRegistrationException, NotCompliantMBeanException, ReflectionException {
        if (this.logger.finerOn()) {
            this.logger.finer("createMBean", "createMBean");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        return this.mbs.createMBean(string, objectName, objectArray, stringArray);
    }

    private ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws InstanceAlreadyExistsException, MBeanException, MBeanRegistrationException, NotCompliantMBeanException, ReflectionException, InstanceNotFoundException {
        if (this.logger.finerOn()) {
            this.logger.finer("createMBean", "createMBean");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        return this.mbs.createMBean(string, objectName, objectName2);
    }

    private ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws InstanceAlreadyExistsException, MBeanException, MBeanRegistrationException, NotCompliantMBeanException, ReflectionException, InstanceNotFoundException {
        if (this.logger.finerOn()) {
            this.logger.finer("createMBean", "createMBean");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        return this.mbs.createMBean(string, objectName, objectName2, objectArray, stringArray);
    }

    private Object getAttribute(ObjectName objectName, String string) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        if (this.logger.finerOn()) {
            this.logger.finer("getAttribute", "getAttribute");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        return this.mbs.getAttribute(objectName, string);
    }

    private AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException {
        if (this.logger.finerOn()) {
            this.logger.finer("getAttributes", "getAttributes");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        return this.mbs.getAttributes(objectName, stringArray);
    }

    private String getDefaultDomain() {
        if (this.logger.finerOn()) {
            this.logger.finer("getDefaultDomain", "getDefaultDomain");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        return this.mbs.getDefaultDomain();
    }

    private boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException {
        if (this.logger.finerOn()) {
            this.logger.finer("isInstanceOf", "isInstanceOf");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        return this.mbs.isInstanceOf(objectName, string);
    }

    private ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        if (this.logger.finerOn()) {
            this.logger.finer("getObjectInstance", "getObjectInstance");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        return this.mbs.getObjectInstance(objectName);
    }

    private Integer getMBeanCount() {
        if (this.logger.finerOn()) {
            this.logger.finer("getMBeanCount", "getMBeanCount");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        return this.mbs.getMBeanCount();
    }

    private MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        if (this.logger.finerOn()) {
            this.logger.finer("getMBeanInfo", "getMBeanInfo");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        return this.mbs.getMBeanInfo(objectName);
    }

    private String getMBeanServerId() {
        if (this.logger.finerOn()) {
            this.logger.finer("getMBeanServerId", "getMBeanServerId");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        try {
            return (String)this.mbs.getAttribute(new ObjectName("JMImplementation:type=MBeanServerDelegate"), "MBeanServerId");
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException {
        if (this.logger.finerOn()) {
            this.logger.finer("invoke", "invoke");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        return this.mbs.invoke(objectName, string, objectArray, stringArray);
    }

    private boolean isRegistered(ObjectName objectName) {
        if (this.logger.finerOn()) {
            this.logger.finer("isRegistered", "isRegistered");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        return this.mbs.isRegistered(objectName);
    }

    private Set queryNames(ObjectName objectName, QueryExp queryExp) {
        if (this.logger.finerOn()) {
            this.logger.finer("queryNames", "queryNames");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        return this.mbs.queryNames(objectName, queryExp);
    }

    private Set queryMBeans(ObjectName objectName, QueryExp queryExp) {
        if (this.logger.finerOn()) {
            this.logger.finer("queryMBeans", "queryMBeans");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        return this.mbs.queryMBeans(objectName, queryExp);
    }

    private void setAttribute(ObjectName objectName, Attribute attribute) throws AttributeNotFoundException, InstanceNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (this.logger.finerOn()) {
            this.logger.finer("setAttribute", "setAttribute");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        this.mbs.setAttribute(objectName, attribute);
    }

    private AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        if (this.logger.finerOn()) {
            this.logger.finer("setAttributes", "setAttributes");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        return this.mbs.setAttributes(objectName, attributeList);
    }

    private void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        if (this.logger.finerOn()) {
            this.logger.finer("unregisterMBean", "unregisterMBean");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        this.mbs.unregisterMBean(objectName);
    }

    private Object[] remoteRequest(int n, Object[] objectArray) throws Exception {
        if (this.logger.finerOn()) {
            this.logger.finer("remoteRequest", "remoteRequest");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        GenericHttpConnectorServer genericHttpConnectorServer = (GenericHttpConnectorServer)this.adaptorServer;
        return genericHttpConnectorServer.serverNotificationDispatcher.remoteRequest(n, objectArray);
    }

    private String pingHeartBeatServer(String string, int n, int n2, Long l) {
        if (this.logger.finerOn()) {
            this.logger.finer("pingHeartBeatServer", "pingHeartBeatServer");
        }
        if (!this.adaptorServer.isActive()) {
            throw new CommunicationException("Connector Server is OFFLINE");
        }
        GenericHttpConnectorServer genericHttpConnectorServer = (GenericHttpConnectorServer)this.adaptorServer;
        return genericHttpConnectorServer.heartbeatServerHandler.pingHeartBeatServer(string, n, n2, l);
    }

    private boolean supports(String string) {
        if (this.logger.finerOn()) {
            this.logger.finer("supports", string);
        }
        for (int i = 0; i < supportedFeatures.length; ++i) {
            if (!supportedFeatures[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    protected String makeDebugTag() {
        return "GenericHttpRequestHandler[" + this.adaptorServer.getProtocol() + ":" + this.adaptorServer.getPort() + "][" + this.requestId + "]";
    }

    static {
        for (int i = 0; i < methodList.length; ++i) {
            String string = methodList[i];
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            ParsedMethod parsedMethod = new ParsedMethod();
            String string2 = stringTokenizer.nextToken();
            parsedMethod.methodNumber = i;
            parsedMethod.nParams = Integer.parseInt(stringTokenizer.nextToken());
            parsedMethod.resultType = stringTokenizer.nextToken();
            parsedMethod.magicParam = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : -1;
            if (stringTokenizer.hasMoreTokens()) {
                throw new Error("invalid methodList entry: " + string);
            }
            methodTable.put(string2, parsedMethod);
        }
    }

    private static final class ParsedMethod {
        int methodNumber;
        int nParams;
        String resultType;
        int magicParam;

        private ParsedMethod() {
        }
    }
}

