/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.remote.cascading;

import com.sun.jdmk.defaults.Utils;
import com.sun.jdmk.remote.cascading.CascadingAgentMBean;
import com.sun.jdmk.remote.cascading.MBeanServerConnectionFactory;
import java.io.IOException;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.QueryExp;

public abstract class CascadingAgent
implements MBeanRegistration,
NotificationEmitter,
CascadingAgentMBean {
    public static final ObjectName MBSDelegateObjectName;
    private static final String[] jmxConnectionNotificationTypes;
    private static final MBeanNotificationInfo jmxConnectionNotificationInfo;
    private final MBeanServerConnectionFactory connectionFactory;
    private final ObjectName sourcePattern;
    private final QueryExp sourceQuery;
    private final String targetPath;
    private final MBeanServer targetMBS;
    private final NotificationBroadcasterSupport emitter;
    private ConnectionListener connectionListener;
    private MBeanServer myMBS;
    static /* synthetic */ Class class$javax$management$remote$JMXConnectionNotification;

    protected CascadingAgent(MBeanServerConnectionFactory mBeanServerConnectionFactory, ObjectName objectName, QueryExp queryExp, String string, MBeanServer mBeanServer) {
        block4: {
            this.myMBS = null;
            if (string != null && string.length() != 0) {
                try {
                    if (ObjectName.getInstance(string + "/D:k=v").isPattern()) {
                        throw new IllegalArgumentException("targetPath `" + string + "' contains reserved " + "`*' or `?' " + "characters");
                    }
                    break block4;
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException("targetPath `" + string + "' is not valid");
                    throw (IllegalArgumentException)Utils.initCause(illegalArgumentException, malformedObjectNameException);
                }
            }
            string = null;
        }
        this.connectionFactory = mBeanServerConnectionFactory;
        this.emitter = new NotificationBroadcasterSupport(){

            protected void handleNotification(NotificationListener notificationListener, Notification notification, Object object) {
                CascadingAgent.this.handleNotification(notificationListener, notification, object);
            }
        };
        this.sourcePattern = objectName;
        this.sourceQuery = queryExp;
        this.targetPath = string;
        this.targetMBS = mBeanServer;
    }

    protected synchronized void enableConnectionNotifications() throws IOException {
        ConnectionListener connectionListener = new ConnectionListener();
        this.connectionFactory.addConnectionNotificationListener(connectionListener, null, null);
        this.connectionListener = connectionListener;
        this.connectionListener.enable();
    }

    protected synchronized void disableConnectionNotifications() throws IOException {
        try {
            ConnectionListener connectionListener = this.connectionListener;
            if (connectionListener == null) {
                return;
            }
            this.connectionListener = null;
            connectionListener.disable();
            this.connectionFactory.removeConnectionNotificationListener(connectionListener, null, null);
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
            // empty catch block
        }
    }

    public final String getTargetPath() {
        return this.targetPath;
    }

    public int getCascadedMBeanCount() {
        return this.getCascadedMBeans().size();
    }

    public abstract Set getCascadedMBeans();

    public abstract void start() throws IOException;

    public abstract void start(boolean var1) throws IOException, InstanceAlreadyExistsException;

    public abstract void stop() throws IOException;

    public abstract boolean isActive();

    public abstract String getDescription();

    protected abstract void handleJMXConnectionNotification(Notification var1, Object var2);

    public final ObjectName getPattern() {
        return this.sourcePattern;
    }

    public final QueryExp getQuery() {
        return this.sourceQuery;
    }

    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        this.emitter.addNotificationListener(notificationListener, notificationFilter, object);
    }

    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(notificationListener);
    }

    public void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(notificationListener, notificationFilter, object);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[]{jmxConnectionNotificationInfo};
        return mBeanNotificationInfoArray;
    }

    protected void sendNotification(Notification notification) {
        this.emitter.sendNotification(notification);
    }

    protected void handleNotification(NotificationListener notificationListener, Notification notification, Object object) {
        notificationListener.handleNotification(notification, object);
    }

    public final MBeanServer getTargetMBeanServer() {
        return this.targetMBS != null ? this.targetMBS : this.myMBS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        if (objectName == null) {
            throw new IllegalArgumentException("Illegal ObjectName: null");
        }
        CascadingAgent cascadingAgent = this;
        synchronized (cascadingAgent) {
            if (this.targetMBS == null && this.myMBS != null && this.myMBS != mBeanServer) {
                throw new IllegalArgumentException("Already registered");
            }
            this.myMBS = mBeanServer;
        }
        return objectName;
    }

    public void postRegister(Boolean bl) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
        this.myMBS = null;
    }

    public final MBeanServerConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            MBSDelegateObjectName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new UnsupportedOperationException(malformedObjectNameException.getMessage());
        }
        jmxConnectionNotificationTypes = new String[]{"jmx.remote.connection.opened", "jmx.remote.connection.closed", "jmx.remote.connection.failed", "jmx.remote.connection.notifs.lost"};
        jmxConnectionNotificationInfo = new MBeanNotificationInfo(jmxConnectionNotificationTypes, (class$javax$management$remote$JMXConnectionNotification == null ? (class$javax$management$remote$JMXConnectionNotification = CascadingAgent.class$("javax.management.remote.JMXConnectionNotification")) : class$javax$management$remote$JMXConnectionNotification).getName(), "Notifications relating to the underlying JMX Remote Connection.");
    }

    private class ConnectionListener
    implements NotificationListener {
        private boolean enabled = false;

        private ConnectionListener() {
        }

        public void handleNotification(Notification notification, Object object) {
            if (this.enabled()) {
                CascadingAgent.this.handleJMXConnectionNotification(notification, object);
            }
        }

        public synchronized void enable() {
            this.enabled = true;
        }

        public synchronized void disable() {
            this.enabled = false;
        }

        public synchronized boolean enabled() {
            return this.enabled;
        }
    }
}

