/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.comm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.comm.SendQ;
import com.sun.management.comm.SnmpInformRequest;
import com.sun.management.comm.SnmpSendServer;
import com.sun.management.comm.SnmpTimerServer;
import com.sun.management.comm.WaitQ;
import java.io.Serializable;
import java.util.Vector;

final class SnmpQManager
implements Serializable {
    private static final long serialVersionUID = 584008261374310862L;
    private SendQ newq = new SendQ(20, 5);
    private WaitQ waitq = new WaitQ(20, 5);
    private ThreadGroup queueThreadGroup = new ThreadGroup("Qmanager Thread Group");
    private Thread requestQThread = null;
    private Thread timerQThread = null;
    static String dbgTag = "SnmpQManager";
    static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.adaptor", "SnmpQManager");

    SnmpQManager() {
        this.startQThreads();
    }

    public void startQThreads() {
        if (this.timerQThread == null || !this.timerQThread.isAlive()) {
            this.timerQThread = new SnmpTimerServer(this.queueThreadGroup, this);
        }
        if (this.requestQThread == null || !this.requestQThread.isAlive()) {
            this.requestQThread = new SnmpSendServer(this.queueThreadGroup, this);
        }
    }

    public void stopQThreads() {
        ((SnmpTimerServer)this.timerQThread).isBeingDestroyed = true;
        this.waitq.isBeingDestroyed = true;
        ((SnmpSendServer)this.requestQThread).isBeingDestroyed = true;
        this.newq.isBeingDestroyed = true;
        if (this.timerQThread != null && this.timerQThread.isAlive()) {
            ((SnmpTimerServer)this.timerQThread).stopTimerServer();
        }
        this.waitq = null;
        this.timerQThread = null;
        if (this.requestQThread != null && this.requestQThread.isAlive()) {
            ((SnmpSendServer)this.requestQThread).stopSendServer();
        }
        this.newq = null;
        this.requestQThread = null;
    }

    public void addRequest(SnmpInformRequest snmpInformRequest) {
        this.newq.addRequest(snmpInformRequest);
    }

    public void addWaiting(SnmpInformRequest snmpInformRequest) {
        this.waitq.addWaiting(snmpInformRequest);
    }

    public Vector getAllOutstandingRequest(long l) {
        return this.newq.getAllOutstandingRequest(l);
    }

    public SnmpInformRequest getTimeoutRequests() {
        return this.waitq.getTimeoutRequests();
    }

    public void removeRequest(SnmpInformRequest snmpInformRequest) {
        this.newq.removeElement(snmpInformRequest);
        this.waitq.removeElement(snmpInformRequest);
    }

    public SnmpInformRequest removeRequest(long l) {
        SnmpInformRequest snmpInformRequest = null;
        snmpInformRequest = this.newq.removeRequest(l);
        if (snmpInformRequest == null) {
            snmpInformRequest = this.waitq.removeRequest(l);
        }
        return snmpInformRequest;
    }
}

