/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.IPAcl;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.IPAcl.PrincipalImpl;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Vector;

class NetMaskImpl
extends PrincipalImpl
implements Group,
Serializable {
    private static final long serialVersionUID = 7409889974102413924L;
    protected byte[] subnet = null;
    protected int prefix = -1;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "NetMaskImpl");
    String dbgTag = "NetMaskImpl";

    public NetMaskImpl() throws UnknownHostException {
    }

    private byte[] extractSubNet(byte[] byArray) {
        int n;
        int n2;
        int n3;
        int n4 = byArray.length;
        byte[] byArray2 = null;
        if (logger.finestOn()) {
            logger.finest("extractSubNet", "BINARY ARRAY :");
            StringBuffer stringBuffer = new StringBuffer();
            for (n3 = 0; n3 < n4; ++n3) {
                stringBuffer.append((byArray[n3] & 0xFF) + ":");
            }
            logger.finest("extractSubNet", stringBuffer.toString());
        }
        if ((n2 = this.prefix / 8) == n4) {
            if (logger.finestOn()) {
                logger.finest("extractSubNet", " The mask is the complete address, strange..." + n4);
            }
            byArray2 = byArray;
            return byArray2;
        }
        if (n2 > n4) {
            if (logger.finestOn()) {
                logger.finest("extractSubNet", " The number of covered byte is longer than the address. BUG");
            }
            throw new IllegalArgumentException("The number of covered byte is longer than the address.");
        }
        n3 = n2;
        if (logger.finestOn()) {
            logger.finest("extractSubNet", " Partialy covered index : " + n3);
        }
        byte by = byArray[n3];
        if (logger.finestOn()) {
            logger.finest("extractSubNet", " Partialy covered byte : " + by);
        }
        int n5 = this.prefix % 8;
        int n6 = 0;
        n6 = n5 == 0 ? n3 : n3 + 1;
        if (logger.finestOn()) {
            logger.finest("extractSubNet", " Remains : " + n5);
        }
        byte by2 = 0;
        for (n = 0; n < n5; ++n) {
            by2 = (byte)(by2 | 1 << 7 - n);
        }
        if (logger.finestOn()) {
            logger.finest("extractSubNet", "Mask value" + (by2 & 0xFF));
        }
        n = (byte)(by & by2);
        if (logger.finestOn()) {
            logger.finest("extractSubNet", "Masked byte :" + (n & 0xFF));
        }
        byArray2 = new byte[n6];
        if (logger.finestOn()) {
            logger.finest("extractSubNet", "Resulting subnet : ");
        }
        for (int i = 0; i < n3; ++i) {
            byArray2[i] = byArray[i];
            if (!logger.finestOn()) continue;
            logger.finest("extractSubNet", (byArray2[i] & 0xFF) + ":");
        }
        if (n5 != 0) {
            byArray2[n3] = n;
            if (logger.finestOn()) {
                logger.finest("extractSubNet", " Last subnet byte : " + (byArray2[n3] & 0xFF));
            }
        }
        return byArray2;
    }

    public NetMaskImpl(String string, int n) throws UnknownHostException {
        super(string);
        this.prefix = n;
        this.subnet = this.extractSubNet(this.getAddress().getAddress());
    }

    public boolean addMember(Principal principal) {
        return true;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof PrincipalImpl || object instanceof NetMaskImpl) {
            PrincipalImpl principalImpl = (PrincipalImpl)object;
            InetAddress inetAddress = principalImpl.getAddress();
            if (logger.finestOn()) {
                logger.finest("equals", "Received Address : " + inetAddress);
            }
            byte[] byArray = inetAddress.getAddress();
            for (int i = 0; i < this.subnet.length; ++i) {
                if (logger.finestOn()) {
                    logger.finest("equals", "(recAddr[i]) :" + (byArray[i] & 0xFF));
                    logger.finest("equals", "(recAddr[i] & subnet[i]) :" + (byArray[i] & this.subnet[i] & 0xFF) + "subnet[i] :" + (this.subnet[i] & 0xFF));
                }
                if ((byArray[i] & this.subnet[i]) == this.subnet[i]) continue;
                if (logger.finestOn()) {
                    logger.finest("equals", "FALSE");
                }
                return false;
            }
            if (logger.finestOn()) {
                logger.finest("equals", "TRUE");
            }
            return true;
        }
        return false;
    }

    public boolean isMember(Principal principal) {
        return (((Object)principal).hashCode() & super.hashCode()) == ((Object)principal).hashCode();
    }

    public Enumeration members() {
        Vector<NetMaskImpl> vector = new Vector<NetMaskImpl>(1);
        vector.addElement(this);
        return vector.elements();
    }

    public boolean removeMember(Principal principal) {
        return true;
    }

    public String toString() {
        return "NetMaskImpl :" + super.getAddress().toString() + "/" + this.prefix;
    }
}

