/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.custom;

import com.sun.encoder.Encoder;
import com.sun.encoder.EncoderConfigurationException;
import com.sun.encoder.EncoderException;
import com.sun.encoder.EncoderProperties;
import com.sun.encoder.EncoderType;
import com.sun.encoder.MetaRef;
import com.sun.encoder.custom.runtime.provider.BudOutput;
import com.sun.encoder.custom.runtime.provider.Nodes;
import com.sun.encoder.custom.runtime.provider.NodesFactory;
import com.sun.encoder.custom.runtime.provider.OtdDelim;
import com.sun.encoder.custom.runtime.provider.Parse;
import com.sun.encoder.runtime.CoderFactory;
import com.sun.encoder.runtime.OtdInputStream;
import com.sun.encoder.runtime.TransCoder;
import com.sun.encoder.runtime.provider.StringOtdInputStreamImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

class CustomEncoder
implements Encoder {
    private final EncoderType mType;
    private final EncoderProperties mProperties;
    private Transformer mTransformer;
    private Nodes mNodes;

    CustomEncoder(EncoderType type, EncoderProperties properties) {
        this.mType = type;
        this.mProperties = properties.immutable() ? properties : properties.cloneImmutable();
    }

    public Source decodeFromString(String input) throws EncoderException {
        return this.decodeFromString(input, null);
    }

    public String encodeToString(Source input) throws EncoderException {
        return this.encodeToString(input, null);
    }

    public Source decodeFromBytes(byte[] input) throws EncoderException {
        return this.decodeFromBytes(input, null);
    }

    public byte[] encodeToBytes(Source input) throws EncoderException {
        return this.encodeToBytes(input, null);
    }

    public boolean dispose() {
        return true;
    }

    public void setMeta(MetaRef xsd) throws EncoderConfigurationException {
        this.mNodes = xsd.getURL() != null ? NodesFactory.loadFromXSD(xsd.getURL(), xsd.getRootElemName()) : NodesFactory.loadFromXSD(new File(xsd.getPath()), xsd.getRootElemName());
        try {
            this.mTransformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new EncoderConfigurationException((Throwable)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new EncoderConfigurationException((Throwable)e);
        }
    }

    public void setMeta(SchemaGlobalElement rootElement) throws EncoderConfigurationException {
        this.mNodes = NodesFactory.loadFromXSD(rootElement);
        try {
            this.mTransformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new EncoderConfigurationException((Throwable)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new EncoderConfigurationException((Throwable)e);
        }
    }

    public Source decodeFromBytes(byte[] input, EncoderProperties properties) throws EncoderException {
        byte[] bytes;
        String coding;
        String string = coding = properties != null ? properties.getPreDecodeCharCoding() : null;
        if (coding == null) {
            coding = this.mProperties.getPreDecodeCharCoding();
        }
        if (coding == null) {
            bytes = this.mNodes.getAntecoder().recode(input, false);
        } else {
            if (!CoderFactory.hasCoder((String)coding)) {
                throw new EncoderException((Throwable)new UnsupportedEncodingException(coding));
            }
            bytes = CoderFactory.getTrans((String)this.mNodes.getAnteCoding(), (String)coding).recode(input, false);
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(bytes);
        InputSource inputSource = new InputSource(inStream);
        inputSource.setPublicId("byte array data");
        UnmarshalAdaptor adaptor = new UnmarshalAdaptor();
        return new SAXSource(adaptor, inputSource);
    }

    public Source decodeFromReader(Reader input) throws EncoderException {
        return this.decodeFromReader(input, null);
    }

    public Source decodeFromReader(Reader input, EncoderProperties properties) throws EncoderException {
        byte[] bytes;
        try {
            String coding;
            String string = coding = properties != null ? properties.getPreDecodeCharCoding() : null;
            if (coding == null) {
                coding = this.mProperties.getPreDecodeCharCoding();
            }
            if (coding == null) {
                bytes = this.mNodes.getPreDecodeCharCoder().encode(this.readString(input, false));
            } else {
                if (!CoderFactory.hasCoder((String)coding)) {
                    throw new EncoderException((Throwable)new UnsupportedEncodingException(coding));
                }
                bytes = CoderFactory.getCoder((String)coding).encode(this.readString(input, false));
            }
        }
        catch (IOException e) {
            throw new EncoderException((Throwable)e);
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(bytes);
        InputSource inputSource = new InputSource(inStream);
        inputSource.setPublicId("character sequence data");
        UnmarshalAdaptor adaptor = new UnmarshalAdaptor();
        return new SAXSource(adaptor, inputSource);
    }

    public Source decodeFromStream(InputStream input) throws EncoderException {
        return this.decodeFromStream(input, null);
    }

    public Source decodeFromStream(InputStream input, EncoderProperties properties) throws EncoderException {
        try {
            return this.decodeFromBytes(this.readBytes(input, false), properties);
        }
        catch (IOException e) {
            throw new EncoderException((Throwable)e);
        }
    }

    public Source decodeFromString(String input, EncoderProperties properties) throws EncoderException {
        byte[] bytes;
        String coding;
        String string = coding = properties != null ? properties.getPreDecodeCharCoding() : null;
        if (coding == null) {
            coding = this.mProperties.getPreDecodeCharCoding();
        }
        if (coding == null) {
            bytes = this.mNodes.getPreDecodeCharCoder().encode(input);
        } else {
            if (!CoderFactory.hasCoder((String)coding)) {
                throw new EncoderException((Throwable)new UnsupportedEncodingException(coding));
            }
            bytes = CoderFactory.getCoder((String)coding).encode(input);
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(bytes);
        InputSource inputSource = new InputSource(inStream);
        inputSource.setPublicId("character sequence data");
        UnmarshalAdaptor adaptor = new UnmarshalAdaptor();
        return new SAXSource(adaptor, inputSource);
    }

    public byte[] encodeToBytes(Source input, EncoderProperties properties) throws EncoderException {
        BudOutput budOut = new BudOutput(this.mNodes, this.mNodes.getDelim());
        try {
            String coding;
            this.mTransformer.transform(input, new SAXResult(budOut));
            String string = coding = properties != null ? properties.getPostEncodeCharCoding() : null;
            if (coding == null) {
                coding = this.mProperties.getPostEncodeCharCoding();
            }
            TransCoder postCoder = coding == null ? this.mNodes.getPostcoder() : CoderFactory.getTrans((String)coding, (String)this.mNodes.getPostCoding());
            return postCoder.recode(budOut.content(), false);
        }
        catch (TransformerException e) {
            throw new EncoderException((Throwable)e);
        }
    }

    public void encodeToStream(Source input, OutputStream out) throws EncoderException {
        this.encodeToStream(input, out, null);
    }

    public void encodeToStream(Source input, OutputStream out, EncoderProperties properties) throws EncoderException {
        try {
            out.write(this.encodeToBytes(input, properties));
            out.flush();
        }
        catch (IOException e) {
            throw new EncoderException((Throwable)e);
        }
    }

    public String encodeToString(Source input, EncoderProperties properties) throws EncoderException {
        BudOutput budOut = new BudOutput(this.mNodes, this.mNodes.getDelim());
        try {
            String coding;
            this.mTransformer.transform(input, new SAXResult(budOut));
            String string = coding = properties != null ? properties.getPostEncodeCharCoding() : null;
            if (coding == null) {
                coding = this.mProperties.getPostEncodeCharCoding();
            }
            if (coding == null) {
                return this.mNodes.getPostEncodeCharCoder().decode(budOut.content());
            }
            if (!CoderFactory.hasCoder((String)coding)) {
                throw new EncoderException((Throwable)new UnsupportedEncodingException(coding));
            }
            return CoderFactory.getCoder((String)coding).decode(budOut.content());
        }
        catch (TransformerException e) {
            throw new EncoderException((Throwable)e);
        }
    }

    public void encodeToWriter(Source input, Writer out) throws EncoderException {
        this.encodeToWriter(input, out, null);
    }

    public void encodeToWriter(Source input, Writer out, EncoderProperties properties) throws EncoderException {
        try {
            out.write(this.encodeToString(input, properties));
            out.flush();
        }
        catch (IOException e) {
            throw new EncoderException((Throwable)e);
        }
    }

    public EncoderProperties getProperties() {
        return this.mProperties;
    }

    public EncoderType getType() {
        return this.mType;
    }

    private String readString(Reader reader, boolean close) throws IOException {
        int read;
        StringBuilder sb = new StringBuilder();
        char[] buf = new char[1024];
        while ((read = reader.read(buf)) != -1) {
            sb.append(buf, 0, read);
        }
        if (close) {
            reader.close();
        }
        return sb.toString();
    }

    private byte[] readBytes(InputStream inStream, boolean close) throws IOException {
        int read;
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((read = inStream.read(buf)) != -1) {
            outStream.write(buf, 0, read);
        }
        if (close) {
            inStream.close();
        }
        return outStream.toByteArray();
    }

    public class UnmarshalAdaptor
    implements XMLReader {
        private EntityResolver mEntityResolver;
        private DTDHandler mDTDHandler;
        private ContentHandler mContentHandler;
        private ErrorHandler mErrorHandler;

        public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            if ("http://xml.org/sax/features/namespaces".equals(name)) {
                return true;
            }
            if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
                return false;
            }
            throw new SAXNotRecognizedException();
        }

        public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
            if ("http://xml.org/sax/features/namespaces".equals(name)) {
                if (!value) {
                    throw new SAXNotSupportedException("Feature '" + name + "' with value " + value + " is not supported.");
                }
                return;
            }
            if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
                if (value) {
                    throw new SAXNotSupportedException("Feature '" + name + "' with value " + value + " is not supported.");
                }
                return;
            }
            throw new SAXNotRecognizedException();
        }

        public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            return null;
        }

        public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        }

        public void setEntityResolver(EntityResolver resolver) {
            this.mEntityResolver = resolver;
        }

        public EntityResolver getEntityResolver() {
            return this.mEntityResolver;
        }

        public void setDTDHandler(DTDHandler handler) {
            this.mDTDHandler = handler;
        }

        public DTDHandler getDTDHandler() {
            return this.mDTDHandler;
        }

        public void setContentHandler(ContentHandler handler) {
            this.mContentHandler = handler;
        }

        public ContentHandler getContentHandler() {
            return this.mContentHandler;
        }

        public void setErrorHandler(ErrorHandler handler) {
            this.mErrorHandler = handler;
        }

        public ErrorHandler getErrorHandler() {
            return this.mErrorHandler;
        }

        public void parse(InputSource input) throws IOException, SAXException {
            OtdDelim.OtdDelimInst inst = new OtdDelim.OtdDelimInst(CustomEncoder.this.mNodes.getDelim());
            Parse parse = new Parse(inst, CustomEncoder.this.mNodes);
            StringOtdInputStreamImpl in = new StringOtdInputStreamImpl(CustomEncoder.this.readBytes(input.getByteStream(), false));
            parse.parse(CustomEncoder.this.mNodes.getRoot(), this.mContentHandler, CustomEncoder.this.mNodes.getDecoder(), (OtdInputStream)in);
        }

        public void parse(String systemId) throws IOException, SAXException {
            this.parse(new InputSource(systemId));
        }
    }
}

