/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.ant.taskdefs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.Iterator;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpURL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.util.LineTokenizer;
import org.apache.webdav.ant.CollectionScanner;
import org.apache.webdav.ant.Utils;
import org.apache.webdav.ant.WebdavFileSet;
import org.apache.webdav.ant.taskdefs.WebdavMatchingTask;

public class Get
extends WebdavMatchingTask {
    private File toDir = null;
    private File toFile = null;
    private boolean overwrite = false;
    private String encoding = null;
    private FilterSetCollection filterSets = new FilterSetCollection();
    private int countWrittenFiles = 0;
    private int countOmittedFiles = 0;

    public void execute() throws BuildException {
        this.validate();
        try {
            if (this.toFile != null) {
                this.downloadSingleFile();
            } else {
                this.log("Downloading from: " + this.getUrl(), this.ifVerbose());
                if (!this.getUrl().getPath().endsWith("/")) {
                    this.getUrl().setPath(this.getUrl().getPath() + "/");
                }
                Iterator i = this.getFileSets();
                while (i.hasNext()) {
                    this.downloadFileset((WebdavFileSet)i.next());
                }
            }
            if (this.countWrittenFiles > 0) {
                this.log("Downloaded " + this.countWrittenFiles + (this.countWrittenFiles == 1 ? " resource" : " resources") + " from " + this.getUrl(), this.countWrittenFiles > 0 ? 2 : this.ifVerbose());
            }
        }
        catch (IOException e) {
            throw Utils.makeBuildException("Error while downloading!", e);
        }
    }

    protected void validate() {
        super.validate();
        if (this.toDir == null && this.toFile == null) {
            throw new BuildException("Missing one of the required attributes toDir or toFile.");
        }
        if (this.toDir != null && this.toFile != null) {
            throw new BuildException("Only one of the attributes toDir and toFile is alowed.");
        }
        if (this.toFile != null && this.getFileSets().hasNext()) {
            throw new BuildException("Not filesets allowed if toFile is set.");
        }
        if (this.encoding == null && this.filterSets.hasFilters()) {
            this.log("If filterSets are used a file encoding should be specified!", 1);
            this.encoding = "ISO-8859-1";
        }
    }

    protected void downloadFileset(WebdavFileSet fileSet) throws IOException {
        CollectionScanner scanner = fileSet.getCollectionScanner(this.getProject(), this.getHttpClient(), this.getUrl());
        HttpURL baseUrl = scanner.getBaseURL();
        String[] files = scanner.getIncludedFiles();
        for (int i = 0; i < files.length; ++i) {
            HttpURL url = Utils.createHttpURL(baseUrl, files[i]);
            this.downloadFile(url, files[i], scanner);
        }
    }

    protected void downloadSingleFile() throws IOException {
        long lastMod = Utils.getLastModified(this.getHttpClient(), this.getUrl());
        if (this.shallWeGetIt(this.toFile, lastMod)) {
            this.getAndStoreResource(this.getUrl(), this.toFile, lastMod, this.getUrl().getURI());
        } else {
            this.log("Omitted: " + this.getUrl() + " (uptodate)", this.ifVerbose());
            ++this.countOmittedFiles;
        }
    }

    protected void downloadFile(HttpURL url, String relativePath, CollectionScanner scanner) throws IOException {
        File target = new File(this.toDir, relativePath);
        long lastMod = scanner.getProperties().getLastModified(url.toString());
        if (this.shallWeGetIt(target, lastMod)) {
            this.getAndStoreResource(url, target, lastMod, relativePath);
        } else {
            this.log("Omitted: " + relativePath + " (uptodate)", this.ifVerbose());
            ++this.countOmittedFiles;
        }
    }

    private boolean shallWeGetIt(File target, long lastMod) {
        boolean getit;
        boolean bl = getit = this.overwrite || !target.exists();
        if (!this.overwrite && target.exists() && lastMod > target.lastModified()) {
            getit = true;
        }
        return getit;
    }

    private void getAndStoreResource(HttpURL url, File target, long lastMod, String relative) throws IOException, HttpException, FileNotFoundException {
        this.log("downloading: " + relative, this.ifVerbose());
        File directory = target.getParentFile();
        if (!directory.exists()) {
            directory.mkdirs();
        }
        InputStream in = Utils.getFile(this.getHttpClient(), url);
        if (!target.exists()) {
            target.createNewFile();
        }
        FileOutputStream out = new FileOutputStream(target);
        Get.copyStream(in, out, this.filterSets, this.encoding);
        out.close();
        target.setLastModified(lastMod);
        ++this.countWrittenFiles;
    }

    protected static void copyStream(InputStream in, OutputStream out, FilterSetCollection filterSets, String encoding) throws IOException {
        byte[] b = new byte[1024];
        if (filterSets.hasFilters()) {
            InputStreamReader reader = new InputStreamReader(in, encoding);
            OutputStreamWriter writer = new OutputStreamWriter(out, encoding);
            LineTokenizer tok = new LineTokenizer();
            tok.setIncludeDelims(true);
            String l = tok.getToken((Reader)reader);
            while (l != null) {
                writer.write(filterSets.replaceTokens(l));
                l = tok.getToken((Reader)reader);
            }
            writer.close();
            reader.close();
        } else {
            while (in.available() > 0) {
                int cnt = in.read(b, 0, b.length);
                if (cnt <= -1) continue;
                out.write(b, 0, cnt);
            }
        }
    }

    public void setTodir(File directory) {
        this.toDir = directory;
        if (this.toDir.isFile()) {
            throw new BuildException("toDir must not point to a file!");
        }
    }

    public void setTofile(File file) {
        this.toFile = file;
        if (this.toFile.isDirectory()) {
            throw new BuildException("toFile must not point to a directory!");
        }
    }

    public FilterSet createFilterSet() {
        FilterSet filterSet = new FilterSet();
        this.filterSets.addFilterSet(filterSet);
        return filterSet;
    }

    public void setEncoding(String enc) {
        this.encoding = enc;
    }

    public void setOverwrite(boolean b) {
        this.overwrite = b;
    }
}

