/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.lcdui;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import org.netbeans.microedition.lcdui.AbstractInfoScreen;

public class SplashScreen
extends AbstractInfoScreen {
    public static final Command DISMISS_COMMAND = new Command("Dismiss", 4, 0);
    public static final int FOREVER = 0;
    private static final int DEFAULT_TIMEOUT = 5000;
    private int timeout = 5000;
    private boolean allowTimeoutInterrupt = true;
    private long currentDisplayTimestamp;

    public SplashScreen(Display display) throws IllegalArgumentException {
        super(display);
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setAllowTimeoutInterrupt(boolean allow) {
        this.allowTimeoutInterrupt = allow;
    }

    public boolean isAllowTimeoutInterrupt() {
        return this.allowTimeoutInterrupt;
    }

    protected void keyPressed(int keyCode) {
        if (this.allowTimeoutInterrupt) {
            this.doDismiss();
        }
    }

    protected void pointerPressed(int x, int y) {
        if (this.allowTimeoutInterrupt) {
            this.doDismiss();
        }
    }

    protected void showNotify() {
        super.showNotify();
        this.currentDisplayTimestamp = System.currentTimeMillis();
        if (this.timeout > 0) {
            Watchdog w = new Watchdog(this.timeout, this.currentDisplayTimestamp);
            w.start();
        }
    }

    protected void hideNotify() {
        super.hideNotify();
        this.currentDisplayTimestamp = System.currentTimeMillis();
    }

    private void doDismiss() {
        CommandListener commandListener = this.getCommandListener();
        if (commandListener == null) {
            this.switchToNextDisplayable();
        } else {
            commandListener.commandAction(DISMISS_COMMAND, (Displayable)this);
        }
    }

    private class Watchdog
    extends Thread {
        private int timeout;
        private long currentDisplayTimestamp;

        private Watchdog(int timeout, long currentDisplayTimestamp) {
            this.timeout = timeout;
            this.currentDisplayTimestamp = currentDisplayTimestamp;
        }

        public void run() {
            try {
                Thread.sleep(this.timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.currentDisplayTimestamp == SplashScreen.this.currentDisplayTimestamp) {
                SplashScreen.this.doDismiss();
            }
        }
    }
}

