/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import proguard.classfile.ClassFile;
import proguard.classfile.MethodInfo;
import proguard.classfile.attribute.AttrInfo;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.ExceptionInfoVisitor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.InstructionVisitor;

public class CodeAttrInfo
extends AttrInfo {
    private static final int CONSTANT_FIELD_SIZE = 12;
    public int u2maxStack;
    public int u2maxLocals;
    public int u4codeLength;
    public byte[] code;
    public int u2exceptionTableLength;
    public ExceptionInfo[] exceptionTable;
    public int u2attributesCount;
    public AttrInfo[] attributes;

    protected CodeAttrInfo() {
    }

    public AttrInfo getAttribute(ClassFile classFile, String string) {
        for (int i = 0; i < this.u2attributesCount; ++i) {
            AttrInfo attrInfo = this.attributes[i];
            if (!attrInfo.getAttributeName(classFile).equals(string)) continue;
            return attrInfo;
        }
        return null;
    }

    protected int getLength() {
        int n = 12 + this.u4codeLength + this.u2exceptionTableLength * 8;
        for (int i = 0; i < this.u2attributesCount; ++i) {
            n += 6 + this.attributes[i].getLength();
        }
        return n;
    }

    protected void readInfo(DataInput dataInput, ClassFile classFile) throws IOException {
        int n;
        this.u2maxStack = dataInput.readUnsignedShort();
        this.u2maxLocals = dataInput.readUnsignedShort();
        this.u4codeLength = dataInput.readInt();
        this.code = new byte[this.u4codeLength];
        dataInput.readFully(this.code);
        this.u2exceptionTableLength = dataInput.readUnsignedShort();
        this.exceptionTable = new ExceptionInfo[this.u2exceptionTableLength];
        for (n = 0; n < this.u2exceptionTableLength; ++n) {
            this.exceptionTable[n] = ExceptionInfo.create(dataInput);
        }
        this.u2attributesCount = dataInput.readUnsignedShort();
        this.attributes = new AttrInfo[this.u2attributesCount];
        for (n = 0; n < this.u2attributesCount; ++n) {
            this.attributes[n] = AttrInfo.create(dataInput, classFile);
        }
    }

    protected void writeInfo(DataOutput dataOutput) throws IOException {
        int n;
        dataOutput.writeShort(this.u2maxStack);
        dataOutput.writeShort(this.u2maxLocals);
        dataOutput.writeInt(this.u4codeLength);
        dataOutput.write(this.code, 0, this.u4codeLength);
        dataOutput.writeShort(this.u2exceptionTableLength);
        for (n = 0; n < this.u2exceptionTableLength; ++n) {
            this.exceptionTable[n].write(dataOutput);
        }
        dataOutput.writeShort(this.u2attributesCount);
        for (n = 0; n < this.u2attributesCount; ++n) {
            this.attributes[n].write(dataOutput);
        }
    }

    public void accept(ClassFile classFile, AttrInfoVisitor attrInfoVisitor) {
        attrInfoVisitor.visitCodeAttrInfo(classFile, null, this);
    }

    public void accept(ClassFile classFile, MethodInfo methodInfo, AttrInfoVisitor attrInfoVisitor) {
        attrInfoVisitor.visitCodeAttrInfo(classFile, methodInfo, this);
    }

    public void instructionsAccept(ClassFile classFile, MethodInfo methodInfo, InstructionVisitor instructionVisitor) {
        int n;
        int n2 = 0;
        do {
            Instruction instruction = InstructionFactory.create(this.code, n2);
            n = instruction.length(n2);
            instruction.accept(classFile, methodInfo, this, n2, instructionVisitor);
        } while ((n2 += n) < this.u4codeLength);
    }

    public void instructionAccept(ClassFile classFile, MethodInfo methodInfo, InstructionVisitor instructionVisitor, int n) {
        Instruction instruction = InstructionFactory.create(this.code, n);
        instruction.accept(classFile, methodInfo, this, n, instructionVisitor);
    }

    public void exceptionsAccept(ClassFile classFile, MethodInfo methodInfo, ExceptionInfoVisitor exceptionInfoVisitor) {
        for (int i = 0; i < this.u2exceptionTableLength; ++i) {
            exceptionInfoVisitor.visitExceptionInfo(classFile, methodInfo, this, this.exceptionTable[i]);
        }
    }

    public void attributesAccept(ClassFile classFile, MethodInfo methodInfo, AttrInfoVisitor attrInfoVisitor) {
        for (int i = 0; i < this.u2attributesCount; ++i) {
            this.attributes[i].accept(classFile, methodInfo, this, attrInfoVisitor);
        }
    }
}

