/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.annotation;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import proguard.classfile.ClassFile;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.ElementValueVisitor;

public class ArrayElementValue
extends ElementValue {
    protected static final int CONSTANT_FIELD_SIZE = 3;
    public int u2numberOfValues;
    public ElementValue[] values;

    protected ArrayElementValue() {
    }

    protected int getLength() {
        int n = 3;
        for (int i = 0; i < this.u2numberOfValues; ++i) {
            n += this.values[i].getLength();
        }
        return n;
    }

    protected void readInfo(DataInput dataInput) throws IOException {
        this.u2numberOfValues = dataInput.readUnsignedShort();
        this.values = new ElementValue[this.u2numberOfValues];
        for (int i = 0; i < this.u2numberOfValues; ++i) {
            this.values[i] = ElementValue.create(dataInput);
        }
    }

    protected void writeInfo(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.u2numberOfValues);
        for (int i = 0; i < this.u2numberOfValues; ++i) {
            this.values[i].write(dataOutput);
        }
    }

    public void accept(ClassFile classFile, Annotation annotation, ElementValueVisitor elementValueVisitor) {
        elementValueVisitor.visitArrayElementValue(classFile, annotation, this);
    }

    public void elementValuesAccept(ClassFile classFile, Annotation annotation, ElementValueVisitor elementValueVisitor) {
        for (int i = 0; i < this.u2numberOfValues; ++i) {
            this.values[i].accept(classFile, annotation, elementValueVisitor);
        }
    }
}

