/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.ClassFile;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.optimize.MethodOptimizationInfo;
import proguard.optimize.ParameterShrinker;

public class ParameterUsageMarker
implements MemberInfoVisitor {
    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        long l;
        if ((programMethodInfo.getAccessFlags() & 0x100) != 0) {
            l = this.parameterMask(programClassFile, programMethodInfo);
            if ((programMethodInfo.getAccessFlags() & 8) == 0) {
                l = 1L | l << 1;
            }
            this.markUsedVariables(programMethodInfo, l);
        }
        if (programClassFile.mayHaveImplementations(programMethodInfo)) {
            l = 1L;
            this.markUsedVariables(programMethodInfo, l);
        } else if (programMethodInfo.getName(programClassFile).equals("<init>")) {
            l = 1L;
            if (programClassFile.findMethod("<init>", ParameterShrinker.shrinkDescriptor(programClassFile, programMethodInfo)) != null) {
                l |= (long)(this.parameterMask(programClassFile, programMethodInfo) << 1);
            }
            this.markUsedVariables(programMethodInfo, l);
        }
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
        if (libraryClassFile.mayHaveImplementations(libraryMethodInfo)) {
            long l = 1L | (long)(this.parameterMask(libraryClassFile, libraryMethodInfo) << 1);
            this.markUsedVariables(libraryMethodInfo, l);
        }
    }

    private void markUsedVariables(MethodInfo methodInfo, long l) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(methodInfo);
        if (methodOptimizationInfo != null) {
            methodOptimizationInfo.setUsedVariables(methodOptimizationInfo.getUsedVariables() | l);
        }
    }

    public static long getUsedVariables(MethodInfo methodInfo) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(methodInfo);
        return methodOptimizationInfo != null ? methodOptimizationInfo.getUsedVariables() : -1L;
    }

    private int parameterMask(ClassFile classFile, MethodInfo methodInfo) {
        return (1 << ClassUtil.internalMethodParameterSize(methodInfo.getDescriptor(classFile))) - 1;
    }
}

