/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.webservice.generator.bcm;

import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import it.imolinfo.jbi4corba.webservice.generator.bcm.ByteCodeManipulationUtil;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;

public class WsdlToCorbaAdapter
extends ClassAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(WsdlToCorbaAdapter.class);
    protected String classesDirName = null;
    protected String className = null;
    protected ClassWriter classWriter = null;
    protected Map<String, String> mapOfFields = new HashMap<String, String>();
    private ByteCodeManipulationUtil bcmUtil = new ByteCodeManipulationUtil();

    public WsdlToCorbaAdapter(ClassVisitor cv, ClassWriter cw, String cn, String classes) {
        super(cv);
        this.classesDirName = classes;
        this.classWriter = cw;
        this.className = cn;
        LOG.debug("new WsdlToCorbaAdapter; ClassVisitor=" + cv + "; ClassWriter=" + cw + "; ClassName=" + cn);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        LOG.debug(">>>>> visit - begin");
        LOG.debug("VISIT.\n version=" + version + ";\n access=" + access + ";\n name=" + name + ";\n signature=" + signature + ";\n superName=" + superName + ";\n interfaces=" + interfaces + ".\n abstract-code=" + 1024 + ".\n (Opcodes.ACC_ABSTRACT & access)=" + (0x400 & access) + ".\n access & (~ Opcodes.ACC_ABSTRACT)=" + (access & 0xFFFFFBFF));
        LOG.debug("This class (" + name + ") was an abstract " + "... now is a concrete class.");
        LOG.debug("<<<<< visit - end");
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        LOG.debug(">>>>> visitField - begin:" + desc);
        LOG.debug("visitField. access=" + access + "; name=" + name + "; desc=" + desc + "; signature=" + signature + "; value=" + value);
        if (1 == access || 4 == access) {
            this.mapOfFields.put(name, desc);
        }
        LOG.debug("<<<<< visitField - end");
        return super.visitField(4, name, desc, signature, value);
    }

    public void visitEnd() {
        for (String name : this.mapOfFields.keySet()) {
            String desc = this.mapOfFields.get(name);
            this.bcmUtil.createSetter(this.classWriter, this.getClassNameWithoutClassesDir(), name, desc);
            this.bcmUtil.createGetter(this.classWriter, this.getClassNameWithoutClassesDir(), name, desc);
        }
        this.bcmUtil.createToString(this.classWriter);
        this.bcmUtil.createEquals(this.classWriter);
        super.visitEnd();
    }

    public String getClassNameWithoutClassesDir() {
        String c = this.className.substring(this.classesDirName.length() + 1, this.className.length());
        LOG.debug("###### getClassNameWithoutClassesDir=" + c);
        return c;
    }
}

