/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder;

import com.sun.encoder.ClassLoaderManager;
import com.sun.encoder.Encoder;
import com.sun.encoder.EncoderConfigurationException;
import com.sun.encoder.EncoderProperties;
import com.sun.encoder.EncoderProvider;
import com.sun.encoder.EncoderType;
import com.sun.encoder.MetaRef;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncoderFactory {
    private static final String PROVIDER_PREFIX = "META-INF/services/";
    private static final EncoderFactory mInstance = new EncoderFactory();
    private static final Set<EncoderType> mEncoderTypeSet = new HashSet<EncoderType>();
    private static final Map<String, EncoderType> mEncoderTypeMap = new HashMap<String, EncoderType>();
    private static final Map<String, EncoderProvider> mEncoderProviderMap = new HashMap<String, EncoderProvider>();

    private static <T> Iterator<T> getProviders(Class<T> clazz, ClassLoader loader) {
        BufferedReader in = null;
        try {
            Enumeration<URL> providers = loader.getResources(PROVIDER_PREFIX + clazz.getName());
            ArrayList<T> list = new ArrayList<T>();
            while (providers.hasMoreElements()) {
                String s;
                URL url = providers.nextElement();
                in = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
                while ((s = in.readLine()) != null) {
                    if ((s = s.trim()).length() == 0 || s.charAt(0) == '#') continue;
                    list.add(Class.forName(s, true, loader).asSubclass(clazz).newInstance());
                }
            }
            Iterator iterator = list.iterator();
            return iterator;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load providers for '" + clazz.getName() + "'", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to load providers for '" + clazz.getName() + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to load providers for '" + clazz.getName() + "'", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load providers for '" + clazz.getName() + "'", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    private static void loadAllEncoderProviders(Map<String, EncoderProvider> providerMap) {
        ClassLoader loader;
        Iterator<ClassLoaderManager> iter = EncoderFactory.getProviders(ClassLoaderManager.class, EncoderFactory.class.getClassLoader());
        HashSet<ClassLoader> loaderSet = new HashSet<ClassLoader>();
        while (iter.hasNext()) {
            ClassLoaderManager loaderMgr = iter.next();
            loader = loaderMgr.getEncoderClassLoader();
            if (loaderSet.contains(loader)) continue;
            EncoderFactory.loadEncoderProviders(providerMap, loader);
            loaderSet.add(loader);
        }
        loader = EncoderFactory.class.getClassLoader();
        if (loader != null && !loaderSet.contains(loader)) {
            EncoderFactory.loadEncoderProviders(providerMap, loader);
            loaderSet.add(loader);
        }
        if ((loader = Thread.currentThread().getContextClassLoader()) != null && !loaderSet.contains(loader)) {
            EncoderFactory.loadEncoderProviders(providerMap, loader);
            loaderSet.add(loader);
        }
    }

    private static void loadEncoderProviders(Map<String, EncoderProvider> providerMap, ClassLoader loader) {
        Iterator<EncoderProvider> iter = EncoderFactory.getProviders(EncoderProvider.class, loader);
        while (iter.hasNext()) {
            String[] aliases;
            EncoderProvider provider = iter.next();
            if (!providerMap.containsKey(provider.getIdentification())) {
                providerMap.put(provider.getIdentification(), provider);
            }
            if ((aliases = provider.getAliases()) == null || aliases.length == 0) continue;
            for (int i = 0; i < aliases.length; ++i) {
                if (providerMap.containsKey(aliases[i])) continue;
                providerMap.put(aliases[i], provider);
            }
        }
    }

    private static void populateEncoderTypes(Map<String, EncoderType> typeMap, Set<EncoderType> typeSet, Map<String, EncoderProvider> providerMap) {
        HashMap<EncoderProvider, EncoderType> provider2TypeMap = new HashMap<EncoderProvider, EncoderType>();
        for (Map.Entry<String, EncoderProvider> entry : providerMap.entrySet()) {
            EncoderType ecType;
            if (!provider2TypeMap.containsKey(entry.getValue())) {
                ecType = new EncoderType(entry.getKey(), entry.getValue().getDataNature());
                entry.getValue().setType(ecType);
                typeSet.add(ecType);
                provider2TypeMap.put(entry.getValue(), ecType);
            } else {
                ecType = (EncoderType)provider2TypeMap.get(entry.getValue());
            }
            typeMap.put(entry.getKey(), ecType);
        }
    }

    private EncoderFactory() {
    }

    public static EncoderFactory newInstance() throws EncoderConfigurationException {
        return mInstance;
    }

    public Encoder newEncoder(EncoderType type, MetaRef xsd) throws EncoderConfigurationException {
        if (type == null) {
            throw new EncoderConfigurationException("no EncoderType");
        }
        if (xsd == null) {
            throw new EncoderConfigurationException("no xsd");
        }
        if (type.isBasic()) {
            return mEncoderProviderMap.get(type.getIdentification()).newEncoder(xsd, null);
        }
        return mEncoderProviderMap.get(type.getIdentification()).newEncoder(xsd, null, type.getEncoderProperties());
    }

    public Map newEncoders(EncoderType type, Set metaRefSet) throws EncoderConfigurationException {
        if (type == null) {
            throw new EncoderConfigurationException("no EncoderType.");
        }
        if (metaRefSet == null) {
            throw new EncoderConfigurationException("no MetaRef set.");
        }
        if (type.isBasic()) {
            return mEncoderProviderMap.get(type.getIdentification()).newEncoders(metaRefSet, null);
        }
        return mEncoderProviderMap.get(type.getIdentification()).newEncoders(metaRefSet, null, type.getEncoderProperties());
    }

    public MetaRef makeMeta(String path) {
        return new SimpleMetaRef(path);
    }

    public MetaRef makeMeta(String path, QName rootElemName) {
        return new SimpleMetaRef(path, rootElemName);
    }

    public MetaRef makeMeta(URL url, QName rootElemName) {
        return new SimpleMetaRef(url, rootElemName);
    }

    public Set allEncoderTypes() {
        return mEncoderTypeSet;
    }

    public EncoderType makeType(String encodingStyle) throws EncoderConfigurationException {
        EncoderProperties props;
        String idOrAlias = this.extractIdOrAlias(encodingStyle);
        if (!mEncoderTypeMap.containsKey(idOrAlias)) {
            throw new EncoderConfigurationException("No Encoder : <" + idOrAlias + "> in the installed Encoder SharedLibrary. Please install" + " a new Encoder SharedLibrary that contains it");
        }
        try {
            props = this.extractProperties(encodingStyle);
        }
        catch (UnsupportedEncodingException e) {
            throw new EncoderConfigurationException(e);
        }
        if (props == null || props.isEmpty()) {
            return mEncoderTypeMap.get(idOrAlias);
        }
        return new EncoderType(mEncoderTypeMap.get(idOrAlias), props);
    }

    public Encoder newEncoder(EncoderType type, MetaRef xsd, EncoderProperties properties) throws EncoderConfigurationException {
        EncoderProperties props;
        if (type == null) {
            throw new EncoderConfigurationException("no EncoderType");
        }
        if (xsd == null) {
            throw new EncoderConfigurationException("no xsd");
        }
        if (!type.isBasic()) {
            props = type.getEncoderProperties().cloneMutable();
            props.addAll(properties);
        } else {
            props = properties;
        }
        return mEncoderProviderMap.get(type.getIdentification()).newEncoder(xsd, null, props);
    }

    public Map newEncoders(EncoderType type, Set metaRefSet, EncoderProperties properties) throws EncoderConfigurationException {
        EncoderProperties props;
        if (type == null) {
            throw new EncoderConfigurationException("no EncoderType.");
        }
        if (metaRefSet == null) {
            throw new EncoderConfigurationException("no MetaRef set.");
        }
        if (!type.isBasic()) {
            props = type.getEncoderProperties().cloneMutable();
            props.addAll(properties);
        } else {
            props = properties;
        }
        return mEncoderProviderMap.get(type.getIdentification()).newEncoders(metaRefSet, null, props);
    }

    private String extractIdOrAlias(String encodingStyle) {
        int pos = encodingStyle.indexOf(63);
        if (pos == -1) {
            return encodingStyle;
        }
        return encodingStyle.substring(0, pos);
    }

    private EncoderProperties extractProperties(String encodingStyle) throws UnsupportedEncodingException {
        int pos = encodingStyle.indexOf(63);
        if (pos == -1) {
            return null;
        }
        String[] propStrs = (encodingStyle = encodingStyle.substring(pos + 1)).split("\\&");
        if (propStrs == null || propStrs.length == 0) {
            return null;
        }
        EncoderProperties properties = new EncoderProperties();
        for (int i = 0; i < propStrs.length; ++i) {
            String[] keyValueStr = propStrs[i].split("=");
            if (keyValueStr == null || keyValueStr.length == 0) continue;
            if (keyValueStr.length == 1) {
                properties.setProperty(URLDecoder.decode(keyValueStr[0], "UTF-8"));
                continue;
            }
            properties.setProperty(URLDecoder.decode(keyValueStr[0], "UTF-8"), URLDecoder.decode(keyValueStr[1], "UTF-8"));
        }
        return properties;
    }

    static {
        EncoderFactory.loadAllEncoderProviders(mEncoderProviderMap);
        EncoderFactory.populateEncoderTypes(mEncoderTypeMap, mEncoderTypeSet, mEncoderProviderMap);
    }

    private class SimpleMetaRef
    implements MetaRef {
        private final String mPath;
        private final URL mURL;
        private final QName mRootElemName;
        private final String mToString;

        protected SimpleMetaRef(String mainFile) {
            this(mainFile, null);
        }

        protected SimpleMetaRef(String mainFile, QName rootElemName) {
            this.mPath = mainFile;
            this.mURL = null;
            this.mRootElemName = rootElemName;
            StringBuffer sb = new StringBuffer();
            sb.append('[').append(this.mPath).append(']');
            if (this.mRootElemName != null) {
                sb.append(this.mRootElemName);
            }
            this.mToString = sb.toString();
        }

        protected SimpleMetaRef(URL mainFile, QName rootElemName) {
            this.mPath = null;
            this.mURL = mainFile;
            this.mRootElemName = rootElemName;
            StringBuffer sb = new StringBuffer();
            sb.append('[').append(this.mURL.toString()).append(']');
            if (this.mRootElemName != null) {
                sb.append(this.mRootElemName);
            }
            this.mToString = sb.toString();
        }

        public String getPath() {
            return this.mPath;
        }

        public URL getURL() {
            return this.mURL;
        }

        public QName getRootElemName() {
            return this.mRootElemName;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SimpleMetaRef)) {
                return false;
            }
            return this.mToString.equals(((SimpleMetaRef)obj).mToString);
        }

        public int hashCode() {
            return this.mToString.hashCode();
        }

        public String toString() {
            return this.mToString;
        }
    }
}

