/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.runtime.provider;

import com.sun.encoder.runtime.CoderException;
import com.sun.encoder.runtime.provider.SharedCoder;

public class Utf8Coder
extends SharedCoder {
    private boolean mStrict = false;
    private boolean mValid = false;
    private static final byte PAD_BYTE = 32;

    public Utf8Coder(boolean strict, boolean valid) {
        this.mStrict = strict;
        this.mValid = valid;
    }

    public Utf8Coder() {
        this(false, false);
    }

    public byte[] encode(String s, int min, int max) throws CoderException {
        char c;
        if (s == null) {
            return null;
        }
        if (0 <= min && 0 <= max && max < min) {
            throw new IllegalArgumentException("max (" + max + ") < min (" + min + ")");
        }
        int len = s.length();
        int size = 0;
        for (int i = 0; i < len; ++i) {
            c = s.charAt(i);
            if (c < '\u0080') {
                ++size;
            } else if (c < '\u0800') {
                size += 2;
            } else if (c < '\ufffe') {
                size += 3;
            } else {
                throw new CoderException("char #" + i + " = " + Utf8Coder.uname(c) + ", not encodable");
            }
            if (!this.mValid || Character.isDefined(c)) continue;
            throw new CoderException("char #" + i + " = " + Utf8Coder.uname(c) + ", not valid Unicode");
        }
        if (size < min) {
            size = min;
        }
        if (0 <= max && max < size) {
            throw new CoderException("too big: " + size + ", max=" + max);
        }
        byte[] b = new byte[size];
        size = 0;
        for (int i = 0; i < len; ++i) {
            c = s.charAt(i);
            if (c < '\u0080') {
                b[size++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                b[size++] = (byte)(0xC0 | c >> 6);
                b[size++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c >= '\ufffe') continue;
            b[size++] = (byte)(0xE0 | c >> 12);
            b[size++] = (byte)(0x80 | c >> 6 & 0x3F);
            b[size++] = (byte)(0x80 | c & 0x3F);
        }
        while (size < b.length) {
            b[size++] = 32;
        }
        return b;
    }

    public String decode(byte[] b, int from, int length) throws CoderException {
        if (b == null) {
            return null;
        }
        if (from < 0 || b.length < from || length < 0 || b.length < from + length) {
            throw new CoderException("invalid size/from/length: " + b.length + "/" + from + "/" + length);
        }
        int size = 0;
        for (int i = from; i < length; ++i) {
            if ((b[i] & 0xC0) == 128) continue;
            ++size;
        }
        char[] c = new char[size];
        size = 0;
        for (int i = from; i < length; ++i) {
            int n = b[i] & 0xFF;
            if (n >= 128) {
                byte e1;
                if ((n & 0xE0) == 192) {
                    if (i + 1 == b.length) {
                        throw new CoderException(i, "needs extra");
                    }
                    if (((e1 = b[++i]) & 0xC0) != 128) {
                        throw new CoderException(i, "byte = " + Utf8Coder.bname(e1 & 0xFF) + ", invalid extra");
                    }
                    n = (n & 0x1F) << 6 | e1 & 0x3F;
                    if (this.mStrict && n < 128) {
                        throw new CoderException(i - 1, "uses 2-byte code for " + n);
                    }
                } else if ((n & 0xF0) == 224) {
                    byte e2;
                    if (i + 2 >= b.length) {
                        throw new CoderException(i, "needs 2 extra");
                    }
                    if (((e1 = b[++i]) & 0xC0) != 128) {
                        throw new CoderException(i, "byte = " + Utf8Coder.bname(e1 & 0xFF) + ", invalid 1st extra");
                    }
                    if (((e2 = b[++i]) & 0xC0) != 128) {
                        throw new CoderException(i, "byte = " + Utf8Coder.bname(e2 & 0xFF) + ", invalid 2nd extra");
                    }
                    if (this.mStrict && n < 128) {
                        throw new CoderException("byte #" + (i - 1) + " uses 2-byte code for " + n);
                    }
                    n = (n & 0xF) << 12 | (e1 & 0x3F) << 6 | e2 & 0x3F;
                    if (this.mStrict && n < 2048) {
                        throw new CoderException(i - 1, " uses 3-byte code for " + n);
                    }
                } else {
                    throw new CoderException(i, "byte = " + Utf8Coder.bname(n & 0xFF) + ", invalid start");
                }
            }
            c[size++] = (char)n;
            if (!this.mValid || Character.isDefined((char)n)) continue;
            throw new CoderException(i, "code = " + Utf8Coder.uname(n) + ", not valid Unicode");
        }
        return new String(c);
    }
}

