/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.expression;

import prefuse.data.Schema;
import prefuse.data.Tuple;
import prefuse.data.expression.BinaryExpression;
import prefuse.data.expression.Expression;
import prefuse.util.TypeLib;

public class ArithmeticExpression
extends BinaryExpression {
    public static final int ADD = 0;
    public static final int SUB = 1;
    public static final int MUL = 2;
    public static final int DIV = 3;
    public static final int POW = 4;
    public static final int MOD = 5;
    private Class m_type = null;

    public ArithmeticExpression(int operation, Expression left, Expression right) {
        super(operation, 0, 5, left, right);
    }

    public Class getType(Schema s) {
        if (this.m_type == null) {
            Class lType = this.m_left.getType(s);
            Class rType = this.m_right.getType(s);
            this.m_type = TypeLib.getNumericType(lType, rType);
        }
        return this.m_type;
    }

    public Object get(Tuple t) {
        Class type = this.getType(t.getSchema());
        if (Integer.TYPE == type) {
            return new Integer(this.getInt(t));
        }
        if (Long.TYPE == type) {
            return new Long(this.getInt(t));
        }
        if (Float.TYPE == type) {
            return new Float(this.getFloat(t));
        }
        if (Double.TYPE == type) {
            return new Double(this.getDouble(t));
        }
        throw new IllegalStateException();
    }

    public int getInt(Tuple t) {
        int x = this.m_left.getInt(t);
        int y = this.m_right.getInt(t);
        switch (this.m_op) {
            case 0: {
                return x + y;
            }
            case 1: {
                return x - y;
            }
            case 2: {
                return x * y;
            }
            case 3: {
                return x / y;
            }
            case 4: {
                return (int)Math.pow(x, y);
            }
            case 5: {
                return x % y;
            }
        }
        throw new IllegalStateException("Unknown operation type.");
    }

    public long getLong(Tuple t) {
        long x = this.m_left.getLong(t);
        long y = this.m_right.getLong(t);
        switch (this.m_op) {
            case 0: {
                return x + y;
            }
            case 1: {
                return x - y;
            }
            case 2: {
                return x * y;
            }
            case 3: {
                return x / y;
            }
            case 4: {
                return (long)Math.pow(x, y);
            }
            case 5: {
                return x % y;
            }
        }
        throw new IllegalStateException("Unknown operation type.");
    }

    public float getFloat(Tuple t) {
        float x = this.m_left.getFloat(t);
        float y = this.m_right.getFloat(t);
        switch (this.m_op) {
            case 0: {
                return x + y;
            }
            case 1: {
                return x - y;
            }
            case 2: {
                return x * y;
            }
            case 3: {
                return x / y;
            }
            case 4: {
                return (float)Math.pow(x, y);
            }
            case 5: {
                return (float)Math.IEEEremainder(x, y);
            }
        }
        throw new IllegalStateException("Unknown operation type.");
    }

    public double getDouble(Tuple t) {
        double x = this.m_left.getDouble(t);
        double y = this.m_right.getDouble(t);
        switch (this.m_op) {
            case 0: {
                return x + y;
            }
            case 1: {
                return x - y;
            }
            case 2: {
                return x * y;
            }
            case 3: {
                return x / y;
            }
            case 4: {
                return Math.pow(x, y);
            }
            case 5: {
                return Math.IEEEremainder(x, y);
            }
        }
        throw new IllegalStateException("Unknown operation type.");
    }

    public String toString() {
        char op = '?';
        switch (this.m_op) {
            case 0: {
                op = '+';
                break;
            }
            case 1: {
                op = '-';
                break;
            }
            case 2: {
                op = '*';
                break;
            }
            case 3: {
                op = '/';
                break;
            }
            case 4: {
                op = '^';
                break;
            }
            case 5: {
                op = '%';
            }
        }
        return '(' + this.m_left.toString() + ' ' + op + ' ' + this.m_right.toString() + ')';
    }
}

