/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.designer;

import com.sun.rave.designtime.DesignBean;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.jellytools.TopComponentOperator;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.operators.JToggleButtonOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.modules.visualweb.api.designer.DomProvider;
import org.netbeans.modules.visualweb.css2.CssBox;
import org.netbeans.modules.visualweb.css2.ModelViewMapper;
import org.netbeans.modules.visualweb.css2.PageBox;
import org.netbeans.modules.visualweb.designer.DesignerPane;
import org.netbeans.modules.visualweb.designer.WebForm;
import org.netbeans.modules.visualweb.designer.html.HtmlAttribute;
import org.netbeans.modules.visualweb.designer.jsf.JsfForm;
import org.netbeans.modules.visualweb.designer.jsf.ui.JsfTopComponent;
import org.netbeans.modules.visualweb.gravy.Bundle;
import org.netbeans.modules.visualweb.gravy.RaveWindowOperator;
import org.netbeans.modules.visualweb.gravy.Util;
import org.netbeans.modules.visualweb.gravy.properties.Property;
import org.netbeans.modules.visualweb.gravy.properties.PropertySheetOperator;
import org.netbeans.modules.visualweb.gravy.properties.PropertySheetTabOperator;
import org.netbeans.modules.visualweb.gravy.properties.SheetTableOperator;
import org.netbeans.modules.visualweb.gravy.toolbox.PaletteContainerOperator;
import org.netbeans.modules.visualweb.insync.models.FacesModel;
import org.openide.filesystems.FileObject;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.w3c.dom.Element;

public class DesignerPaneOperator
extends JComponentOperator {
    private static final String DESIGNER_BUTTON_DESIGN = Bundle.getStringTrimmed("org.netbeans.modules.visualweb.project.jsfloader.Bundle", "CTL_DesignerTabCaption");
    private static final String DESIGNER_BUTTON_JSP = Bundle.getStringTrimmed("org.netbeans.modules.visualweb.project.jsfloader.Bundle", "CTL_JspTabCaption");
    private static final String DESIGNER_BUTTON_JAVA = Bundle.getStringTrimmed("org.netbeans.modules.visualweb.project.jsfloader.Bundle", "CTL_JavaTabCaption");
    protected static String defaultPalette = "JSFSTD";
    protected String currentPalette = defaultPalette;

    public DesignerPaneOperator(ContainerOperator cont) {
        super(cont, (ComponentChooser)new DesignerPaneChooser());
    }

    public DesignerPaneOperator(ContainerOperator cont, int index) {
        super(cont, (ComponentChooser)new DesignerPaneChooser(), index);
    }

    public DesignerPaneOperator() {
        this((ContainerOperator)RaveWindowOperator.getDefaultRave());
    }

    public ContainerOperator getDesignerView() {
        return new ContainerOperator(this.getContainer((ComponentChooser)new Operator.Finder(JsfTopComponent.class)));
    }

    public Point getComponentCenter(String comp_id) {
        CssBox box = this.getCssBox(this.getDesignBean(comp_id));
        if (box != null) {
            return new Point(box.getAbsoluteX(), box.getAbsoluteY());
        }
        return null;
    }

    public Point getComponentLocation(String componentID) {
        Rectangle compRect = this.getComponentRectangle(componentID);
        if (compRect != null) {
            return compRect.getLocation();
        }
        return null;
    }

    public Rectangle getComponentRectangle(String componentID) {
        CssBox box = this.getCssBox(this.getDesignBean(componentID));
        if (box != null) {
            return box.getExtentsRectangle();
        }
        return null;
    }

    private DesignBean getDesignBean(String componentID) {
        if (componentID == null || componentID.length() < 1) {
            return null;
        }
        DesignerPane designerPane = (DesignerPane)this.getSource();
        WebForm webForm = designerPane.getWebForm();
        DomProvider domProvider = webForm.getDomProvider();
        JsfForm jsfForm = JsfForm.findJsfFormForDomProvider((DomProvider)domProvider);
        FileObject jspFileObject = jsfForm.getJspDataObject().getPrimaryFile();
        FacesModel facesModel = FacesModel.getInstance((FileObject)jspFileObject);
        DesignBean bean = facesModel.getLiveUnit().getBeanByName(componentID);
        return bean;
    }

    private CssBox getCssBox(DesignBean designBean) {
        if (designBean == null) {
            return null;
        }
        DesignerPane designerPane = (DesignerPane)this.getSource();
        WebForm webForm = designerPane.getWebForm();
        CssBox cssBox = ModelViewMapper.findBox((PageBox)webForm.getPane().getPageBox(), (Element)webForm.getSelection().getSelectedComponentRootElements()[0]);
        return cssBox;
    }

    public void clickForPopup(String comp_id) {
        Point p = this.getComponentCenter(comp_id);
        this.clickForPopup(p.x, p.y);
    }

    public void clickMouse(String comp_id, int clickCount) {
        Point p = this.getComponentCenter(comp_id);
        this.clickMouse(p.x, p.y, clickCount);
    }

    public void select(String comp_id) {
        Point p = this.getComponentCenter(comp_id);
        this.clickMouse(p.x, p.y, 1);
    }

    public void addComponent(String component, int x, int y) {
        this.addComponent(component, x, y, null, null);
    }

    public void addComponent(String component, int x, int y, String id, String value) {
        this.addComponentFromPalette(component, x, y, id, value, this.currentPalette);
    }

    public static void setDefaultPalette(String palName) {
        defaultPalette = palName;
    }

    public static void setDefaultBraveHeartPalette() {
        defaultPalette = "Basic";
    }

    public static void setDefaultStandardPalette() {
        defaultPalette = "JSFSTD";
    }

    public void setPalette(String palName) {
        this.currentPalette = palName;
    }

    public void setBraveHeartPalette() {
        this.setPalette("Basic");
    }

    public void setStandardPalette() {
        this.setPalette("JSFSTD");
    }

    public void addComponentFromPalette(String component, int x, int y, String id, String value, String palName) {
        Util.wait(2000);
        PaletteContainerOperator palette = PaletteContainerOperator.showPalette(org.netbeans.jellytools.Bundle.getStringTrimmed((String)"com.sun.rave.toolbox.Bundle", (String)"COMPONENTS"), palName);
        System.out.println("======================================================================");
        System.out.println(palName + " Components");
        System.out.println("======================================================================");
        Point clickPoint = palette.getClickPoint(component);
        new QueueTool().waitEmpty();
        palette.getComponentsTree().clickMouse(clickPoint.x, clickPoint.y, 1);
        Util.wait(300);
        palette.addComponent(component, this, new Point(x, y));
        Util.wait(1000);
        SheetTableOperator props = new SheetTableOperator();
        if (id != null) {
            props.setTextValue("id", id);
            Util.wait(1000);
        }
        if (value != null) {
            props.setTextValue("value", value);
            Util.wait(1000);
        }
    }

    public static void switchToJSPSource() {
        DesignerPaneOperator.switchToSource(DESIGNER_BUTTON_JSP);
    }

    public static void switchToJavaSource() {
        DesignerPaneOperator.switchToSource(DESIGNER_BUTTON_JAVA);
    }

    public static void switchToDesignerPane() {
        DesignerPaneOperator.switchToSource(DESIGNER_BUTTON_DESIGN);
    }

    private static void switchToSource(String toggleButtonText) {
        JToggleButtonOperator toggleButton = new JToggleButtonOperator((ContainerOperator)Util.getMainWindow(), toggleButtonText);
        Util.wait(1000);
        toggleButton.setSelected(true);
        Util.wait(1000);
    }

    public Point getCoords() {
        PropertySheetOperator pso = new PropertySheetOperator((ContainerOperator)Util.getMainWindow());
        PropertySheetTabOperator psto = new PropertySheetTabOperator((ContainerOperator)pso);
        psto.setComparator((Operator.StringComparator)new Operator.DefaultStringComparator(true, true));
        Property pr = new Property((ContainerOperator)psto, "style");
        String propValue = pr.getValue();
        int xLoc = HtmlAttribute.parseInt((String)propValue.substring(propValue.indexOf("left: ") + 6));
        int yLoc = HtmlAttribute.parseInt((String)propValue.substring(propValue.indexOf("top: ") + 5));
        return new Point(xLoc, yLoc);
    }

    public void makeComponentVisible() {
        TopComponent theComponent;
        final TopComponent topComponent = theComponent = (TopComponent)DesignerPaneOperator.findContainerUnder((Component)this.getSource(), (ComponentChooser)new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return comp instanceof TopComponent;
            }

            public String getDescription() {
                return "TopComponent";
            }
        });
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    String topComponentString = WindowManager.getDefault().findTopComponentID(topComponent);
                    System.out.println("++++++++++++++++++++++++++++++++++++++++++++++++");
                    System.out.println(topComponentString);
                    System.out.println("++++++++++++++++++++++++++++++++++++++++++++++++");
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new TopComponentOperator((JComponent)theComponent).makeComponentVisible();
        super.makeComponentVisible();
    }

    public void setImage(String componentID, String imagePath) {
        this.clickForPopup(componentID);
        Util.wait(500);
        new JPopupMenuOperator().pushMenuNoBlock(org.netbeans.jellytools.Bundle.getStringTrimmed((String)"org.netbeans.modules.visualweb.gravy.Bundle", (String)"DesignerMenuItem_SetImage"));
        JDialogOperator dialog = new JDialogOperator(org.netbeans.jellytools.Bundle.getStringTrimmed((String)"org.netbeans.modules.visualweb.gravy.Bundle", (String)"DesignerMenuItem_SetImage"));
        JTextFieldOperator tf_Name = new JTextFieldOperator((ContainerOperator)dialog, 0);
        tf_Name.setText(imagePath);
        Util.wait(1000);
        new JButtonOperator((ContainerOperator)dialog, org.netbeans.jellytools.Bundle.getStringTrimmed((String)"org.netbeans.modules.visualweb.gravy.Bundle", (String)"OK")).pushNoBlock();
        dialog.waitClosed();
        Util.wait(1000);
    }

    public void setImage(int x, int y, String imagePath) {
        this.clickForPopup(x, y);
        Util.wait(500);
        new JPopupMenuOperator().pushMenuNoBlock(org.netbeans.jellytools.Bundle.getStringTrimmed((String)"org.netbeans.modules.visualweb.gravy.Bundle", (String)"DesignerMenuItem_SetImage"));
        JDialogOperator dialog = new JDialogOperator(org.netbeans.jellytools.Bundle.getStringTrimmed((String)"org.netbeans.modules.visualweb.gravy.Bundle", (String)"Dialog_ImageCustomizer"));
        new JTextFieldOperator((ContainerOperator)dialog, 0).enterText(imagePath);
        Util.wait(1000);
        new JButtonOperator((ContainerOperator)dialog, org.netbeans.jellytools.Bundle.getStringTrimmed((String)"org.netbeans.modules.visualweb.gravy.Bundle", (String)"Button_OK")).pushNoBlock();
        dialog.waitClosed();
        Util.wait(1000);
    }

    public static class DesignerPaneChooser
    implements ComponentChooser {
        public boolean checkComponent(Component comp) {
            return comp instanceof DesignerPane;
        }

        public String getDescription() {
            return DesignerPane.class.getName();
        }
    }
}

