/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.tests.jfluid.cpu;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.AppStatusHandler;
import org.netbeans.lib.profiler.client.ProfilingPointsProcessor;
import org.netbeans.lib.profiler.results.CCTProvider;
import org.netbeans.lib.profiler.results.EventBufferResultsProvider;
import org.netbeans.lib.profiler.results.ProfilingResultsDispatcher;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.cpu.CPUCCTProvider;
import org.netbeans.lib.profiler.results.cpu.CPUCallGraphBuilder;
import org.netbeans.lib.profiler.results.cpu.CPUProfilingResultListener;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.FlatProfileBuilder;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainerFree;
import org.netbeans.lib.profiler.tests.jfluid.CommonProfilerTestCase;
import org.netbeans.lib.profiler.tests.jfluid.utils.TestProfilerAppHandler;
import org.netbeans.lib.profiler.tests.jfluid.utils.TestProfilingPointsProcessor;
import org.netbeans.lib.profiler.tests.jfluid.utils.Utils;
import org.netbeans.lib.profiler.utils.StringUtils;

public abstract class CPUTestCase
extends CommonProfilerTestCase {
    static int ALL_INV_ERROR_METHOD = 0;
    static int LAST_INV_ERROR_METHOD = 1;
    NumberFormat percentFormat = NumberFormat.getPercentInstance();

    public CPUTestCase(String name) {
        super(name);
        this.percentFormat.setMaximumFractionDigits(1);
        this.percentFormat.setMinimumFractionDigits(0);
    }

    public int getALL_INV_ERROR_METHOD() {
        return ALL_INV_ERROR_METHOD;
    }

    protected double getError(int invocations, long mctime, long idealtime) {
        double ideal = (double)(idealtime * (long)invocations) * 1000.0;
        return Math.abs(ideal - (double)mctime) / 1000.0;
    }

    protected void checkCPUResults(FlatProfileContainer fpc, HashMap methods, String[] measuredMethodsFilter) {
        int row;
        double percent = 0.0;
        for (row = 0; row < fpc.getNRows(); ++row) {
            percent += (double)fpc.getPercentAtRow(row);
            for (int mets = 0; mets < measuredMethodsFilter.length; ++mets) {
                if (!fpc.getMethodNameAtRow(row).startsWith(measuredMethodsFilter[mets])) continue;
                Measured m = (Measured)methods.get(fpc.getMethodNameAtRow(row));
                if (m == null) {
                    m = new Measured();
                    m.time = fpc.getTimeInMcs0AtRow(row);
                    m.invocations = fpc.getNInvocationsAtRow(row);
                    methods.put(fpc.getMethodNameAtRow(row), m);
                    continue;
                }
                long tm = m.time;
                int inv = m.invocations;
                m.setTime(fpc.getTimeInMcs0AtRow(row));
                m.setInvocations(fpc.getNInvocationsAtRow(row));
                if (tm <= m.time && inv <= m.invocations) continue;
                this.log("\n!!!Decreasing values: method " + fpc.getMethodNameAtRow(row) + " current time " + m.time + " invocations " + m.invocations + " but was time=" + tm + " invocations=" + inv + "\n");
                CPUTestCase.assertFalse((String)"Unacceptable results - decresing values (issue 65187)", (boolean)true);
            }
        }
        if (Math.abs(percent - 100.0) > 0.1) {
            this.log("\n!!!Sum of percents is not 100% - " + percent + "\n");
            for (row = 0; row < fpc.getNRows(); ++row) {
                this.log(fpc.getMethodIdAtRow(row) + " " + this.percentFormat.format(fpc.getPercentAtRow(row) / 100.0f) + " %");
            }
            CPUTestCase.assertFalse((String)"Unacceptable results - sum of percents != 100", (boolean)true);
        }
    }

    protected void checkCPUResults(FlatProfileContainer fpc, String[] methodsNames, long[] idealTimes, double diffMillis, String[] refMethods, ArrayList refMethodsList, int errorMethod) {
        double[] errors = new double[methodsNames.length];
        int[] nInv = new int[methodsNames.length];
        long[] times = new long[methodsNames.length];
        for (int row = 0; row < fpc.getNRows(); ++row) {
            int mets;
            for (mets = 0; mets < methodsNames.length; ++mets) {
                if (!fpc.getMethodNameAtRow(row).equals(methodsNames[mets])) continue;
                nInv[mets] = fpc.getNInvocationsAtRow(row);
                times[mets] = fpc.getTimeInMcs0AtRow(row);
                errors[mets] = this.getError(nInv[mets], times[mets], idealTimes[mets]);
            }
            if (refMethods == null) continue;
            for (mets = 0; mets < refMethods.length; ++mets) {
                String mname = fpc.getMethodNameAtRow(row);
                if (!mname.startsWith(refMethods[mets]) || refMethodsList.contains(mname)) continue;
                refMethodsList.add(mname);
            }
        }
        double best = diffMillis / 4.0;
        int bestcount = 0;
        boolean bigdifference = false;
        for (int cntr = 0; cntr < errors.length; ++cntr) {
            if (errors[cntr] <= best) {
                ++bestcount;
            }
            bigdifference |= errors[cntr] > diffMillis;
        }
        boolean accepted = !bigdifference || (double)bestcount * 1.0 >= (double)errors.length * 0.5;
        this.logFractions(errors, nInv, times, idealTimes, methodsNames);
        this.log("");
        if (!accepted) {
            this.log("\nRESULTS WITH BIG DIFFERENCES - differences are greater than given tolerance: " + diffMillis + " ms");
            this.log("Best count " + bestcount + " errors.length " + errors.length);
        }
    }

    protected ProfilerEngineSettings initCpuTest(String projectName, String mainClass) {
        return this.initCpuTest(projectName, mainClass, null);
    }

    protected ProfilerEngineSettings initCpuTest(String projectName, String mainClass, String[][] rootMethods) {
        ProfilerEngineSettings settings = this.initTest(projectName, mainClass, rootMethods);
        settings.setCPUProfilingType(0);
        settings.setInstrScheme(1);
        settings.setInstrumentEmptyMethods(false);
        settings.setInstrumentGetterSetterMethods(false);
        settings.setInstrumentMethodInvoke(true);
        settings.setInstrumentSpawnedThreads(rootMethods != null);
        settings.setExcludeWaitTime(true);
        settings.setThreadCPUTimerOn(false);
        return settings;
    }

    protected void logFractions(double[] errors, int[] inv, long[] times, long[] ideals, String[] methods) {
        this.log(this.complete("Error[ms]", 10) + this.complete("Invocs", 10) + this.complete("Time[ms]", 10) + this.complete("Ideal[ms]", 10) + "Method");
        for (int i = 0; i < errors.length; ++i) {
            this.log(this.complete(String.valueOf(errors[i]), 9) + " " + this.complete(String.valueOf(inv[i]), 9) + " " + this.complete(StringUtils.mcsTimeToString((long)times[i]), 9) + " " + this.complete(String.valueOf(ideals[i] * (long)inv[i]), 9) + " " + methods[i]);
        }
    }

    protected void logInstrumented(TargetAppRunner runner) throws Exception {
        CPUResultsSnapshot snapshot = runner.getProfilerClient().getCPUProfilingResultsSnapshot();
        String[] mets = snapshot.getInstrMethodNames();
        this.log("Instrumented methods:");
        for (int i = 0; i < mets.length; ++i) {
            this.log(mets[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startCPUTest(ProfilerEngineSettings settings, String[] measuredMethods, long[] idealTimes, double diffMillis, String[] displayMethodsFilter, int errorMethod) {
        CPUCallGraphBuilder builder = new CPUCallGraphBuilder();
        CPUTestCase.assertTrue((builder != null ? 1 : 0) != 0);
        TargetAppRunner runner = new TargetAppRunner(settings, (AppStatusHandler)new TestProfilerAppHandler(this), (ProfilingPointsProcessor)new TestProfilingPointsProcessor());
        runner.addProfilingEventListener(Utils.createProfilingListener(this));
        ProfilingResultsDispatcher.getDefault().addListener((CPUProfilingResultListener)builder);
        CPUResultListener resultListener = new CPUResultListener();
        builder.addListener((CCTProvider.Listener)resultListener);
        FlatProfileBuilder flattener = new FlatProfileBuilder();
        builder.addListener((CCTProvider.Listener)flattener);
        flattener.setContext(runner.getProfilerClient());
        EventBufferResultsProvider.getDefault().startup(runner.getProfilerClient());
        builder.startup(runner.getProfilerClient());
        try {
            runner.readSavedCalibrationData();
            Process p = this.startTargetVM(runner);
            CPUTestCase.assertNotNull((String)"Target JVM is not started", (Object)p);
            this.bindStreams(p);
            runner.connectToStartedVMAndStartTA();
            runner.getProfilerClient().initiateRecursiveCPUProfInstrumentation(settings.getInstrumentationRootMethods());
            this.waitForStatus(1);
            CPUTestCase.assertTrue((String)"runner is not running", (boolean)runner.targetAppIsRunning());
            ArrayList methods = new ArrayList();
            this.waitForStatus(4);
            if (runner.targetJVMIsAlive()) {
                this.log("Get results: " + System.currentTimeMillis());
                CPUTestCase.assertTrue((String)"Results do not exist - issue 65185.", (boolean)runner.getProfilerClient().cpuResultsExist());
                boolean gotResults = false;
                int retryCounter = 4;
                while (!(gotResults = resultListener.wait4results(2500L)) && --retryCounter > 0) {
                }
                CPUTestCase.assertTrue((String)"Results are not available after 10 seconds.", (boolean)gotResults);
                this.log("obtaining results " + String.valueOf(System.currentTimeMillis()));
                FlatProfileContainerFree fpc = null;
                int retry = 5;
                while (fpc == null && --retry > 0) {
                    fpc = (FlatProfileContainerFree)flattener.createFlatProfile();
                    Thread.sleep(500L);
                }
                fpc.filterOriginalData(new String[]{""}, 20, 0.0);
                this.checkCPUResults((FlatProfileContainer)fpc, measuredMethods, idealTimes, diffMillis, displayMethodsFilter, methods, errorMethod);
            }
            this.setStatus(8);
            if (methods.size() > 0) {
                Collections.sort(methods);
                for (int mets = 0; mets < methods.size(); ++mets) {
                    this.ref(methods.get(mets));
                }
            }
        }
        catch (Exception ex) {
            this.log(ex);
            CPUTestCase.assertTrue((String)("Exception thrown: " + ex.getMessage()), (boolean)false);
        }
        finally {
            ProfilingResultsDispatcher.getDefault().pause(true);
            builder.shutdown();
            flattener.setContext(null);
            builder.removeListener((CCTProvider.Listener)flattener);
            builder.removeListener((CCTProvider.Listener)resultListener);
            ProfilingResultsDispatcher.getDefault().removeListener((CPUProfilingResultListener)builder);
            this.finalizeTest(runner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startCPUTest(ProfilerEngineSettings settings, String[] measuredMethodsFilter, long checkDelay, long maxDelay) {
        CPUCallGraphBuilder builder = new CPUCallGraphBuilder();
        CPUTestCase.assertTrue((builder != null ? 1 : 0) != 0);
        TargetAppRunner runner = new TargetAppRunner(settings, (AppStatusHandler)new TestProfilerAppHandler(this), (ProfilingPointsProcessor)new TestProfilingPointsProcessor());
        runner.addProfilingEventListener(Utils.createProfilingListener(this));
        ProfilingResultsDispatcher.getDefault().addListener((CPUProfilingResultListener)builder);
        CPUResultListener resultListener = new CPUResultListener();
        builder.addListener((CCTProvider.Listener)resultListener);
        FlatProfileBuilder flattener = new FlatProfileBuilder();
        builder.addListener((CCTProvider.Listener)flattener);
        flattener.setContext(runner.getProfilerClient());
        EventBufferResultsProvider.getDefault().startup(runner.getProfilerClient());
        builder.startup(runner.getProfilerClient());
        try {
            runner.readSavedCalibrationData();
            Process p = this.startTargetVM(runner);
            CPUTestCase.assertNotNull((String)"Target JVM is not started", (Object)p);
            this.bindStreams(p);
            runner.connectToStartedVMAndStartTA();
            runner.getProfilerClient().initiateRecursiveCPUProfInstrumentation(settings.getInstrumentationRootMethods());
            this.waitForStatus(1);
            CPUTestCase.assertTrue((String)"runner is not running", (boolean)runner.targetAppIsRunning());
            this.waitForStatus(6);
            CPUTestCase.assertTrue((String)"ResultsAvailable was not called - issue 69084", (boolean)this.isStatus(2));
            HashMap methods = new HashMap(128);
            long time = System.currentTimeMillis();
            long oldtime = time - checkDelay;
            for (long alltime = 0L; !this.isStatus(4) && !this.isStatus(255) && alltime < maxDelay; alltime += System.currentTimeMillis() - time) {
                if (time - oldtime < 2L * checkDelay) {
                    Thread.sleep(2L * checkDelay - (time - oldtime));
                }
                if (!this.isStatus(32)) {
                    this.waitForStatus(32, checkDelay / 2L);
                }
                if (runner.targetJVMIsAlive() && this.isStatus(32)) {
                    CPUTestCase.assertTrue((String)"Results do not exist - issue 65185.", (boolean)runner.getProfilerClient().cpuResultsExist());
                    this.log("Get Results: " + System.currentTimeMillis());
                    boolean gotResults = false;
                    int retryCounter = 2;
                    do {
                        runner.getProfilerClient().forceObtainedResultsDump();
                    } while (!(gotResults = resultListener.wait4results(2500L)) && --retryCounter > 0);
                    CPUTestCase.assertTrue((String)"CallGraphBuilder: Results do not exist.", (boolean)gotResults);
                    this.log("Results obtained " + String.valueOf(System.currentTimeMillis()));
                    FlatProfileContainerFree fpc = null;
                    int retry = 5;
                    while (fpc == null && --retry > 0) {
                        fpc = (FlatProfileContainerFree)flattener.createFlatProfile();
                        Thread.sleep(500L);
                    }
                    fpc.filterOriginalData(new String[]{""}, 20, 0.0);
                    fpc.sortBy(2, true);
                    this.checkCPUResults((FlatProfileContainer)fpc, methods, measuredMethodsFilter);
                }
                oldtime = time;
                time = System.currentTimeMillis();
            }
            if (methods.size() == 0) {
                CPUTestCase.assertTrue((String)"Results were not on the server - issue 65185", (boolean)false);
            }
        }
        catch (Exception ex) {
            this.log(ex);
            CPUTestCase.assertTrue((String)("Exception thrown: " + ex.getMessage()), (boolean)false);
        }
        finally {
            ProfilingResultsDispatcher.getDefault().pause(true);
            builder.shutdown();
            flattener.setContext(null);
            builder.removeListener((CCTProvider.Listener)flattener);
            builder.removeListener((CCTProvider.Listener)resultListener);
            ProfilingResultsDispatcher.getDefault().removeListener((CPUProfilingResultListener)builder);
            this.finalizeTest(runner);
        }
    }

    private class CPUResultListener
    implements CPUCCTProvider.Listener {
        private final Object resultsLock = new Object();
        private boolean hasResults = false;

        private CPUResultListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cctEstablished(RuntimeCCTNode appRootNode) {
            Object object = this.resultsLock;
            synchronized (object) {
                this.hasResults = true;
                this.resultsLock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cctReset() {
            Object object = this.resultsLock;
            synchronized (object) {
                this.hasResults = false;
                this.resultsLock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean wait4results(long timeout) {
            Object object = this.resultsLock;
            synchronized (object) {
                if (!this.hasResults) {
                    try {
                        this.resultsLock.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                return this.hasResults;
            }
        }
    }

    class Measured {
        public int invocations = 0;
        public long time = 0L;

        Measured() {
        }

        public void setInvocations(int invc) {
            this.invocations = invc;
        }

        public void setTime(long time) {
            this.time = time;
        }
    }
}

