/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.event.DatabaseSequenceEvent;
import org.axiondb.event.SequenceModificationListener;
import org.axiondb.types.IntegerType;

public class Sequence
implements Serializable {
    public static int RADIX = 10;
    private BigInteger _currValue;
    private BigInteger _incrementBy = BigInteger.valueOf(1L);
    private boolean _isCycle = false;
    private List _listeners = null;
    private BigInteger _maxValue = BigInteger.valueOf(Integer.MAX_VALUE);
    private BigInteger _minValue = BigInteger.valueOf(0L);
    private String _name = null;
    private BigInteger _nextValue;
    private DataType _type = null;
    private static final long serialVersionUID = -9173917866159022446L;

    public Sequence() {
    }

    public Sequence(String name, DataType type, BigInteger startVal, BigInteger incrementBy, BigInteger maxValue, BigInteger minValue, boolean isCycle) {
        this._type = type;
        this._nextValue = startVal;
        this._incrementBy = incrementBy;
        this._name = name.toUpperCase();
        this._listeners = new ArrayList();
        this._maxValue = maxValue;
        this._minValue = minValue;
        this._isCycle = isCycle;
        this.assertRules();
    }

    public Sequence(String name, int startVal) {
        this._type = new IntegerType();
        this._name = name.toUpperCase();
        this._nextValue = BigInteger.valueOf(startVal);
        this._listeners = new ArrayList();
    }

    public void addSequenceModificationListener(SequenceModificationListener listener) {
        this._listeners.add(listener);
    }

    public boolean equals(Object otherobject) {
        if (otherobject instanceof Sequence) {
            Sequence that = (Sequence)otherobject;
            return this.getName().equals(that.getName());
        }
        return false;
    }

    public Object evaluate() throws AxionException {
        this._currValue = this._nextValue;
        this._nextValue = this._nextValue.add(this._incrementBy);
        if (this._nextValue.compareTo(this._minValue) == -1 || this._nextValue.compareTo(this._maxValue) == 1) {
            if (this._isCycle) {
                this._nextValue = this._incrementBy.signum() == 1 ? this._minValue : this._maxValue;
            } else {
                throw new IllegalStateException("No more value available for this sequence...");
            }
        }
        for (SequenceModificationListener cur : this._listeners) {
            cur.sequenceIncremented(new DatabaseSequenceEvent(this));
        }
        return this.getDataType().convert(this._currValue);
    }

    public Object getCuurentValue() throws AxionException {
        return this.getDataType().convert(this._currValue);
    }

    public DataType getDataType() {
        return this._type;
    }

    public BigInteger getIncrementBy() {
        return this._incrementBy;
    }

    public BigInteger getMaxValue() {
        return this._maxValue;
    }

    public BigInteger getMinValue() {
        return this._minValue;
    }

    public String getName() {
        return this._name;
    }

    public Object getValue() throws AxionException {
        return this._nextValue;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean isCycle() {
        return this._isCycle;
    }

    public void read(DataInput in) throws Exception {
        this._name = in.readUTF();
        String dtypename = in.readUTF();
        Class<?> clazz = Class.forName(dtypename);
        this._type = (DataType)clazz.newInstance();
        this._nextValue = new BigInteger(in.readUTF(), RADIX);
        this._incrementBy = new BigInteger(in.readUTF(), RADIX);
        this._maxValue = new BigInteger(in.readUTF(), RADIX);
        this._minValue = new BigInteger(in.readUTF(), RADIX);
        this._isCycle = in.readBoolean();
        this._listeners = new ArrayList();
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.getName());
        out.writeUTF(this.getDataType().getClass().getName());
        out.writeUTF(this._nextValue.toString(RADIX));
        out.writeUTF(this.getIncrementBy().toString(RADIX));
        out.writeUTF(this.getMaxValue().toString(RADIX));
        out.writeUTF(this.getMinValue().toString(RADIX));
        out.writeBoolean(this.isCycle());
    }

    private void assertRules() {
        if (this._incrementBy.signum() == 0) {
            throw new IllegalArgumentException("IncrementBy Should be non-zero numeric literal");
        }
        if (this._minValue.compareTo(this._maxValue) >= 0) {
            throw new IllegalArgumentException("MinValue Should be less than MaxValue");
        }
        if (this._nextValue.compareTo(this._minValue) == -1 || this._nextValue.compareTo(this._maxValue) == 1) {
            throw new IllegalArgumentException("StartValue Should be within min and max Value");
        }
    }
}

