/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.rowiterators;

import java.util.NoSuchElementException;
import org.axiondb.AxionException;
import org.axiondb.Row;
import org.axiondb.RowIterator;
import org.axiondb.engine.rowiterators.BaseRowIterator;

public class ReverseSortedRowIterator
extends BaseRowIterator {
    private int _currentIndex = -1;
    private int _nextIndex = 0;
    private RowIterator _delegate = null;

    public ReverseSortedRowIterator(RowIterator sortedIterator) throws AxionException {
        this._delegate = sortedIterator;
        this.reset();
    }

    public void add(Row row) throws AxionException {
        throw new UnsupportedOperationException();
    }

    public Row current() {
        if (!this.hasCurrent()) {
            throw new NoSuchElementException("No Current Row");
        }
        return this.getDelegate().current();
    }

    public int currentIndex() {
        return this._currentIndex;
    }

    public Row first() throws AxionException {
        this.reset();
        return this.peekNext();
    }

    public boolean hasCurrent() {
        if (this._currentIndex == -1) {
            return false;
        }
        return this.getDelegate().hasCurrent();
    }

    public boolean hasNext() {
        return this.getDelegate().hasPrevious();
    }

    public boolean hasPrevious() {
        return this.getDelegate().hasNext();
    }

    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    public Row last() throws AxionException {
        if (!this.hasNext()) {
            this.previous();
        }
        Row row = null;
        while (this.hasNext()) {
            row = this.next();
        }
        return row;
    }

    public Row next() throws AxionException {
        this._currentIndex = this._nextIndex++;
        return this.getDelegate().previous();
    }

    public int nextIndex() {
        return this._nextIndex;
    }

    public Row peekNext() throws AxionException {
        this.next();
        return this.previous();
    }

    public Row peekPrevious() throws AxionException {
        this.previous();
        return this.next();
    }

    public Row previous() throws AxionException {
        --this._nextIndex;
        this._currentIndex = this._nextIndex;
        return this.getDelegate().next();
    }

    public int previousIndex() {
        return this._nextIndex - 1;
    }

    public void remove() throws AxionException {
        this.getDelegate().remove();
        this._currentIndex = -1;
        --this._nextIndex;
    }

    public void reset() throws AxionException {
        this.getDelegate().reset();
        this._currentIndex = -1;
        this._nextIndex = 0;
        while (this.getDelegate().hasNext()) {
            this.getDelegate().next();
        }
    }

    public void set(Row row) throws AxionException {
        this.getDelegate().set(row);
    }

    public String toString() {
        return "ReverseSorted(" + this.getDelegate() + ")";
    }

    private RowIterator getDelegate() {
        return this._delegate;
    }
}

