/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import java.sql.Timestamp;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.Selectable;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.StringType;
import org.axiondb.types.TimestampType;
import org.axiondb.util.DateTimeUtils;

public class DatePartFunction
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private static final DataType TIMESTAMP_TYPE = new TimestampType();
    private static final DataType RETURN_TYPE = new StringType();

    public DatePartFunction() {
        super("DATEPART");
    }

    public ConcreteFunction makeNewInstance() {
        return new DatePartFunction();
    }

    public DataType getDataType() {
        return RETURN_TYPE;
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        Timestamp timestamp = null;
        Selectable sel = this.getArgument(0);
        String partType = (String)RETURN_TYPE.convert(sel.evaluate(row));
        String partIdent = DateTimeUtils.getPartMnemonicFor(partType);
        Object dateSrc = this.getArgument(1).evaluate(row);
        if (dateSrc == null) {
            return null;
        }
        timestamp = (Timestamp)TIMESTAMP_TYPE.convert(dateSrc);
        return DateTimeUtils.getDatePart(timestamp, partIdent);
    }

    public boolean isValid() {
        return this.getArgumentCount() == 2;
    }
}

