/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.Row;
import org.axiondb.RowDecorator;
import org.axiondb.RowIterator;
import org.axiondb.engine.commands.SubSelectCommand;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.BooleanType;

public class NotInFunction
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private static final DataType BOOLEAN_TYPE = new BooleanType();

    public NotInFunction() {
        super("NOTIN");
    }

    public ConcreteFunction makeNewInstance() {
        return new NotInFunction();
    }

    public DataType getDataType() {
        return BOOLEAN_TYPE;
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        Object lval = this.getArgument(0).evaluate(row);
        DataType ltype = this.getArgument(0).getDataType();
        if (this.getArgument(1) instanceof SubSelectCommand) {
            SubSelectCommand cmd = (SubSelectCommand)this.getArgument(1);
            RowIterator iter = (RowIterator)cmd.evaluate(row);
            while (iter.hasNext()) {
                Row rrow = iter.next();
                int I = rrow.size();
                for (int i = 0; i < I; ++i) {
                    Object rval = rrow.get(i);
                    try {
                        rval = ltype.convert(rval);
                        if (ltype.compare(lval, ltype.convert(rval)) != 0) continue;
                        return Boolean.FALSE;
                    }
                    catch (AxionException e) {
                        // empty catch block
                    }
                }
            }
        } else {
            int I = this.getArgumentCount();
            for (int i = 1; i < I; ++i) {
                Object rval = this.getArgument(i).evaluate(row);
                try {
                    rval = ltype.convert(rval);
                    if (ltype.compare(lval, ltype.convert(rval)) != 0) continue;
                    return Boolean.FALSE;
                }
                catch (AxionException e) {
                    // empty catch block
                }
            }
        }
        return Boolean.TRUE;
    }

    public boolean isValid() {
        return this.getArgumentCount() >= 1;
    }
}

