/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import org.axiondb.AxionException;

public class FileUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertFileNotLocked(File file) throws AxionException {
        FileOutputStream fos = null;
        FileLock lock = null;
        try {
            fos = new FileOutputStream(file);
            lock = fos.getChannel().tryLock(0L, Long.MAX_VALUE, false);
            if (lock == null) {
                throw new AxionException("Unable to get a lock for file " + file);
            }
        }
        catch (FileNotFoundException fnf) {
        }
        catch (IOException ioe) {
        }
        finally {
            try {
                if (lock != null) {
                    lock.release();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    public static boolean delete(File file) throws AxionException {
        if (file == null || !file.exists()) {
            return true;
        }
        try {
            if (file.isFile()) {
                return file.delete();
            }
            return FileUtil.fullyDelete(file);
        }
        catch (IOException e) {
            throw new AxionException("Unable to delete " + file);
        }
    }

    public static long getLength(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long len = fis.getChannel().size();
        fis.close();
        return len;
    }

    public static void renameFile(File dir, String oldName, String newName) {
        File oldfile = new File(dir, oldName);
        File newfile = new File(dir, newName);
        if (newfile.exists()) {
            newfile.delete();
        }
        oldfile.renameTo(newfile);
    }

    public static void renameFile(File dir, String old, String name, String ext) {
        FileUtil.renameFile(dir, old + ext, name + ext);
    }

    public static void renameToUpperCase(File dir) throws IOException {
        File[] files = dir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                files[i].renameTo(new File(files[i].getParentFile(), files[i].getName().toUpperCase()));
                if (!files[i].isDirectory()) continue;
                FileUtil.renameToUpperCase(files[i]);
            }
        }
    }

    public static void truncate(File file, long length) throws AxionException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file, true);
            out.getChannel().truncate(length);
        }
        catch (IOException e) {
            throw new AxionException(e);
        }
        finally {
            try {
                out.close();
            }
            catch (Exception e) {}
        }
    }

    private static boolean fullyDelete(File dir) throws IOException {
        File[] contents = dir.listFiles();
        if (contents != null) {
            for (int i = 0; i < contents.length; ++i) {
                if (!(contents[i].isFile() ? !contents[i].delete() : !FileUtil.fullyDelete(contents[i]))) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static String getDirecoryFromPath(String path) {
        String ret = null;
        int lastNameSeperator = -1;
        if (path != null) {
            lastNameSeperator = path.lastIndexOf(File.separator);
            if (lastNameSeperator == -1) {
                lastNameSeperator = path.lastIndexOf("\\");
            }
            if (lastNameSeperator == -1) {
                lastNameSeperator = path.lastIndexOf("/");
            }
            if (lastNameSeperator != -1) {
                ret = path.substring(0, lastNameSeperator + 1);
            }
        }
        return ret;
    }
}

