/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoControl;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObjList;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoObjectCollection;
import com.nwoods.jgo.JGoObjectSimpleCollection;
import com.nwoods.jgo.JGoSubGraph;
import com.nwoods.jgo.JGoView;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;

public class JGoLayer
implements JGoObjectCollection,
Serializable {
    static final int ChangedNoClear = 1902;
    private JGoObjList myObjects;
    private JGoDocument myDocument;
    private JGoLayer myNextLayer = null;
    private JGoLayer myPrevLayer = null;
    boolean myVisible = true;
    float myTransparency = 1.0f;
    boolean myModifiable = true;
    Object myIdentifier = null;
    private transient ArrayList myCaches = null;
    private Rectangle myTempRect1 = new Rectangle(0, 0, 0, 0);
    private Rectangle myTempRect2 = new Rectangle(0, 0, 0, 0);

    void init(JGoDocument doc) {
        this.myObjects = new JGoObjList(true);
        this.myDocument = doc;
    }

    void insert(JGoLayer next, JGoLayer prev) {
        this.myNextLayer = next;
        this.myPrevLayer = prev;
        if (next != null) {
            next.myPrevLayer = this;
        }
        if (prev != null) {
            prev.myNextLayer = this;
        }
    }

    void extract() {
        if (this.myPrevLayer != null) {
            this.myPrevLayer.myNextLayer = this.myNextLayer;
        }
        if (this.myNextLayer != null) {
            this.myNextLayer.myPrevLayer = this.myPrevLayer;
        }
    }

    public JGoDocument getDocument() {
        return this.myDocument;
    }

    public JGoLayer getNextLayer() {
        return this.myNextLayer;
    }

    public JGoLayer getPrevLayer() {
        return this.myPrevLayer;
    }

    public int getNumObjects() {
        return this.myObjects.getNumObjects();
    }

    public boolean isEmpty() {
        return this.myObjects.isEmpty();
    }

    public JGoListPosition addObjectAtHead(JGoObject obj) {
        if (obj == null) {
            return null;
        }
        if (obj.getParent() != null) {
            return null;
        }
        if (obj.getView() != null) {
            return null;
        }
        if (obj.getDocument() != null) {
            if (obj.getDocument() != this.getDocument()) {
                return null;
            }
            JGoListPosition pos = this.myObjects.getFirstObjectPos();
            if (this.myObjects.getObjectAtPos(pos) == obj) {
                return pos;
            }
            JGoLayer objlayer = obj.getLayer();
            JGoListPosition oldpos = objlayer.findObject(obj);
            JGoListPosition nextobjpos = objlayer.getNextObjectPos(oldpos);
            JGoObject nextobj = objlayer.getObjectAtPos(nextobjpos);
            objlayer.myObjects.removeObjectAtPos(oldpos);
            JGoListPosition objpos = this.myObjects.addObjectAtHead(obj);
            obj.setLayer(this, -1, null, obj);
            if (nextobj != null) {
                obj.update(10, 1, nextobj);
            } else {
                obj.update(10, 0, objlayer);
            }
            return objpos;
        }
        JGoListPosition objpos = this.myObjects.addObjectAtHead(obj);
        obj.setLayer(this, 6, this, obj);
        if (obj.isTopLevel()) {
            this.insertIntoCache(obj, 6, null);
        }
        this.getDocument().updateDocumentSize(obj);
        return objpos;
    }

    public JGoListPosition addObjectAtTail(JGoObject obj) {
        if (obj == null) {
            return null;
        }
        if (obj.getParent() != null) {
            return null;
        }
        if (obj.getView() != null) {
            return null;
        }
        if (obj.getDocument() != null) {
            if (obj.getDocument() != this.getDocument()) {
                return null;
            }
            JGoListPosition pos = this.myObjects.getLastObjectPos();
            if (this.myObjects.getObjectAtPos(pos) == obj) {
                return pos;
            }
            JGoLayer objlayer = obj.getLayer();
            JGoListPosition oldpos = objlayer.findObject(obj);
            JGoListPosition nextobjpos = objlayer.getNextObjectPos(oldpos);
            JGoObject nextobj = objlayer.getObjectAtPos(nextobjpos);
            objlayer.myObjects.removeObjectAtPos(oldpos);
            JGoListPosition objpos = this.myObjects.addObjectAtTail(obj);
            obj.setLayer(this, -1, null, obj);
            if (nextobj != null) {
                obj.update(10, 1, nextobj);
            } else {
                obj.update(10, 0, objlayer);
            }
            return objpos;
        }
        JGoListPosition objpos = this.myObjects.addObjectAtTail(obj);
        obj.setLayer(this, 2, this, obj);
        if (obj.isTopLevel()) {
            this.insertIntoCache(obj, 2, null);
        }
        this.getDocument().updateDocumentSize(obj);
        return objpos;
    }

    public JGoListPosition insertObjectBefore(JGoListPosition pos, JGoObject obj) {
        if (pos == null || obj == null) {
            return null;
        }
        if (obj.getParent() != null) {
            return null;
        }
        if (obj.getView() != null) {
            return null;
        }
        if (obj.getDocument() != null) {
            if (obj.getDocument() != this.getDocument()) {
                return null;
            }
            if (this.myObjects.getObjectAtPos(pos) == obj) {
                return pos;
            }
            JGoLayer objlayer = obj.getLayer();
            JGoListPosition oldpos = objlayer.findObject(obj);
            JGoListPosition nextobjpos = objlayer.getNextObjectPos(oldpos);
            JGoObject nextobj = objlayer.getObjectAtPos(nextobjpos);
            objlayer.myObjects.removeObjectAtPos(oldpos);
            JGoListPosition objpos = this.myObjects.insertObjectBefore(pos, obj);
            obj.setLayer(this, -1, null, obj);
            if (nextobj != null) {
                obj.update(10, 1, nextobj);
            } else {
                obj.update(10, 0, objlayer);
            }
            return objpos;
        }
        JGoObject nextobj = this.myObjects.getObjectAtPos(pos);
        JGoListPosition objpos = this.myObjects.insertObjectBefore(pos, obj);
        obj.setLayer(this, 8, nextobj, obj);
        if (obj.isTopLevel()) {
            this.insertIntoCache(obj, 8, nextobj);
        }
        this.getDocument().updateDocumentSize(obj);
        return objpos;
    }

    public JGoListPosition insertObjectAfter(JGoListPosition pos, JGoObject obj) {
        if (pos == null || obj == null) {
            return null;
        }
        if (obj.getParent() != null) {
            return null;
        }
        if (obj.getView() != null) {
            return null;
        }
        if (obj.getDocument() != null) {
            if (obj.getDocument() != this.getDocument()) {
                return null;
            }
            if (this.myObjects.getObjectAtPos(pos) == obj) {
                return pos;
            }
            JGoLayer objlayer = obj.getLayer();
            JGoListPosition oldpos = objlayer.findObject(obj);
            JGoListPosition nextobjpos = objlayer.getNextObjectPos(oldpos);
            JGoObject nextobj = objlayer.getObjectAtPos(nextobjpos);
            objlayer.myObjects.removeObjectAtPos(oldpos);
            JGoListPosition objpos = this.myObjects.insertObjectAfter(pos, obj);
            obj.setLayer(this, -1, null, obj);
            if (nextobj != null) {
                obj.update(10, 1, nextobj);
            } else {
                obj.update(10, 0, objlayer);
            }
            return objpos;
        }
        JGoObject prevobj = this.myObjects.getObjectAtPos(pos);
        JGoListPosition objpos = this.myObjects.insertObjectAfter(pos, obj);
        obj.setLayer(this, 4, prevobj, obj);
        if (obj.isTopLevel()) {
            this.insertIntoCache(obj, 4, prevobj);
        }
        this.getDocument().updateDocumentSize(obj);
        return objpos;
    }

    public void bringObjectToFront(JGoObject obj) {
        this.addObjectAtTail(obj);
    }

    public void sendObjectToBack(JGoObject obj) {
        this.addObjectAtHead(obj);
    }

    public void removeObject(JGoObject obj) {
        if (obj == null) {
            return;
        }
        if (obj.getLayer() != this) {
            return;
        }
        JGoArea area = obj.getParent();
        if (area != null) {
            area.removeObject(obj);
        } else {
            JGoListPosition pos = this.findObject(obj);
            if (pos != null) {
                this.removeObjectAtPos(pos);
            }
        }
    }

    public JGoObject removeObjectAtPos(JGoListPosition pos) {
        JGoListPosition nextpos = this.myObjects.getNextObjectPos(pos);
        JGoListPosition prevpos = this.myObjects.getPrevObjectPos(pos);
        JGoObject obj = this.myObjects.removeObjectAtPos(pos);
        if (obj != null) {
            JGoObject nextobj;
            if (obj.isTopLevel()) {
                this.removeFromCache(obj);
            }
            if ((nextobj = this.myObjects.getObjectAtPos(nextpos)) == null) {
                obj.setLayer(null, 2, obj.getLayer(), obj);
            } else {
                JGoObject prevobj = this.myObjects.getObjectAtPos(prevpos);
                if (prevobj == null) {
                    obj.setLayer(null, 6, obj.getLayer(), obj);
                } else {
                    Object[] info = new Object[]{obj.getLayer(), prevobj, nextobj};
                    obj.setLayer(null, 0, info, obj);
                }
            }
        }
        return obj;
    }

    public void paint(Graphics2D g, JGoView view, Rectangle clipRect) {
        Rectangle objRect = this.myTempRect1;
        Rectangle viewrect = view.getViewRect();
        JGoLayerCache c = this.findCache(view);
        if (c != null && c.getRect().equals(viewrect)) {
            ArrayList a = c.getObjects();
            int len = a.size();
            for (int i = 0; i < len; ++i) {
                JGoObject obj = (JGoObject)a.get(i);
                if (!obj.isVisible()) continue;
                Rectangle b = obj.getBoundingRect();
                objRect.x = b.x;
                objRect.y = b.y;
                objRect.width = b.width;
                objRect.height = b.height;
                obj.expandRectByPenWidth(objRect);
                if (!objRect.intersects(clipRect)) continue;
                obj.paint(g, view);
            }
        } else if (this.cacheWanted(view)) {
            if (c == null) {
                c = new JGoLayerCache(view);
                this.getCaches().add(c);
            } else {
                c.reset();
            }
            c.setRect(viewrect);
            JGoListPosition pos = this.getFirstObjectPos();
            while (pos != null) {
                JGoObject obj = this.getObjectAtPos(pos);
                pos = this.getNextObjectPosAtTop(pos);
                Rectangle b = obj.getBoundingRect();
                objRect.x = b.x;
                objRect.y = b.y;
                objRect.width = b.width;
                objRect.height = b.height;
                obj.expandRectByPenWidth(objRect);
                if (obj.isVisible() && objRect.intersects(clipRect)) {
                    obj.paint(g, view);
                }
                if (!objRect.intersects(viewrect)) continue;
                c.getObjects().add(obj);
            }
        } else {
            JGoListPosition pos = this.getFirstObjectPos();
            while (pos != null) {
                JGoObject obj = this.getObjectAtPos(pos);
                pos = this.getNextObjectPosAtTop(pos);
                if (!obj.isVisible()) continue;
                Rectangle b = obj.getBoundingRect();
                objRect.x = b.x;
                objRect.y = b.y;
                objRect.width = b.width;
                objRect.height = b.height;
                obj.expandRectByPenWidth(objRect);
                if (!objRect.intersects(clipRect)) continue;
                obj.paint(g, view);
            }
        }
    }

    ArrayList getCaches() {
        if (this.myCaches == null) {
            this.myCaches = new ArrayList();
        }
        return this.myCaches;
    }

    private boolean cacheWanted(JGoView view) {
        return JGoDocument.myCaching && !view.isPrinting();
    }

    private JGoLayerCache findCache(JGoView view) {
        ArrayList a = this.getCaches();
        int len = a.size();
        for (int i = 0; i < len; ++i) {
            JGoLayerCache c = (JGoLayerCache)a.get(i);
            if (c.getView() != view) continue;
            return c;
        }
        return null;
    }

    private JGoLayerCache findCache(Point p) {
        JGoLayerCache cache = null;
        ArrayList a = this.getCaches();
        int len = a.size();
        for (int i = 0; i < len; ++i) {
            JGoLayerCache c = (JGoLayerCache)a.get(i);
            if (!c.getRect().contains(p) || cache != null && c.getObjects().size() >= cache.getObjects().size()) continue;
            cache = c;
        }
        return cache;
    }

    void resetCache() {
        this.myCaches = new ArrayList();
    }

    void updateCache(JGoObject obj, Rectangle oldr) {
        Rectangle oldrect = this.myTempRect1;
        oldrect.x = oldr.x;
        oldrect.y = oldr.y;
        oldrect.width = oldr.width;
        oldrect.height = oldr.height;
        obj.expandRectByPenWidth(oldrect);
        Rectangle b = obj.getBoundingRect();
        Rectangle newrect = this.myTempRect2;
        newrect.x = b.x;
        newrect.y = b.y;
        newrect.width = b.width;
        newrect.height = b.height;
        obj.expandRectByPenWidth(newrect);
        ArrayList a = this.getCaches();
        int len = a.size();
        for (int i = 0; i < len; ++i) {
            JGoLayerCache c = (JGoLayerCache)a.get(i);
            boolean oldinside = c.getRect().intersects(oldrect);
            boolean newinside = c.getRect().intersects(newrect);
            if (oldinside || !newinside || c.getObjects().contains(obj)) continue;
            c.getObjects().add(obj);
        }
    }

    void insertIntoCache(JGoObject obj, int spot, Object nextobj) {
        Rectangle b = obj.getBoundingRect();
        Rectangle newrect = this.myTempRect2;
        newrect.x = b.x;
        newrect.y = b.y;
        newrect.width = b.width;
        newrect.height = b.height;
        obj.expandRectByPenWidth(newrect);
        ArrayList a = this.getCaches();
        int len = a.size();
        for (int i = 0; i < len; ++i) {
            JGoLayerCache c = (JGoLayerCache)a.get(i);
            boolean newinside = c.getRect().intersects(newrect);
            if (!newinside) continue;
            if (spot == 2) {
                c.getObjects().add(obj);
                continue;
            }
            if (spot == 6) {
                c.getObjects().add(0, obj);
                continue;
            }
            c.getObjects().add(obj);
        }
    }

    void removeFromCache(JGoObject obj) {
        Rectangle oldr = obj.getBoundingRect();
        Rectangle oldrect = this.myTempRect1;
        oldrect.x = oldr.x;
        oldrect.y = oldr.y;
        oldrect.width = oldr.width;
        oldrect.height = oldr.height;
        obj.expandRectByPenWidth(oldrect);
        ArrayList a = this.getCaches();
        int len = a.size();
        for (int i = 0; i < len; ++i) {
            JGoLayerCache c = (JGoLayerCache)a.get(i);
            boolean oldinside = c.getRect().intersects(oldrect);
            if (!oldinside) continue;
            c.getObjects().remove(obj);
        }
    }

    public JGoObject pickObject(Point pointToCheck, boolean selectableOnly) {
        if (!this.isVisible()) {
            return null;
        }
        JGoLayerCache c = this.findCache(pointToCheck);
        if (c != null) {
            ArrayList a = c.getObjects();
            int len = a.size();
            for (int i = len - 1; i >= 0; --i) {
                JGoObject obj = (JGoObject)a.get(i);
                JGoObject picked = obj.pick(pointToCheck, selectableOnly);
                if (picked == null) continue;
                return picked;
            }
        } else {
            JGoListPosition pos = this.getLastObjectPos();
            while (pos != null) {
                JGoObject obj = this.getObjectAtPos(pos);
                pos = this.getPrevObjectPos(pos);
                JGoObject picked = obj.pick(pointToCheck, selectableOnly);
                if (picked == null) continue;
                return picked;
            }
        }
        return null;
    }

    public ArrayList pickObjects(Point p, boolean selectableOnly, ArrayList coll, int max) {
        if (coll == null) {
            coll = new ArrayList<JGoObject>();
        }
        if (coll.size() >= max) {
            return coll;
        }
        if (!this.isVisible()) {
            return coll;
        }
        JGoLayerCache c = this.findCache(p);
        if (c != null) {
            ArrayList a = c.getObjects();
            int len = a.size();
            for (int i = len - 1; i >= 0; --i) {
                JGoObject obj = (JGoObject)a.get(i);
                if (obj instanceof JGoArea) {
                    ((JGoArea)obj).pickObjects(p, selectableOnly, coll, max);
                    continue;
                }
                JGoObject picked = obj.pick(p, selectableOnly);
                if (picked == null) continue;
                coll.add(obj);
                if (coll.size() < max) continue;
                return coll;
            }
        } else {
            JGoListPosition pos = this.getLastObjectPos();
            while (pos != null) {
                JGoObject obj = this.getObjectAtPos(pos);
                pos = this.getPrevObjectPos(pos);
                if (obj instanceof JGoArea) {
                    ((JGoArea)obj).pickObjects(p, selectableOnly, coll, max);
                    continue;
                }
                JGoObject picked = obj.pick(p, selectableOnly);
                if (picked == null) continue;
                coll.add(obj);
                if (coll.size() < max) continue;
                return coll;
            }
        }
        return coll;
    }

    public JGoListPosition getFirstObjectPos() {
        return this.myObjects.getFirstObjectPos();
    }

    public JGoListPosition getLastObjectPos() {
        return this.myObjects.getLastObjectPos();
    }

    public JGoListPosition getNextObjectPos(JGoListPosition pos) {
        JGoObjectCollection area;
        if (pos == null) {
            return null;
        }
        JGoObject obj = pos.obj;
        if (obj instanceof JGoObjectCollection && !(area = (JGoObjectCollection)((Object)obj)).isEmpty()) {
            return area.getFirstObjectPos();
        }
        pos = pos.next;
        while (pos == null) {
            JGoArea parent = obj.getParent();
            if (parent == null) {
                return null;
            }
            JGoListPosition parentpos = parent.getCurrentListPosition();
            obj = parent;
            pos = parentpos.next;
        }
        return pos;
    }

    public JGoListPosition getNextObjectPosAtTop(JGoListPosition pos) {
        if (pos == null) {
            return null;
        }
        JGoObject obj = pos.obj;
        while (obj.getParent() != null) {
            pos = obj.getParent().getCurrentListPosition();
            obj = obj.getParent();
        }
        return pos.next;
    }

    public JGoListPosition getPrevObjectPos(JGoListPosition pos) {
        return this.myObjects.getPrevObjectPos(pos);
    }

    public JGoObject getObjectAtPos(JGoListPosition pos) {
        return this.myObjects.getObjectAtPos(pos);
    }

    public JGoListPosition findObject(JGoObject obj) {
        if (obj.getLayer() == this) {
            return this.myObjects.findObject(obj);
        }
        return null;
    }

    public final ArrayList addCollection(JGoObjectSimpleCollection coll, boolean reparentLinks, JGoLayer linksLayer) {
        ArrayList<JGoObject> collcopy = new ArrayList<JGoObject>();
        JGoListPosition pos = coll.getFirstObjectPos();
        while (pos != null) {
            JGoObject obj = coll.getObjectAtPos(pos);
            pos = coll.getNextObjectPosAtTop(pos);
            if (obj.getLayer() != null && obj.getLayer() != this) continue;
            collcopy.add(obj);
        }
        return this.addCollection(collcopy, reparentLinks, linksLayer);
    }

    public ArrayList addCollection(ArrayList coll, boolean reparentLinks, JGoLayer linkslayer) {
        this.getDocument().fireUpdate(1902, 0, this, 0, coll);
        for (int i = 0; i < coll.size(); ++i) {
            boolean inLayer;
            JGoObject obj = (JGoObject)coll.get(i);
            boolean bl = inLayer = obj.getLayer() != null;
            if (inLayer) {
                JGoArea.setAllNoClear(obj, true);
                obj.getLayer().removeObject(obj);
            }
            this.addObjectAtTail(obj);
            if (!inLayer) continue;
            JGoArea.setAllNoClear(obj, false);
        }
        this.getDocument().fireUpdate(1902, 0, this, 1, coll);
        if (reparentLinks && this.getDocument() != null) {
            JGoSubGraph.reparentAllLinksToSubGraphs(coll, true, linkslayer);
        }
        return coll;
    }

    public void removeAll() {
        JGoListPosition pos = this.getFirstObjectPos();
        while (pos != null) {
            this.removeObjectAtPos(pos);
            pos = this.getFirstObjectPos();
        }
    }

    public boolean isVisible() {
        return this.myVisible;
    }

    public void setVisible(boolean v) {
        this.setVisibleInternal(v, false);
    }

    void setVisibleInternal(boolean v, boolean undoing) {
        boolean oldVisible = this.myVisible;
        if (oldVisible != v) {
            this.myVisible = v;
            this.getDocument().fireUpdate(213, 0, this, oldVisible ? 1 : 0, null);
            if (!undoing && !this.myVisible) {
                JGoListPosition pos = this.getFirstObjectPos();
                while (pos != null) {
                    JGoObject obj = this.getObjectAtPos(pos);
                    pos = this.getNextObjectPos(pos);
                    if (!(obj instanceof JGoControl)) continue;
                    JGoControl ctrl = (JGoControl)obj;
                    ctrl.ownerChange(this.getDocument(), null, null);
                }
            }
        }
    }

    public float getTransparency() {
        return this.myTransparency;
    }

    public void setTransparency(float f) {
        float oldTransparency = this.myTransparency;
        if (oldTransparency != f) {
            this.myTransparency = f;
            this.getDocument().fireUpdate(215, 0, this, 0, new Float(oldTransparency));
        }
    }

    public boolean isModifiable() {
        return this.myModifiable && this.getDocument().isModifiable();
    }

    public void setModifiable(boolean b) {
        boolean oldMod = this.myModifiable;
        if (oldMod != b) {
            this.myModifiable = b;
            this.getDocument().fireUpdate(214, 0, this, oldMod ? 1 : 0, null);
        }
    }

    public Object getIdentifier() {
        return this.myIdentifier;
    }

    public void setIdentifier(Object x) {
        Object oldId = this.myIdentifier;
        if (oldId != x) {
            this.myIdentifier = x;
            this.getDocument().fireUpdate(217, 0, this, 0, oldId);
        }
    }

    final class JGoLayerCache {
        private transient JGoView myView = null;
        private transient ArrayList myObjects = null;
        private transient Rectangle myRect = null;

        JGoLayerCache(JGoView view) {
            this.myView = view;
            this.myObjects = new ArrayList();
            this.reset();
        }

        void reset() {
            this.myObjects.clear();
            this.myRect = new Rectangle(0, 0, 0, 0);
        }

        JGoView getView() {
            return this.myView;
        }

        ArrayList getObjects() {
            return this.myObjects;
        }

        Rectangle getRect() {
            return this.myRect;
        }

        void setRect(Rectangle value) {
            this.myRect.x = value.x;
            this.myRect.y = value.y;
            this.myRect.width = value.width;
            this.myRect.height = value.height;
        }
    }
}

