/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.coco.model;

public class CocoToken {
    public final String mValue;
    public final int mType;
    public final int mFoundCol;
    public final int mFoundRow;
    private boolean isEOL;

    public CocoToken(String value, int type) {
        this(value, type, -1, -1);
    }

    public CocoToken(String value, int type, int row, int col) throws IndexOutOfBoundsException {
        if (row < -1 || row == 0) {
            throw new IndexOutOfBoundsException();
        }
        if (col < -1 || col == 0) {
            throw new IndexOutOfBoundsException();
        }
        this.mValue = value;
        this.mType = type;
        this.mFoundRow = row;
        this.mFoundCol = col;
    }

    public int getType() {
        return this.mType;
    }

    public String getStringValue() {
        return this.mValue;
    }

    public char[] getCharsValue() {
        char[] value = null;
        if (this.mValue != null) {
            value = this.mValue.toCharArray();
        }
        return value;
    }

    public byte[] getBytesValue() {
        byte[] value = null;
        if (this.mValue != null) {
            value = new byte[this.mValue.length() * 2];
            int i = 0;
            int b = 0;
            while (i < value.length) {
                char ch = this.mValue.charAt(b);
                value[i] = (byte)((ch & 0xFFFF0000) >> 8);
                value[i + 1] = (byte)(ch & 0xFFFF);
                i += 2;
                ++b;
            }
        }
        return value;
    }

    public int getRow() {
        return this.mFoundRow;
    }

    public int getColumn() {
        return this.mFoundCol;
    }

    public int getLength() {
        return this.mValue == null ? 0 : this.mValue.length();
    }

    public void isEOL(boolean b) {
        this.isEOL = b;
    }

    public boolean isEOL() {
        return this.isEOL;
    }
}

