/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.debugger.ui.execution;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.bpel.debugger.api.pem.PemEntity;
import org.netbeans.modules.bpel.debugger.api.psm.PsmEntity;
import org.netbeans.modules.bpel.debugger.ui.util.HtmlUtil;
import org.openide.util.NbBundle;

import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;

/**
 *
 * @author Alexander Zgursky
 */
public class ProcessExecutionViewModel implements NodeModel, TableModel, Constants {
    private static final String PEM_ICON_BASE = 
            "org/netbeans/modules/bpel/debugger/ui/resources/image/execution/";
    
    private static final String PSM_ICON_BASE = PEM_ICON_BASE + "grayed-out/";
    
    private static final String ICON_UNKNOWN = "DEFAULT_BPEL_ENTITY_NODE";
    
    private static final String ROOT_ICON = PSM_ICON_BASE + ICON_UNKNOWN;

    private static Color NEVER_EXECUTED_COLOR = Color.GRAY;
    private static Color STARTED_COLOR = new Color(0, 128, 0);
    private static Color COMPLETED_COLOR = null;
    
    private Map<String, String> myIconByTag = new HashMap<String, String>();
    private Map<String, String> myLabelByTag = new HashMap<String, String>();
    
    ContextProvider myContextProvider;

    /**{@inheritDoc}*/
    public ProcessExecutionViewModel(ContextProvider contextProvider) {
        myContextProvider = contextProvider;
        initIcons();
        initLabels();
    }
    
    // NodeModel ----------------------------------------------------
    
    /**{@inheritDoc}*/
    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object == TreeModel.ROOT) {
            return NbBundle.getMessage(
                ProcessExecutionViewModel.class, "CTL_PEV_Column_Name"); // NOI18N
        } else if (object instanceof PsmEntity) {
            PsmEntity psmEntity = (PsmEntity)object;
            String label = makeLabel(psmEntity.getTag(), psmEntity.getName());
            return HtmlUtil.toHtml(label, false, false, NEVER_EXECUTED_COLOR);
        } else if (object instanceof PemEntity) {
            PemEntity pemEntity = (PemEntity)object;
            PsmEntity psmEntity = pemEntity.getPsmEntity();
            String label = makeLabel(psmEntity.getTag(), psmEntity.getName());
            if (psmEntity.getParent() != null && psmEntity.getParent().isLoop()) {
                label = label + " [" + pemEntity.getIndex() + "]";
            }
            PemEntity lastStarted = pemEntity.getModel().getLastStartedEntity();
            boolean isOfCurrent =
                    (lastStarted != null) && (lastStarted.isInTree(pemEntity));
            return HtmlUtil.toHtml(label, isOfCurrent, false, getColor(pemEntity));
        } else {
            throw new UnknownTypeException(object);
        }
    }
    
    /**{@inheritDoc}*/
    public String getShortDescription(Object object) throws UnknownTypeException {
        return getDisplayName(object);
    }
    
    /**{@inheritDoc}*/
    public String getIconBase(Object object) throws UnknownTypeException {
        if (object == TreeModel.ROOT) {
            return ROOT_ICON;
        } else if (object instanceof PsmEntity) {
            PsmEntity psmEntitiy = (PsmEntity)object;
            String tag = psmEntitiy.getTag();
            String icon = myIconByTag.get(tag);
            if (icon == null) {
                icon = ICON_UNKNOWN;
            }
            return PSM_ICON_BASE + icon;
        } else if (object instanceof PemEntity) {
            PemEntity pemEntitiy = (PemEntity)object;
            String tag = pemEntitiy.getPsmEntity().getTag();
            String icon = myIconByTag.get(tag);
            if (icon == null) {
                icon = ICON_UNKNOWN;
            }
            return PEM_ICON_BASE + icon;
        } else {
            throw new UnknownTypeException(object);
        }
    }
    
    // --------------------------------------------------------------
    
    /**{@inheritDoc}*/
    public void addModelListener(ModelListener listener) {}

    /**{@inheritDoc}*/
    public void removeModelListener(ModelListener listener) {}
    
    // TableModel ---------------------------------------------------
    
    /**{@inheritDoc}*/
    public Object getValueAt(Object object, String column)
        throws UnknownTypeException
    {
        if (object instanceof PsmEntity) {
            return "";
        } else if (object instanceof PemEntity) {
            return "";
        }
        
        throw new UnknownTypeException(object);
    }
    
    
    /**{@inheritDoc}*/
    public void setValueAt(Object object, String column, Object value)
        throws UnknownTypeException
    {
        if (object instanceof PsmEntity) {
            return;
        } else if (object instanceof PemEntity) {
            return;
        }
        
        throw new UnknownTypeException(object);
    }
    
    /**{@inheritDoc}*/
    public boolean isReadOnly(Object object, String column)
        throws UnknownTypeException
    {
        if (object instanceof PsmEntity) {
            return true;
        } else if (object instanceof PemEntity) {
            return true;
        }
            
        throw new UnknownTypeException(object);
    }
    
    private void initIcons() {
        myIconByTag.put("onAlarm", "ALARM_EVENT_HANDLER");
        //myIconByTag.put("onAlarm", "ALARM_HANDLER");
        myIconByTag.put("assign", "ASSIGN");
        myIconByTag.put("catch", "CATCH");
        myIconByTag.put("catchAll", "CATCH_ALL");
        myIconByTag.put("compensate", "COMPENSATE");
        myIconByTag.put("compensateScope", "COMPENSATE_SCOPE");
        myIconByTag.put("compensationHandler", "COMPENSATION_HANDLER");
        //myIconByTag.put("copy", "COPY");
        myIconByTag.put("else", "ELSE");
        myIconByTag.put("elseIf", "ELSE_IF");
        myIconByTag.put("empty", "EMPTY");
        myIconByTag.put("eventHandlers", "EVENT_HANDLERS");
        myIconByTag.put("exit", "EXIT");
        myIconByTag.put("faultHandlers", "FAULT_HANDLERS");
        myIconByTag.put("flow", "FLOW");
        myIconByTag.put("forEach", "FOR_EACH");
        myIconByTag.put("if", "IF");
        myIconByTag.put("invoke", "INVOKE");
        myIconByTag.put("onMessage", "MESSAGE_HANDLER");
        myIconByTag.put("onEvent", "ON_EVENT");
        myIconByTag.put("pick", "PICK");
        myIconByTag.put("process", "PROCESS");
        myIconByTag.put("receive", "RECEIVE");
        myIconByTag.put("repeatUntil", "REPEAT_UNTIL");
        myIconByTag.put("reply", "REPLY");
        myIconByTag.put("scope", "SCOPE");
        myIconByTag.put("sequence", "SEQUENCE");
        myIconByTag.put("terminationHandler", "TERMINATION_HANDLER");
        myIconByTag.put("then", "THEN");
        myIconByTag.put("throw", "THROW");
        myIconByTag.put("wait", "WAIT");
        myIconByTag.put("while", "WHILE");
    }
    
    private void initLabels() {
        myLabelByTag.put("onAlarm", "Alarm Handler");
        //myLabelByTag.put("onAlarm", "Alarm Handler");
        myLabelByTag.put("assign", "Assign");
        myLabelByTag.put("catch", "Catch");
        myLabelByTag.put("catchAll", "Catch All");
        myLabelByTag.put("compensate", "Compensate");
        myLabelByTag.put("compensateScope", "Compensate Scope");
        myLabelByTag.put("compensationHandler", "Compensaton Handler");
        //myLabelByTag.put("copy", "Copy");
        myLabelByTag.put("else", "Else");
        myLabelByTag.put("elseIf", "Else If");
        myLabelByTag.put("empty", "Empty");
        myLabelByTag.put("eventHandlers", "Event Handlers");
        myLabelByTag.put("exit", "Exit");
        myLabelByTag.put("faultHandlers", "Fault Handlers");
        myLabelByTag.put("flow", "Flow");
        myLabelByTag.put("forEach", "For Each");
        myLabelByTag.put("if", "If");
        myLabelByTag.put("invoke", "Invoke");
        myLabelByTag.put("onMessage", "Message Handler");
        myLabelByTag.put("onEvent", "On Event");
        myLabelByTag.put("pick", "Pick");
        myLabelByTag.put("process", "Process");
        myLabelByTag.put("receive", "Receive");
        myLabelByTag.put("repeatUntil", "Repeat Until");
        myLabelByTag.put("reply", "Reply");
        myLabelByTag.put("scope", "Scope");
        myLabelByTag.put("sequence", "Sequence");
        myLabelByTag.put("terminationHandler", "Termination Handler");
        myLabelByTag.put("then", "Then");
        myLabelByTag.put("throw", "Throw");
        myLabelByTag.put("wait", "Wait");
        myLabelByTag.put("while", "While");
    }
    
    private String makeLabel(String tag, String name) {
        String label;
        if (name != null && !name.equals("")) {
            label = name;
        } else {
            label = myLabelByTag.get(tag);
            if (label == null || label.equals("")) {
                label = tag;
            }
        }
        return label;
    }
    
    private Color getColor(PemEntity pemEntity) {
        switch (pemEntity.getState()) {
            case STARTED :
                return STARTED_COLOR;
            case COMPLETED :
                return COMPLETED_COLOR;
            case UNKNOWN :
            default :
                return STARTED_COLOR;
        }
    }
}
