/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.model.node.visitor;

import javax.xml.namespace.QName;
import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.bpel.model.api.VariableDeclaration;
import org.netbeans.modules.bpel.model.api.references.SchemaReference;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.bpel.xpath.model.nodes.BooleanPlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.BranchesPlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.BuiltInXSDTypes;
import org.netbeans.modules.bpel.xpath.model.nodes.DeadlinePlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.DurationPlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.FinalCounterValuePlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.PartNode;
import org.netbeans.modules.bpel.xpath.model.nodes.PredicatePlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.StartCounterValuePlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.TreeNode;
import org.netbeans.modules.bpel.xpath.model.nodes.VariableNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XPathLiteralNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XPathLocationStepNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XPathOperatorNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XSDAttributeNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XSDComplexTypeNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XSDElementNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XSDSimpleTypeNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XSDTypeHelper;
import org.netbeans.modules.xml.schema.model.Attribute;
import org.netbeans.modules.xml.schema.model.ComplexType;
import org.netbeans.modules.xml.schema.model.Element;
import org.netbeans.modules.xml.schema.model.GlobalAttribute;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.LocalAttribute;
import org.netbeans.modules.xml.schema.model.LocalSimpleType;
import org.netbeans.modules.xml.schema.model.SimpleType;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;

/**
 *
 * @author radval
 *
 */
public class NodeTypeFinderVisitor extends AbstractNodeVisitor {
    
    private QName mType;
    
    public NodeTypeFinderVisitor() {
    }
    
    public QName getType() {
        return this.mType;
    }
    
    public void visit(VariableNode node) {
        VariableDeclaration variable = node.getVariableDeclaration();
        WSDLReference<Message> messageRef  = variable.getMessageType();
        if(messageRef != null) {
            Message message = messageRef.get();
            if(message != null && message.getName() != null) {
                String localName = message.getName();
                String targetNamespace = message.getModel().getDefinitions().getTargetNamespace();
                if(localName != null && targetNamespace != null) {
                    QName messageQName = new QName(targetNamespace, localName);;
                    this.mType = messageQName;
                    return;
                }
            }
        }
        
        SchemaReference<GlobalElement> globalElementRef = variable.getElement();
        if(globalElementRef != null) {
            GlobalElement element = globalElementRef.get();
            if(element != null) {
                this.mType = XSDTypeHelper.findXSDType(element);
                return;
            }
        }
        
        SchemaReference<GlobalType> globalTypeRef = variable.getType();
        if(globalTypeRef != null) {
            GlobalType type = globalTypeRef.get();
            if(type != null) {
                this.mType = XSDTypeHelper.findXSDType(type);
            }
        }
    }

    
    
    public void visit(PartNode node) {
        Part part = node.getPart();
        
        NamedComponentReference<GlobalElement> globalElementRef = part.getElement();
        if(globalElementRef != null) {
            GlobalElement element = globalElementRef.get();
            this.mType = XSDTypeHelper.findXSDType(element);
            return;
        }
        
        NamedComponentReference<GlobalType> globalTypeRef = part.getType();
        if(globalTypeRef != null) {
            GlobalType type = globalTypeRef.get();
            if(type != null) {
                this.mType = XSDTypeHelper.findXSDType(type);
            }
        }
    }
    
    public void visit(XSDAttributeNode node) {
        Attribute attribute = node.getAttribute();
        if(attribute instanceof GlobalAttribute) {
            GlobalAttribute ga = (GlobalAttribute) attribute;
            NamedComponentReference<GlobalSimpleType> gstRef = ga.getType();
            if(gstRef != null) {
                GlobalSimpleType gst = gstRef.get();
                if(gst != null) {
                    this.mType = XSDTypeHelper.findXSDType(gst);
                }
            } else if(ga.getInlineType() != null) {
                LocalSimpleType lstRef = ga.getInlineType();
                if(lstRef != null) {
                    this.mType = XSDTypeHelper.findXSDType(lstRef);
                }
            }
            
            
        } else if (attribute instanceof LocalAttribute) {
            LocalAttribute la = (LocalAttribute) attribute;
            NamedComponentReference<GlobalSimpleType> laRef = la.getType();
            if(laRef != null) {
                GlobalSimpleType gst = laRef.get();
                if(gst != null) {
                    this.mType = XSDTypeHelper.findXSDType(gst);
                }
            }
            
        }
    }
    
    public void visit(XSDElementNode node) {
        Element element = node.getElement();
        if(element != null) {
            this.mType = XSDTypeHelper.findXSDType(element);
            return;
        }
    }
    
    public void visit(XSDComplexTypeNode node) {
        ComplexType type = node.getComplexType();
        if(type != null) {
            this.mType = XSDTypeHelper.findXSDType(type);
        }
    }
    
    public void visit(XSDSimpleTypeNode node) {
        SimpleType type = node.getSimpleType();
        if(type != null) {
            this.mType = XSDTypeHelper.findXSDType(type);
        }
    }
    
    public void visit(XPathOperatorNode node) {
    }
    
    public void visit(XPathLiteralNode node) {
    }
    
    public void visit(XPathLocationStepNode node) {
        TreeNode source = node.getSourceOfLocationStepNode();
        if(source != null) {
            source.accept(this);
        }
    }
    
    public void visit(BooleanPlaceHolderNode node) {
        this.mType = BuiltInXSDTypes.BOOLEAN_TYPE;
    }
    
    public void visit(StartCounterValuePlaceHolderNode node) {
        this.mType = BuiltInXSDTypes.INT_TYPE;
    }
    
    public void visit(FinalCounterValuePlaceHolderNode node) {
        this.mType = BuiltInXSDTypes.INT_TYPE;
    }
    
    public void visit(BranchesPlaceHolderNode node) {
        this.mType = BuiltInXSDTypes.INT_TYPE;
    }
    
    public void visit(DeadlinePlaceHolderNode node) {
        this.mType = BuiltInXSDTypes.DATE_TIME_TYPE;
    }
    
    public void visit(DurationPlaceHolderNode node) {
        this.mType = BuiltInXSDTypes.DURATION_TYPE;
    }
    
    public void visit(PredicatePlaceHolderNode node) {
        this.mType = BuiltInXSDTypes.ANY_TYPE;
    }
    
}
