/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.model.nodes;

import java.util.Hashtable;

import javax.xml.namespace.QName;
import org.netbeans.modules.xml.schema.model.Element;
import org.netbeans.modules.xml.schema.model.ComplexType;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.SimpleType;


/**
 *
 * @author radval
 *
 */
public class XSDTypeHelper {

    public static QName findXSDType(Element element) {
        return null;
    }
    
    public static QName findXSDType(ComplexType element) {
        return null;
    }
    
    public static QName findXSDType(GlobalElement element) {
        return null;
    }
    
    public static QName findXSDType(GlobalType type) {
        return null;
    }
    
    public static QName findXSDType(SimpleType type) {
        return null;
    }
	
    public static QName findXSDType(GlobalSimpleType type) {
        return null;
    }
/*
	public static QName findXSDType(ElementDecl element) {
//		XMLType type = element.getType();
//		Schema schema = type.getSchema();
//		String targetNamespace = schema.getTargetNamespace();
//		String typeName = type.getName();
//		if(BuiltInXSDTypes.SCHEMA_NAMESPACE.equals(targetNamespace)) {
//			if(type.getName() != null) {
//				QName typeQName = new QName(BuiltInXSDTypes.SCHEMA_NAMESPACE, type.getName());
//				if(BuiltInXSDTypes.isBuiltInType(typeQName)) {
//					return typeQName;
//				}
//			}
//		} else {
//			return getXSDType(element);
//		}
//		
//		return null;
		return getXSDType(element);
	}
	
	public static QName findXSDType(XMLType type) {
		return getXSDType(type);
	}
		
	private static QName getXSDType(Object obj) {
        XMLType type = null;
        
        if (obj instanceof ComplexType) {
            type = ((ComplexType) obj);
        } else if (obj instanceof ElementDecl) {
            type = ((ElementDecl) obj).getType();
        } else if (obj instanceof Group) {
            return null;
        } else if (obj instanceof AttributeDecl) {
            type = ((AttributeDecl) obj).getSimpleType();
        } else if (obj instanceof Wildcard) {
        	return BuiltInXSDTypes.ANY_TYPE;
        } else if (obj instanceof SimpleType) {
            type = ((SimpleType) obj);
         } else {
            return null;
        }
        
        
        if (type != null) {
            // for the simple types that are derived we show the exact type. 
             * for example the following derived simple type will have an xsdType of tns:mySType 
             * From an MNode point of view, (who is the sole consumer of this API) this is not sufficient
             * to support the usage of derived types. Correlations are created using the simpletypes, pre-defineds
             * or dervided. Correlation implementaion as of now in the BPEL editor cannot support this type 
             * of Derived types.
             * 
             <xs:element name="sType" type="tns:mySType" minOccurs="0"></xs:element>            

             <xs:simpleType name="mySType">
                 <xs:restriction base="xs:string">
                     <xs:pattern value="[a-z]"/>
                     </xs:restriction>
             </xs:simpleType>

             * Both MNode and this implementaion and probably this 
             * interface needs to be enhanced to support more advanced features of XSD. 
             *
        	Schema schema = type.getSchema();
            String typeName = type.getName();
    		
        	if(type.isAnyType()) {
        		return BuiltInXSDTypes.ANY_TYPE;
        	} else if(typeName != null) {
    			return new QName(schema.getTargetNamespace(), typeName);
    		} else {
    			return getXSDType(type.getBaseType());
    		}
    		
        } else {
            return null;
        }
    }
        
*/
}
