/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.model.nodes.impl;


import javax.xml.namespace.QName;
import org.netbeans.modules.bpel.xpath.model.node.visitor.NodeVisitor;
import org.netbeans.modules.bpel.xpath.model.nodes.XSDElementNode;
import org.netbeans.modules.bpel.xpath.model.xsd.visitor.NodeChildrenCreatorVisitor;

import org.netbeans.modules.xml.schema.model.Element;
import org.netbeans.modules.xml.schema.model.ElementReference;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.LocalType;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.TypeContainer;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;

/**
 *
 * @author radval
 *
 */
public abstract class XSDElementNodeImpl extends AbstractTreeNode implements XSDElementNode {
    
    private Element mElement;
    
    
    public XSDElementNodeImpl(Element element) {
        super(element);
        this.mElement = element;
    }
    
    public String getName() {
        return "UNKNOWN_ELEMENT";   // NOI18N
    }
    
    public Element getElement() {
        return this.mElement;
    }

    public QName getQName() {
        QName qName = null;
        if(this.mElement != null) {
        	SchemaModel sModel = null;
        	if(this.mElement instanceof ElementReference) {
            	ElementReference elementRef = (ElementReference) this.mElement;
            	NamedComponentReference<GlobalElement> geRef = elementRef.getRef();
            	if(geRef != null && geRef.get() != null) {
            		sModel = geRef.get().getModel();
            	}
            } else {
            	sModel = this.mElement.getModel();
            }
        	
            if(sModel != null) {
                Schema s = sModel.getSchema();
                if(s != null) {
                    String namespace = s.getTargetNamespace();
                    if(namespace != null) {
                        qName = new QName(namespace, getName());
                    }
                }
            }
        } else {
            qName = new QName(getName());
        }
        
        return qName;
    }

    protected void lazyLoadChildren() {
    }
    
    protected void lazyLoadChildren(TypeContainer typeContainer) {
        SchemaComponent sc = null;
        
        if (typeContainer.getType() != null) {
            GlobalType gt = typeContainer.getType().get();
            sc = gt;
        } else {
            LocalType lt = typeContainer.getInlineType();
            sc = lt;
        }
        
        if (sc != null) {
            NodeChildrenCreatorVisitor ncCreatorVisitor = new NodeChildrenCreatorVisitor(this);
            sc.accept(ncCreatorVisitor);
            
        }
    }
    
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }
}
