/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view.impl;


import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.Branches;
import org.netbeans.modules.bpel.model.api.CompletionCondition;
import org.netbeans.modules.bpel.model.api.FinalCounterValue;
import org.netbeans.modules.bpel.model.api.ForEach;
import org.netbeans.modules.bpel.model.api.StartCounterValue;
import org.netbeans.modules.bpel.xpath.view.AbstractBPELElementExpressionView;
import org.netbeans.modules.bpel.xpath.view.AbstractXPathExpressionUpdater;
import org.netbeans.modules.bpel.xpath.view.BPELElementXPathExpressionBuilder;
import org.netbeans.modules.bpel.xpath.view.DefaultMapperRule;
import org.netbeans.modules.bpel.xpath.view.expression.AbstractBPELMapperView;
import org.netbeans.modules.bpel.xpath.view.expression.impl.BPELForEachMapperView;
import org.netbeans.modules.bpel.xpath.view.expression.impl.BpelMapper;
import org.netbeans.modules.bpel.xpath.view.expression.impl.MapperView;

/**
 *
 * @author jsandusky
 *
 */
public class ForEachExpressionView extends AbstractBPELElementExpressionView {
    
    private AbstractBPELMapperView mMapperExpressionView;
    private BPELElementXPathExpressionBuilder mBuilder;
    
    
    public ForEachExpressionView(BpelEntity element) {
        super(element);
        mMapperExpressionView = new BPELForEachMapperView(element, element.getBpelModel());
        
        DefaultMapperRule mapperRule = createMapperRule(mMapperExpressionView.getBpelMapper());
        mMapperExpressionView.getMapper().getBasicMapper().setMapperRule(mapperRule);
    }
    
    /** @see AbstractExpressionView#getMappers()
     */
    public List<MapperView> getMappers() {
        List<MapperView> rl = new ArrayList<MapperView>();
        rl.add(mMapperExpressionView.getMapper());
        return rl;
    }
    
    public MapperView getActiveMapper() {
        return mMapperExpressionView.getMapper();
    }
    
    public JComponent getComponent() {
        return mMapperExpressionView.getMapper();
    }

    public DefaultMapperRule createMapperRule(BpelMapper bpelMapper) {
        mBuilder = new ForEachXPathExpressionBuilder(
                getBPELElement(), bpelMapper.getBasicMapper());
        AbstractXPathExpressionUpdater updater = new ForEachXPathExpressionUpdater(
                bpelMapper.getBasicMapper(), getBPELElement());
        return new DefaultMapperRule(bpelMapper, mBuilder, updater);
    }
    
    public void initialize(BpelEntity element) {
        super.initialize(element);
        mBuilder.initialize(element, element.getBpelModel());
        mMapperExpressionView.initialize(element, element.getBpelModel());
    }
    
    public void synchronizeExpressionView(BpelEntity parentOb, Object value) {
        BpelEntity parent = parentOb;

        if (parent instanceof ForEach) {
            ForEach forEach = (ForEach) parent;
            renderForEach(forEach);
        } else if (parentOb instanceof StartCounterValue) {
            ForEach forEach = findForEach(parentOb);
            if (forEach != null) {
                renderForEach(forEach);
            }
        } else if (parentOb instanceof FinalCounterValue) {
            ForEach forEach = findForEach(parentOb);
            if (forEach != null) {
                renderForEach(forEach);
            }
        } else if(parentOb instanceof CompletionCondition) {
            ForEach forEach = findForEach(parentOb);
            if (forEach != null) {
                renderForEach(forEach);
            }
        } else if(parentOb instanceof Branches) {
            ForEach forEach = findForEach(parentOb);
            if (forEach != null) {
                renderForEach(forEach);
            }
        }
    }
    
    private void renderForEach(ForEach forEach) {
        initialize(forEach);
        if (isInModel(forEach)) {
            ForEachRenderer renderer = new ForEachRenderer(
                    mMapperExpressionView.getMapper(), 
                    forEach);
            renderer.draw(forEach);
        }
    }
    
    private ForEach findForEach(BpelEntity entity) {
        while(entity != null && !(entity instanceof ForEach)) {
            entity = entity.getParent();
        }
        
        return (ForEach) entity;
    }
    
    public boolean canFindInSourceTree() {
        return true;
    }
    
    public boolean canFindInDestinationTree() {
        return false;
    }
}

