/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.iep.editor.designer;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.Dimension;
import java.beans.PropertyChangeSupport;
import javax.swing.JPanel;
import javax.swing.JDialog;
import javax.swing.JToolBar;

import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoOverview;
import com.nwoods.jgo.layout.JGoLayeredDigraphAutoLayout;

import org.openide.windows.WindowManager;
import org.openide.windows.TopComponent;
import org.openide.nodes.Node;


import org.netbeans.modules.iep.editor.tcg.model.TcgComponent;
import org.netbeans.modules.iep.editor.tcg.model.TcgProperty;
import org.netbeans.modules.iep.editor.tcg.ps.TcgComponentNode;

import org.netbeans.modules.iep.editor.model.Plan;
import org.netbeans.modules.iep.editor.model.ModelManager;
import org.netbeans.modules.iep.editor.tcg.ps.TcgComponentNodeView;
import java.io.File;
import java.util.Date;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;


public class PlanDesigner extends JPanel implements GuiConstants,HelpCtx.Provider  {
    private static final java.util.logging.Logger mLog = java.util.logging.Logger.getLogger(PlanDesigner.class.getName());

    public static final String PLAN_DESIGNER_CHANGE = "planDesignerChange";
    
    private Plan mPlan;
    
    private TcgComponent mComponent;
    
    private TcgComponentNodeView mComponentView;
    
    private TopComponent mTopComponent;
    
    private JToolBar mToolBar;
    
    private PdCanvas mCanvas;
    
    private StatusBar mStatusBar;
    
    protected PropertyChangeSupport mDesignerChangeSupport;

    public PdAction mCutAction = new PdAction(CUT_NAME, NbBundle.getMessage(PlanDesigner.class,"PlanDesigner.Cut_to_clipboard"), CUT_ICON, this) {
        public void actionPerformed(ActionEvent e) { 
            getCanvas().cut(); 
        }
        
        public boolean canAct() { 
            return super.canAct() && !getCanvas().getSelection().isEmpty() 
                && getCanvas().getDoc().isModifiable(); 
        }
    };  
    
    public PdAction mCopyAction = new PdAction(COPY_NAME, NbBundle.getMessage(PlanDesigner.class,"PlanDesigner.Copy_to_clipboard"), COPY_ICON, this) {
        public void actionPerformed(ActionEvent e) { 
            getCanvas().copy(); 
        }
        
        public boolean canAct() { 
            return super.canAct() && !getCanvas().getSelection().isEmpty(); 
        }
    };

    public PdAction mPasteAction = new PdAction(PASTE_NAME, NbBundle.getMessage(PlanDesigner.class,"PlanDesigner.Paste_to_canvas"), PASTE_ICON, this) {
        public void actionPerformed(ActionEvent e) { 
            getCanvas().paste(); 
        }
        
        public boolean canAct() { 
            return super.canAct() && getCanvas().getDoc().isModifiable() && getCanvas().canPaste(); 
        }
    };

    public PdAction mDeleteAction = new PdAction(DELETE_NAME, NbBundle.getMessage(PlanDesigner.class,"PlanDesigner.Delete_from_canvas"), DELETE_ICON, this) {
        public void actionPerformed(ActionEvent e) { 
            getCanvas().deleteSelection(); 
        }
        
        public boolean canAct() { 
            return super.canAct() && !getCanvas().getSelection().isEmpty() 
                && getCanvas().getDoc().isModifiable(); 
        } 
    };

    public PdAction mUndoAction = new PdAction(UNDO_NAME, NbBundle.getMessage(PlanDesigner.class,"PlanDesigner.Undo_last_change"), UNDO_ICON, this) {
        public void actionPerformed(ActionEvent e) { 
            getCanvas().getDocument().undo(); 
            PlanDesigner.this.refreshPropertyPane();
            PdAction.updateAllActions(getDesigner()); 
        }
        public boolean canAct() { 
            return super.canAct() && (getCanvas().getDocument().canUndo()); 
        }
    };

    public PdAction mRedoAction = new PdAction(REDO_NAME, NbBundle.getMessage(PlanDesigner.class,"PlanDesigner.Redo_last_undo"), REDO_ICON, this) {
        public void actionPerformed(ActionEvent e) { 
            getCanvas().getDocument().redo(); 
            PlanDesigner.this.refreshPropertyPane();
            PdAction.updateAllActions(getDesigner()); 
        }
        public boolean canAct() { 
            return super.canAct() && (getCanvas().getDocument().canRedo()); 
        }
    };
    
    private PdAction mOverviewAction = new PdAction(OVERVIEW_NAME, NbBundle.getMessage(PlanDesigner.class,"PlanDesigner.Overview"), OVERVIEW_ICON, this) {
        public void actionPerformed(ActionEvent e) { 
            overviewAction(); 
        } 
    };

    private PdAction mOrthoAction = new PdAction(ORTHOGONAL_LINK_NAME, NbBundle.getMessage(PlanDesigner.class,"PlanDesigner.Toggle_orthogonal_flows"), ORTHOGONAL_LINK_ICON, this) {
        public void actionPerformed(ActionEvent e) { 
            getCanvas().getDoc().toggleOrthogonalFlows(); 
        }
        public boolean canAct() { 
            return super.canAct() && getCanvas().getDoc().isModifiable(); 
        } 
    };

    private PdAction mAutoLayoutAction = new PdAction(AUTO_LAYOUT_NAME, NbBundle.getMessage(PlanDesigner.class,"PlanDesigner.Automatic_layout"), AUTO_LAYOUT_ICON, this) {
        public void actionPerformed(ActionEvent e) { 
            layerAction(); 
        } 
    };
    
    private PdAction mValidateAction = new PdAction(VALIDATE_NAME, NbBundle.getMessage(PlanDesigner.class,"PlanDesigner.Validate"), VALIDATE_ICON, this) {
        public void actionPerformed(ActionEvent e) { 
            getCanvas().validatePlan(); 
        } 
    };
    
    private JGoOverview mOverview;
    private JDialog mOverviewDialog;
    private void overviewAction() {
        if (mOverview == null) {
            mOverview = new JGoOverview();
            mOverview.setObserved(getCanvas());
            String title = NbBundle.getMessage(PlanDesigner.class,"PlanDesigner.Overview");
            try {
                title = mPlan.getFullName() + " " +NbBundle.getMessage(PlanDesigner.class,"PlanDesigner.Overview");
            } catch (Exception e) {
                e.printStackTrace();
                mLog.warning(e.getMessage());
            }
            mOverviewDialog = new JDialog(WindowManager.getDefault().getMainWindow(), title, false);
            mOverviewDialog.getContentPane().setLayout(new BorderLayout());
            mOverviewDialog.getContentPane().add(mOverview, BorderLayout.CENTER);
        }
        mOverviewDialog.pack();
        mOverviewDialog.setVisible(true);
    }

    private void layerAction() {
        PdModel doc = getCanvas().getDoc();
        doc.startTransaction();
        JGoLayeredDigraphAutoLayout l = new JGoLayeredDigraphAutoLayout(doc,
            30, 30,  JGoLayeredDigraphAutoLayout.LD_DIRECTION_RIGHT,
            JGoLayeredDigraphAutoLayout.LD_CYCLEREMOVE_DFS,
            JGoLayeredDigraphAutoLayout.LD_LAYERING_OPTIMALLINKLENGTH,
            JGoLayeredDigraphAutoLayout.LD_INITIALIZE_DFSOUT, 4,
            JGoLayeredDigraphAutoLayout.LD_AGGRESSIVE_FALSE);
        l.performLayout();
        if (doc.isOrthogonalFlows()) {
            // now update all links
            JGoListPosition pos = doc.getFirstObjectPos();
            while (pos != null) {
                JGoObject obj = doc.getObjectAtPos(pos);
                // only consider top-level objects
                pos = doc.getNextObjectPosAtTop(pos);
                if (obj instanceof JGoLink) {
                    JGoLink link = (JGoLink)obj;
                    link.portChange(null, JGoLink.ChangedOrthogonal, 0, null);
                }
            }
        }
        doc.endTransaction("Layout");
    }
    
    private JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.addSeparator();
        toolBar.add(mOrthoAction);
        toolBar.add(mAutoLayoutAction);
        toolBar.add(mOverviewAction);
        toolBar.addSeparator();
        toolBar.add(mValidateAction);
        toolBar.setBorderPainted(false);
        return toolBar;
    }        

    private void initializeLayout() {
        setLayout(new BorderLayout());

        // Right Panel
        JPanel thePanel = new JPanel();
        mCanvas = new PdCanvas();
        mCanvas.initialize(this);
        mToolBar = createToolBar();
        thePanel.setLayout(new BorderLayout());
        thePanel.add(BorderLayout.NORTH, mToolBar);
        thePanel.add(BorderLayout.CENTER, mCanvas);
        add(BorderLayout.CENTER, thePanel);

        mStatusBar = new StatusBar();
        mStatusBar.setMinimumSize(new Dimension(500, 500));
        add(BorderLayout.SOUTH, mStatusBar);
        
        mCanvas.setPreferredSize(thePanel.getPreferredSize());
        mCanvas.initializeDragDropHandling();
    }

    public PlanDesigner(TopComponent topComponent) {
        super();
        mDesignerChangeSupport = new PropertyChangeSupport(this);
        mTopComponent = topComponent;
        initializeLayout();
    }
    
    public void setDirty() {
        mDesignerChangeSupport.firePropertyChange(PLAN_DESIGNER_CHANGE, false, true);
        mStatusBar.setDirty(true);
    }
    
    public PropertyChangeSupport getPropertyChangeSupport() {
        return mDesignerChangeSupport;
    }
    
    public void save() {
        try {
            mCanvas.getDoc().store();
            Date planLastModified = mPlan.lastModified();
            File wsdlFile = mPlan.getWsdlFile();
            // Note that editor saves plan after saving its wsdl
            // Hence the only way wsdl has later modified time than plan is 
            // through modification outside editor
            if (wsdlFile.exists() && planLastModified.before(new Date(wsdlFile.lastModified()))) {
                String msg = NbBundle.getMessage(PlanDesigner.class, "PlanDesigner.WSDL_HAS_BEEN_MANUALLY_CHANGED_OVERWRITE", wsdlFile.getName());
                NotifyDescriptor d = new NotifyDescriptor.Confirmation(msg, NotifyDescriptor.YES_NO_CANCEL_OPTION);
                DialogDisplayer.getDefault().notify(d);
                if (NotifyDescriptor.YES_OPTION == d.getValue()) {
                    mPlan.saveWsdl();
                }         
           } else {
                mPlan.saveWsdl();
           }                  
           mPlan.save();
           mStatusBar.setDirty(false);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    public void setPlan(Plan plan) {
        if (plan == null) {
            String msg = NbBundle.getMessage(PlanDesigner.class, "PlanDesigner.DOC_CANNOT_BE_NULL");
            throw new IllegalArgumentException(msg);
        }
        mPlan = plan;
        mCanvas.setDoc(new PdModel(mPlan));
    }
    
    public Plan getPlan() {
        return mPlan;
    }
    
    public void destroy() {
        // Free all PdActions in thie designer instance
        PdAction.freeAllActions(this);
        
        org.netbeans.modules.iep.editor.designer.EventUtil.removeListeners(mDesignerChangeSupport);
        ModelManager.destroyModel(mPlan);
        mCanvas.destroy();
        if (mOverviewDialog != null) {
            mOverviewDialog.setVisible(false);
            mOverviewDialog.dispose();
            mOverviewDialog = null;
        }
        mPlan = null;
    }
    //=================================================================    
    public PdCanvas getCanvas() {
        return mCanvas;
    }
    
    public void showPropertyPane(TcgComponent component, TcgComponentNodeView view) {
        if (component == null) {
            return;
        }
        mComponent = component;
        mComponentView = view;
        refreshPropertyPane();
    }
    
    public void refreshPropertyPane() {
        if (mComponent == null) {
            return;
        }
        java.util.List keyList = new java.util.ArrayList();
        java.util.List propList = mComponent.getPropertyList();
        for (int i = 0, size = propList.size(); i < size; i++) {
            TcgProperty prop = (TcgProperty) propList.get(i);
            if (prop.getType().isReadable()) {
                keyList.add(prop.getName());
            }
        }
        mTopComponent.setActivatedNodes(new Node[]{new TcgComponentNode(mComponent, mPlan, mComponentView)});
    }

    public JToolBar getToolBar() {
        return mToolBar;
    }
    
    public HelpCtx getHelpCtx() {
        return new HelpCtx("iep_aboutpalettecan");  
	//return new HelpCtx("org.netbeans.modules.iep.editor.designer.PlanDesigner");
    }

    
}
    
