/*
 * The contents of this file are subject to the terms of the Common
 * Development and Distribution License (the License). You may not use this
 * file except in compliance with the License.  You can obtain a copy of the
 * License at http://www.netbeans.org/cddl.html

 * When distributing Covered Code, include this CDDL Header Notice in each
 * file and include the License. If applicable, add the following below the
 * CDDL Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"

 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved
 *
 */

package org.netbeans.modules.aspect.editor.model;

import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.transform.dom.DOMSource;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;

/**
 * This class represents a key expression.
 *
 * @author karthikeyan s
 */

//TODO this class may not be required, use xpathExpression
public class KeyExpression {
    
    String keyExpression;
    
    private XPathExpression xpathExpression;
    
    private XPathFactory xpfactory;
    
    private XPath path;
    
    /**
     * Creates a new instance of KeyExpression
     */
    public KeyExpression(Element exp) {
        init(exp);
    }
    
    public KeyExpression() {
        
    }
    
    private void init(Element keyElement) {
        keyExpression = keyElement.getAttribute(AspectConstants.XPATH_ATTR_KEY_EXPRESSION);
        if(keyExpression == null || "".equals(keyExpression)) {
            // default the keyExpression to something.
            keyExpression = "//*";
        }
        xpfactory = XPathFactory.newInstance();
        path = xpfactory.newXPath();
        try {
            xpathExpression = path.compile(keyExpression);
        } catch (XPathExpressionException e) {
            // TODO Auto-generated catch block
            //ignore
        }
    }
    
    public boolean evaluate(DOMSource source) {
        try {
            Node src = source.getNode();
            NodeList nl = (NodeList) getXPathExpression().evaluate(src, XPathConstants.NODESET);
            if (nl.getLength() > 0) {
                return true;
            }
        } catch (XPathExpressionException e) {
            // TODO Auto-generated catch block
            //ignore
        }
        return false;
    }
    
    public void setKeyExpression(String exp) {
        path = xpfactory.newXPath();
        try {
            xpathExpression = path.compile(exp);
        } catch(XPathExpressionException e) {
            //ignore
        }
    }
    
    public String getKeyExpression() {
        return keyExpression;
    }
    
    public void setXPathExpression(XPathExpression expression) {
        xpathExpression = expression;
    }
    
    public XPathExpression getXPathExpression() {
        return xpathExpression;
    }
    
    public String toXMLString() {
        StringBuffer xmlString = new StringBuffer();
        if(xpathExpression == null || keyExpression == null) {
            return "<" + AspectConstants.XPATH_TAG +"/>\n";
        }
        xmlString.append("<" + AspectConstants.XPATH_TAG + " " +
                AspectConstants.XPATH_ATTR_KEY_EXPRESSION +"=\""+keyExpression+"\" />\n");
        return xmlString.toString();
    }
}