/*
 * AspectPinWidget.java
 * 
 * Created on May 22, 2007, 10:42:36 AM
 * 
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.netbeans.modules.aspect.editor.widgets;

import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.vmd.VMDPinWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

/**
 *
 * @author Manish
 */
public class AspectPinWidget extends VMDPinWidget {

    private LabelWidget nameWidget;

    /**
     * Creates a pin widget.
     * @param scene the scene
     */
    public AspectPinWidget (Scene scene) {
        super (scene);

        //setBorder (AspectNodeWidget.BORDER);
        //setBackground (AspectNodeWidget.COLOR_SELECTED);
        setOpaque (false);
        setLayout (LayoutFactory.createHorizontalFlowLayout (LayoutFactory.SerialAlignment.CENTER, 8));
        //addChild (glyphsWidget = new EDMGlyphSetWidget (scene));
        addChild (nameWidget = new LabelWidget (scene));        

        notifyStateChanged (ObjectState.createNormal (), ObjectState.createNormal ());
    }

    /**
     * Called to notify about the change of the widget state.
     * @param previousState the previous state
     * @param state the new state
     */
    protected void notifyStateChanged (ObjectState previousState, ObjectState state) {
        setOpaque (state.isSelected ());
//        setBorder (state.isFocused () || state.isHovered () ? AspectNodeWidget.BORDER_HOVERED : AspectNodeWidget.BORDER);
//        LookFeel lookFeel = getScene ().getLookFeel ();
//        setBorder (BorderFactory.createCompositeBorder (BorderFactory.createEmptyBorder (8, 2), lookFeel.getMiniBorder (state)));
//        setForeground (lookFeel.getForeground (state));
    }

    /**
     * Returns a pin name widget.
     * @return the pin name widget
     */
    public Widget getPinNameWidget () {
        return nameWidget;
    }

    /**
     * Sets a pin name.
     * @param name the pin name
     */
    public void setPinName (String name) {
        nameWidget.setLabel (name);
    }

    /**
     * Returns a pin name.
     * @return the pin name
     */
    public String getPinName () {
        return nameWidget.getLabel();
    }

}
