/* *************************************************************************
 *
 *          Copyright (c) 2002, SeeBeyond Technology Corporation,
 *          All Rights Reserved
 *
 *          This program, and all the routines referenced herein,
 *          are the proprietary properties and trade secrets of
 *          SEEBEYOND TECHNOLOGY CORPORATION.
 *
 *          Except as provided for by license agreement, this
 *          program shall not be duplicated, used, or disclosed
 *          without  written consent signed by an officer of
 *          SEEBEYOND TECHNOLOGY CORPORATION.
 *
 ***************************************************************************/
package org.netbeans.modules.aspect.project.anttasks;

import java.util.Map;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.tools.ant.BuildException;

/**
 *
 * @author karthikeyan s
 */
public class JBIWriter {
    
    /** Creates a new instance of JBIWriter */
    public JBIWriter() {
    }
    
    public String generateJBIString(Map prefixTable, Map nsTable, List aspectEntryList) {
        StringBuffer sb = new StringBuffer();
        // Generate jbi.xml
        // <?xml version='1.0'?>
        // <jbi version="1.0"
        //         xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
        //         xmlns="http://java.sun.com/xml/ns/jbi"
        //         xsi:schemaLocation="http://java.sun.com/xml/ns/jbi jbi.xsd"
        //         xmlns:ns0=${ns1} ... xmlns:nsN=${nsN} >
        //     <services binding-component="false">
        //         <provides interface-name=port-type service-name=partner-link endpoint-name=role-name/>
        //         <consumes interface-name=port-type service-name=partner-link endpoint-name=role-name link-type="standard"/>
        //     </services>
        // </jbi>
        try {
            sb.append("<!--start of generated code -->\n");
            sb.append("<jbi version=\"1.0\"\n");
            sb.append("        xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
            sb.append("        xmlns=\"http://java.sun.com/xml/ns/jbi\"\n");
            sb.append("        xsi:schemaLocation=\"http://java.sun.com/xml/ns/jbi jbi.xsd\"\n");
            for (int i = 0, I = nsTable.size(); i < I; i++) {
                String ns = "ns" + (i + 1);
                sb.append("        xmlns:" + ns + "=\"" + prefixTable.get(ns) + "\"");
                if (i < I - 1) {
                    sb.append("\n");
                }
            }
            sb.append(">\n");
            sb.append("    <services binding-component=\"false\">\n");
            // Generate all <provides> first
            for (int i = 0, I = aspectEntryList.size(); i < I; i++) {
                AspectMapEntry xme = (AspectMapEntry)aspectEntryList.get(i);
                if(xme.getType().equals(AspectMapEntry.INPUT_MESSAGE_TYPE)) {
                    sb.append("        <provides interface-name=\"" + getDottedQName(xme.getPortType(), nsTable));
                    sb.append("\" service-name=\"" + getDottedQName(xme.getPartnerLink(), nsTable));
                    sb.append("\" endpoint-name=\"" + xme.getRoleName());
                    sb.append("\"/>\n");
                }
            }
            // Generate all <consumes> second
            for (int i = 0, I = aspectEntryList.size(); i < I; i++) {
                AspectMapEntry xme = (AspectMapEntry)aspectEntryList.get(i);
                if (xme.getType().equals(AspectMapEntry.OUTPUT_MESSAGE_TYPE)) {
                    sb.append("        <consumes interface-name=\"" + getDottedQName(xme.getPortType(), nsTable));
                    sb.append("\" service-name=\"" + getDottedQName(xme.getPartnerLink(), nsTable));
                    sb.append("\" endpoint-name=\"" + xme.getRoleName());
                    sb.append("\" link-type=\"standard\"/>\n");
                }
            }
            sb.append("    </services>\n");
            sb.append(" </jbi>\n");
            sb.append("<!--end of generated code -->\n");
        } catch (Exception e) {
            throw new BuildException(e.getMessage());
        }
        return sb.toString();
    }
    
    
    private String getDottedQName(QName qn, Map nsTable) {
        String ns = qn.getNamespaceURI();
        String prefix = (String)nsTable.get(ns);
        if (prefix == null) {
            return qn.getLocalPart();
        }
        return prefix + ":" + qn.getLocalPart();
    }
}